package nanomunchers.bot;

import heurgame.PlayerToken;

import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

/*
 * Created on Oct 27, 2004
 */

/**
 * Holds all of the Nanobots and knows what bots are associated
 * with a given PlayerToken.
 * 
 * @author David Kaplin
 */
public class NanoBotWrangler {
    private Hashtable playerToBots;
    /**
     * Initializes the BotWrangler
     */
    public NanoBotWrangler(){
        playerToBots = new Hashtable();
    }
    /**
     * Adds a nanomuncher in the name of the owner if
     * there are no other bots of the owner's at that location.
     * 
     * @param owner	of the bot in question
     * @param newBot bot in question
     * @return true if there is no other bot at that point
     */
    public synchronized boolean addNanoBot(PlayerToken owner, NanoBot newBot){
        synchronized (playerToBots){
        if (playerToBots.get(owner)==null){
            playerToBots.put(owner,new Vector());
        }
        Vector botVector = (Vector)playerToBots.get(owner);
        boolean dupes = false;
        for(int i=0;i<botVector.size();i++){
            NanoBot n = (NanoBot)botVector.get(i);
            dupes =  dupes ||(n.location.equals(newBot.location));
        }
        if (dupes==false){
            botVector.add(newBot);
            playerToBots.put(owner,botVector);
        }
        return !dupes;
        }
    }
    
    /**
     * @param owner of the bots
     * @return bots that are owned by the owner, null if none
     */
    public synchronized Vector getNanoBots(PlayerToken owner){
        synchronized (playerToBots){
        
        Vector ret = (Vector) playerToBots.get(owner);
        if (ret==null){
            if (playerToBots.get(owner)==null){
                playerToBots.put(owner,new Vector());
            }
            
        }
        ret = (Vector) playerToBots.get(owner);
        return ret;
        }
    }
    /**
     * If different players have any bots in the same location,
     * this is where they are removed from play. 
     */
    public void removeDuplicates(){
        Set players = playerToBots.keySet();
        Hashtable seen = new Hashtable();
        Vector kill = new Vector();
        Iterator piter = players.iterator();
        while(piter.hasNext()){
            PlayerToken examine = (PlayerToken)piter.next();
            Vector botCheck = (Vector)playerToBots.get(examine);
            for(int i=0;i<botCheck.size();i++){
                NanoBot b = (NanoBot)botCheck.get(i);
                Point watch =b.getCurrentLocation().getPoint(); 
                if (seen.get(watch)==null){
                    seen.put(watch,new Boolean(true));
                }else{
                    kill.add(watch);
                }
            }
        }
        if (kill.size()==0){
            return;
        }
        Hashtable newbots = new Hashtable();
        piter = players.iterator();
        while(piter.hasNext()){
            PlayerToken examine = (PlayerToken)piter.next();
            Vector botCheck = (Vector)playerToBots.get(examine);
            Vector savedBots = new Vector();
            for(int i=0;i<botCheck.size();i++){
                NanoBot b = (NanoBot)botCheck.get(i);
                Point watch =b.getCurrentLocation().getPoint(); 
                if (kill.contains(watch) == false){
                    savedBots.add(b);
                }
            }
            newbots.put(examine,savedBots);
        }
        playerToBots = newbots;
    }
}
