package nanomunchers.ui;

import heurgame.HuClient;
import heurgame.HuReceptor;
import heurgame.ui.builder.ComponentOrientedBuilder;
import heurgame.ui.builder.ZeroLayoutBuilder;

import java.awt.Frame;
import java.awt.List;
import java.awt.Point;

import nanomunchers.graph.Graph;
/*
 * Created on Oct 30, 2004
 */

/**
 * The actual window and direction choices to be presented to the user
 * @author David Kaplin
 */
public class NanoInputFrame implements HuReceptor {
    private List moveList;
    private NanoDecisionPanel nanoDecision;
    private HuClient contact;
    private ComponentOrientedBuilder aBuilder;
    private int productFrame;
    
    /**
     * @param board to be shown to the user
     */
    public void setGraph(Graph board){
        nanoDecision.setGraph(board);
    }
    /**
     * @param cBuilder should be a valid an existing component oriented builder
     */
    public NanoInputFrame(ComponentOrientedBuilder cBuilder){
        aBuilder = cBuilder;
        nanoDecision = new NanoDecisionPanel();
        moveList = new List();
        moveList.add("Up");
        moveList.add("Left");
        moveList.add("Down");
        moveList.add("Right");
        productFrame = cBuilder.buildScreen("(untitled)");
        int raiseAction = cBuilder.buildAction("Raise",new Runnable(){
            public void run(){
                int item = moveList.getSelectedIndex(); 
                if (item != -1 || item > 0){
                    String itemText = moveList.getItem(item);
                    moveList.remove(item);
                    moveList.add(itemText,item-1);
                    moveList.select(item-1);
                }
            }
        });
        int lowerAction = cBuilder.buildAction("Lower",new Runnable(){
            public void run(){
                int item = moveList.getSelectedIndex(); 
                if ((item != -1) || 
                        (item < (moveList.getItemCount()-1))){
                    String itemText = moveList.getItem(item);
                    moveList.remove(item);
                    moveList.add(itemText,item+1);
                    moveList.select(item+1);
                }
            }
        });
        int sendAction= cBuilder.buildAction("Send Move",new Runnable(){
            public void run(){
                boolean chosePoint = nanoDecision.commitPoint();
                if (chosePoint==false){
                    return;
                }
                Point p = nanoDecision.getRecentPoint();
                StringBuffer moveText = new StringBuffer();
                moveText.append(p.x);
                moveText.append(" ");
                moveText.append(p.y);
                moveText.append(" ");
                for(int i=0;i<moveList.getItemCount();i++){
                    moveText.append(moveList.getItem(i).charAt(0));
                    if (i+1!=moveList.getItemCount()){
                        moveText.append(" ");                        
                    }
                }
                contact.fromOutside(""+moveText);
                aBuilder.getScreen(productFrame).hide();           
            }
        }); 
        
        ZeroLayoutBuilder zBuilder = new ZeroLayoutBuilder(cBuilder);
        int moveRegion = cBuilder.buildRegion("moves");
        zBuilder.startRegion(moveRegion);
        zBuilder.setMainRegion(aBuilder.buildWrappedComponent(moveList));
        zBuilder.addToCommands(raiseAction);
        zBuilder.addToCommands(lowerAction);
        zBuilder.finishRegion(moveRegion);
        
        zBuilder.startRegion(productFrame);
        zBuilder.setMainRegion(cBuilder.buildWrappedComponent(nanoDecision));
        zBuilder.setLeftRegion(moveRegion);
        zBuilder.addToCommands(sendAction);
        zBuilder.finishRegion(productFrame);
        
        aBuilder.getScreen(productFrame).setSize(500,400);
    }
    public Frame getInputFrame(){
        return aBuilder.getScreen(productFrame);
    }
    /** 
     * Shows the screen to the user.
     * @see heurgame.HuReceptor#captureMove(heurgame.HuClient)
     */
    public void captureMove(HuClient h) {
        contact = h;
        Frame frm  = aBuilder.getScreen(productFrame);
        frm.setTitle(h.getName()+"'s Move");
        frm.show();
    }
}
