#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>

int begin, end, seqFrom, seqTo, seqlen, numseqs;
char name[1024], **seqs;

int getLength (char *filename){
  FILE *file;
  char buffer[1024], ch;
  int length = 0;

  file = fopen (filename, "r"); assert (file);
  fgets (buffer, 1024, file);
  while (!feof (file)){
    ch = fgetc (file);
    if (ch == '>') break;
    if (isalpha (ch) || ch == '.' || ch == '-') length++;
  }
  fclose (file);

  return length;
}

void readfile (char *filename){
  FILE *file;
  char buffer[1024], ch;
  int i;

  numseqs = 0;
  seqlen = getLength (filename);
  strcpy (name, "");
  seqs = (char **) malloc (sizeof (char *) * 1); assert (seqs);
  seqs[0] = (char *) malloc (sizeof (char) * seqlen);

  file = fopen (filename, "r"); assert (file);
  while (!feof (file)){
    i = 0;
    fgets (buffer, 1024, file);
    if (strlen (name) == 0) strcpy (name, buffer);
    if (feof (file)) break;
    numseqs++;
    if (numseqs > 1){
      seqs = (char **) realloc (seqs, sizeof (char *) * numseqs); assert (seqs);
      seqs[numseqs - 1] = (char *) malloc (sizeof (char) * seqlen); assert (seqs[numseqs - 1]);
    }
        
    while (!feof (file)){
      ch = fgetc (file);
      if (ch == '>') break;
      if (isalpha (ch) || ch == '.' || ch == '-'){
	assert (i < seqlen);
	seqs[numseqs - 1][i] = ch;
	i++;
      }
    }
    if (ch == '>') ungetc (ch, file);
    assert (i == seqlen);
  }
  fclose (file);
}

void print (void){
  int i = 0, pos = 0, written = 0, min = -1, max = -1;

  assert (seqFrom >= 0 && seqFrom < numseqs);
  assert (seqTo >= 0 && seqTo < numseqs);

  for (i = 0; i < seqlen; i++){
    if (isalpha (seqs[seqTo][i])) pos++;
    if (isalpha (seqs[seqFrom][i])){
      if (min < 0) min = pos;
      max = pos;
    }
  }
  printf ("%d %d\n", min, max);
}

int main (int argc, char** argv){
  int i;

  if (argc != 4){
    fprintf (stderr, "Usage:\n\ngetranges multi_fasta_file seqfrom seqto\n");
    exit (1);
  }

  seqFrom = atoi (argv[2]);
  seqTo = atoi (argv[3]);

  readfile (argv[1]);
  print ();

  for (i = 0; i < numseqs; i++) free (seqs[i]);
  free (seqs);
}






