import Tkinter, tkFileDialog, tkSimpleDialog
import Global as gl
import numpy as np
import csv

def startGUI():
    file_opt = options = {}
    options['defaultextension'] = '.csv'
    options['filetypes'] = [('all files', '.*'), ('text files', '.csv')]
    options['initialfile'] = 'myOutput.csv'
    
    def askopenfile():
        gl.inputFile= tkFileDialog.askopenfile(mode='r', **file_opt)
        
    def asksaveasfile():
        gl.saveFile= tkFileDialog.asksaveasfile(mode='w', **file_opt)
        gl.saveFileName= str(gl.saveFile).split(',')[0].split("'")[1]
        gl.outputFile = csv.writer(gl.saveFile)
        
    def ok():
        gl.n_stream = tkSimpleDialog.askinteger( "Stream Number","Please enter the number of streams:")
        gl.streamSize = tkSimpleDialog.askinteger( "Stream Size","Please enter the size of each stream:")
        gl.bw = tkSimpleDialog.askinteger( "Basic Window","Please enter the basic window:")
        gl.sw = tkSimpleDialog.askinteger( "Sliding Window","Please enter the sliding window:")
        gl.nb = np.floor(gl.sw/gl.bw)
        gl.correlationThreshold = tkSimpleDialog.askfloat( "Threshold","Please enter the correlation threshold (Max is 1):")
        root.quit()
    
    root = Tkinter.Tk()
    root.title("New York University")
    root.geometry("450x200")    
    Tkinter.Label(root, text="Statstream",font = "Helvetica 26 bold italic").pack(side="top")
    Tkinter.Button(root,text='Input Stream File', command=askopenfile).pack(side="left")
    Tkinter.Button(root,text='Output Correlations File', command=asksaveasfile).pack(side="right")
    Tkinter.Button(root,text='Proceed', command=ok).pack(side="bottom")
    root.mainloop()
