import pygame

class Item:
	radius = 5

	def __init__(self, application, stream_id1, stream_id2, begin_time_point, end_time_point, correlation_coefficient):
		self.application = application

		self.stream_id1 = stream_id1
		self.stream_id2 = stream_id2
		self.begin_time_point = begin_time_point
		self.end_time_point = end_time_point
		self.correlation_coefficient = correlation_coefficient

		self.pos = (0, 0)
		self.is_mouse_over = False
	# __init__

	@staticmethod
	def load_image(application, image_name='points.png'):
		Item.image = application.image_loader.get(image_name)
		Item.image.convert()
	# load_image

	def update(self):
		self.is_mouse_over = False
		self.pos = self.application.item_manager.get_pos(self)
	# update

	def draw(self, surface, real_surface):
		index = 0
		if self.is_mouse_over: index = Item.image.get_width()/2

		surface.blit(
			Item.image, 
			(int(self.pos[0]-Item.image.get_width()/4), int(self.pos[1]-Item.image.get_height()/2), Item.image.get_width(), Item.image.get_height()), 
			(index, 0, Item.image.get_width()/2, Item.image.get_height())
		)

		if self.is_mouse_over:
			self.application.to_blit_surface = self.application.font_item.render(str(self.correlation_coefficient), 1, (0, 0, 0), (255, 255, 255))
			self.application.to_blit_pos = (int(self.pos[0]+20+self.application.grid.rect.x), int(self.pos[1]+self.application.grid.rect.y))

			self.draw_right(real_surface)
		# if
	# draw

	def in_time(self):
		current_time = self.application.slider.times[self.application.slider.current_time]
		if current_time >= self.begin_time_point and current_time <= self.end_time_point:
			return True
		# if

		return False
	# in_time

	def mouse_over(self):
		mouse_pos = pygame.mouse.get_pos()
		mouse_pos = mouse_pos[0]-self.application.grid.rect.x, mouse_pos[1]-self.application.grid.rect.y

		if (mouse_pos[0]-self.pos[0])**2 + (mouse_pos[1]-self.pos[1])**2 <= Item.radius**2:
			self.is_mouse_over = True
			return True
		# if

		return False
	# mouse_over

	def draw_right(self, surface):
		surface.blit(self.application.label_coefficient, self.application.label_coefficient_pos)

		label = self.application.font_item.render(str(self.correlation_coefficient), 1, (255, 255, 255))

		pygame.draw.rect(surface, (0, 0, 0), (int(self.application.label_coefficient_pos[0] - (label.get_width()-self.application.label_coefficient.get_width())/2 - 10), int(self.application.label_coefficient_pos[1]+30-10), label.get_width()+20, label.get_height()+20))

		surface.blit(label, (int(self.application.label_coefficient_pos[0] - (label.get_width()-self.application.label_coefficient.get_width())/2), int(self.application.label_coefficient_pos[1]+30)))
	# draw_right
# Item