from button import Button

class ButtonManager:
	def __init__(self, application):
		self.application = application

		self.items = []

		self.left_button = None
		self.right_button = None
	# __init__

	def add(self, item):
		self.items.append(item)
	# add

	def update(self):
		for item in self.items:
			item.update()
		# for

		for item in self.items:
			if item.mouse_over(): return
		# for
	# update

	def draw(self, surface):
		for item in self.items:
			item.draw(surface)
		# for
	# draw

	def mouse_down(self):
		for item in self.items:
			if item.is_mouse_over:
				item.mouse_down()
				return
			# if
		# for
	# mouse_down

	def mouse_up(self):
		for item in self.items:
			if item.is_mouse_over:
				item.mouse_up()
				return
			# if
		# for
	# mouse_up

	def key_left(self):
		if self.left_button:
			self.left_button.mouse_down()
		# if
	# key_left

	def key_right(self):
		if self.right_button:
			self.right_button.mouse_down()
		# if
	# key_right
# ButtonManager