import pygame

class Button:
	def __init__(self, application, slider, image_path='slider_buttons.png', pos=None, index=0):
		self.application = application

		self.image = application.image_loader.get(image_path)

		if pos:
			self.pos = pos
		else:
			side = -1 if index == 0 else 1
			self.pos = (int(slider.pos[0]-self.image.get_width()/4+side*application.grid.rect.width/2), int(slider.pos[1]-self.image.get_height()/4))
		# if
		self.index = index

		self.is_mouse_over = False
	# __init__

	def update(self):
		self.is_mouse_over = False
	# update

	def draw(self, surface):
		surface.blit(self.image, self.pos, (self.index*self.image.get_width()/2, self.is_mouse_over*self.image.get_height()/2, self.image.get_width()/2, self.image.get_height()/2))
	# draw

	def mouse_over(self):
		mouse_pos = pygame.mouse.get_pos()

		if (mouse_pos[0]-self.pos[0]-self.image.get_width()/4)**2 + (mouse_pos[1]-self.pos[1]-self.image.get_height()/4)**2 <= (self.image.get_width()/4)**2:
			self.is_mouse_over = True
			return True
		# if

		return False
	# mouse_over

	def mouse_down(self):
		if self.index == 0:
			self.application.slider.backward()
		else:
			self.application.slider.forward()
		# if
	# mouse_down

	def mouse_up(self): pass
	# mouse_up
# Button