from __future__ import division
import startGUI as sGUI
import os

sGUI.startGUI()

import Global as gl
import BasicWindow as b1
import SketchModule as sk
import numpy as np
import Grid as gri
import fixTheData1 as fxd

# INITIALIZATION
gl.outputFile.writerow(["streamID1","streamID2","Begin Time Point","End Time Point","Correlation Coefficient"])
gl.data = np.empty(gl.n_stream,dtype=object)
gl.uk = sk.generateRandomVector(gl.numSketch, gl.bw)
gl.bi = sk.generateRandomVector(gl.numSketch, gl.nb)
gl.sumu = np.sum(gl.uk, axis=1)
gl.uswk = sk.computeFinalRandomVectorSW(gl.bi, gl.uk)

#initializing the data structure to hold the sketch class for every stream
#np.ndarray.fill(gl.data, sk.Sketch() )
for i in range(gl.n_stream):
    gl.data[i]=sk.Sketch()

#instances
for i in range(gl.n_stream):
    sk.build(fxd.dataAsNumpy[i][0:gl.sw],i)
    
# Initialize the grid structure, set up the variables.
g = gri.Grid(gl.correlationThreshold, gl.c, gl.f)

# Fill the neighbors data structure in order to hold every possible combination for every position
# in the grid.
g.computNeighbor()
for i in range(gl.n_stream):
    g.distributeQuery(gl.n_stream, i, 0)

#the size of the streams
m=gl.streamSize-1
m=int(m/gl.bw)

readpointer = gl.sw
currTime = gl.bw


for i in range( int(m-gl.nb)):
    print "+++++++++++++++++++++++++++++++++++++++++++Report for time %.5f ---- %.5f" % (currTime, currTime+gl.sw)
    g.redreshGrid()
    for index in range(gl.n_stream):
        sk.batchUpdate(index, fxd.dataAsNumpy[index][readpointer:readpointer+gl.bw])
        g.distributeQuery(gl.n_stream, index, currTime)
          
    currTime += gl.bw
    readpointer += gl.bw

gl.saveFile.close()
command = "./csv-gui/csv-gui.py "+gl.saveFileName
os.system(command)

