import pygame

from grid import Grid

class Slider:
	selector_color = (244, 164, 96)
	selector_size = (80, 80)
	selector_width = 2
	time_color = (255, 165, 0)
	offset = 3

	def __init__(self, application, text_time, pos=None):
		self.application = application
		self.label_time = self.application.font_slider.render(text_time, 1, Slider.time_color)

		if pos:
			self.pos = pos
		else:
			self.pos = (application.size[0]/2, application.size[1]*3/4+Grid.border+100)
		# if
		self.times = []
		self.current_time = 0

		self.button = self.application.image_loader.get('slider_buttons.png')

		self.gradient_right = pygame.Surface(Slider.selector_size, flags=pygame.SRCALPHA)
		for i in range(Slider.selector_size[0]):
			alpha = i*10 if i*10 <= 255 else 255 
			pygame.draw.line(self.gradient_right, (0, 0, 0, alpha), (i, 0), (i, Slider.selector_size[1]))
		# for

		self.gradient_left = pygame.Surface(Slider.selector_size, flags=pygame.SRCALPHA)
		for i in range(Slider.selector_size[0]):
			alpha = i*10 if i*10 <= 255 else 255 
			pygame.draw.line(self.gradient_left, (0, 0, 0, alpha), (Slider.selector_size[0]-i, 0), (Slider.selector_size[0]-i, Slider.selector_size[1]))
		# for
	# __init__

	def build_times(self, times):
		self.times = list(set(times))
		self.times.sort()
	# build_times

	def draw(self, surface):
		label = self.application.font_slider.render(str(self.times[self.current_time]), 1, Slider.time_color)
		surface.blit(label, (int(self.pos[0]-label.get_width()/2), int(self.pos[1]-label.get_height()/2)))

		width = 0
		for index, time in enumerate(self.times_beyond()):
			label = self.application.font_slider.render(str(time), 1, Slider.time_color)
			surface.blit(label, (int(self.pos[0]+Slider.selector_size[0]-label.get_width()/2+width), int(self.pos[1]-label.get_height()/2)))

			width += label.get_width()+20
		# for

		width = 0
		for index, time in enumerate(self.times_behind()):
			label = self.application.font_slider.render(str(time), 1, Slider.time_color)
			surface.blit(label, (int(self.pos[0]-Slider.selector_size[0]-label.get_width()/2-width), int(self.pos[1]-label.get_height()/2)))

			width += label.get_width()+20
		# for

		surface.blit(self.label_time, (int(self.pos[0] - self.label_time.get_width()/2), int(self.pos[1] + Slider.selector_size[1]/2 + 10)))

		self.draw_gradients(surface)
		self.draw_selector(surface)
	# draw

	def draw_gradients(self, surface):
		surface.blit(self.gradient_right, (self.pos[0]+self.application.grid.rect.width/2-Slider.selector_size[0], self.pos[1]-Slider.selector_size[1]/2))

		surface.blit(self.gradient_left, (self.pos[0]-self.application.grid.rect.width/2, self.pos[1]-Slider.selector_size[1]/2))
	# draw_gradients

	def draw_selector(self, surface):
		pygame.draw.rect(surface, Slider.selector_color, ((int(self.pos[0]-Slider.selector_size[0]/2), int(self.pos[1]-Slider.selector_size[1]/2)), Slider.selector_size), Slider.selector_width)
	# draw_selector

	def times_beyond(self):
		if self.current_time >= len(self.times)-1: return []

		first = self.current_time + 1
		if first >= len(self.times)-1: return [self.times[first]]

		if self.current_time+Slider.offset < len(self.times):
			last = self.current_time+Slider.offset
		else:
			last = len(self.times)-1
		# if

		return self.times[first:last+1]
	# times_beyond

	def times_behind(self):
		if self.current_time == 0: return []

		first = self.current_time - 1
		if first == 0: return [self.times[first]]

		if self.current_time-Slider.offset >= 0:
			last = self.current_time-Slider.offset
		else:
			last = 0
		# if

		times = self.times[last:first+1]
		times.reverse()
		return times
	# times_behind

	def forward(self):
		if self.current_time == len(self.times)-1: return

		self.current_time += 1
		self.application.item_manager.load_active_items()
	# forward

	def backward(self):
		if self.current_time == 0: return

		self.current_time -= 1
		self.application.item_manager.load_active_items()
	# backward
# Slider