//make plots and send follow-up emails also make daily plots

#include <sys/types.h>
#include <time.h>
#include <string>
#include <getopt.h>
#include <zlib.h>
#include <iostream.h>
#include <fstream.h>
#include <unistd.h>
#include "Reconstruction.h"
#include "Offline.h"    
#include "TROOT.h"
#include "TFile.h"
#include "TH1.h" 
#include "TCanvas.h"
#include "TH2.h"
#include "TStyle.h"
#include "TFrame.h"
#include "TApplication.h"
#include "TApplicationImp.h"
#include "TNtuple.h"
#include "TPostScript.h"
#include "TText.h"
#include "TLine.h"
#include "TGraph.h"
#include "TAxis.h"
#include "grb.h"

//void grb_finder_plotter(char *filename, int hid){
void main(int argc,char *argv[]){

  int     i,j,k,month,day,year,start;
  char    hname[300],filename[300],pname[300];
  char    psname[300],rname[300],rname2[300];
  char    jpgname[300],command[300],psopen[300],htmlname[300];
  char    textline[1000],mfile[300],dir[300],pubdir[300];
  int     hid=2001,julDate=2345,ultra=1,type,nbins;
  float   xmin,xmax,ymin,ymax,x1,x2,y1,y2,corr,halfbin,prob,lmax;
  float   tk,max,berr,bc,obc,nerr,dur,ra,dec,sig,bkg,zen,rate;
  int     run,subrun,NDURa,count;

  
  sscanf(argv[1],"%d",&hid);
  sscanf(argv[2],"%d",&julDate);
  sscanf(argv[3],"%d",&ultra);
  sscanf(argv[4],"%d",&type);
  sscanf(argv[5],"%d",&month);
  sscanf(argv[6],"%d",&day);
  sscanf(argv[7],"%d",&year);
  sscanf(argv[8],"%d",&NDURa);
  sscanf(argv[9],"%f",&dur);
  sscanf(argv[10],"%f",&ra);
  sscanf(argv[11],"%f",&dec);
  sscanf(argv[12],"%f",&zen);
  sscanf(argv[13],"%f",&sig);
  sscanf(argv[14],"%f",&bkg);
  sscanf(argv[15],"%g",&prob);
  sscanf(argv[16],"%f",&rate);
  sscanf(argv[17],"%d",&run);
  sscanf(argv[18],"%d",&subrun);
  
  FILE    *fp,*fph,*fpw;
  TH1F    *hcand1,*hcand2,*hcand3,*hcand4,*hcand6,*hcand7,*h[1000];
  TH1F    *hs[NDURa],*hb[NDURa],*hp[NDURa];
  TH2F    *hcand5;
  TCanvas *display;
  TAxis   *x,*y;
  
  gROOT->SetBatch(kTRUE);

  if(ON){
    sprintf(dir,"/home/daq/log/");
    sprintf(pubdir,"/home/daq/public_html/");
  }
  else{
    sprintf(dir,"./");
    sprintf(pubdir,"./pub/");
  }

  if(type==1){//candidate grb

    if(ultra){
      sprintf(rname,"%s/grb_ultrashort_cand_%05d_%03d.root",dir,julDate+10000,hid-2000);
      sprintf(pname,"%s/grb_ultrashort_cand_%05d_%03d.his",dir,julDate+10000,hid-2000);
      sprintf(psname,"%s/grb/cand/grb_ultrashort_cand_%05d_%03d.ps",
	      pubdir,julDate+10000,hid-2000);      
      sprintf(mfile,"%s/email_notice/NOTICE_ULTRASHORT_%05d_%03da.txt",
	      dir,julDate+10000,hid-2000);
    }
    else{
      sprintf(rname,"%s/grb_short_cand_%05d_%03d.root",dir,julDate+10000,hid-2000);
      sprintf(pname,"%s/grb_short_cand_%05d_%03d.his",dir,julDate+10000,hid-2000);
      sprintf(psname,"%s/grb/cand/grb_short_cand_%05d_%03d.ps",
	      dir,julDate+10000,hid-2000);
      sprintf(mfile,"%s/email_notice/NOTICE_SHORT_%05d_%03da.txt",
	      dir,julDate+10000,hid-2000);
    }
    
    sprintf(command,"$ROOTSYS/bin/h2root %s",pname);
    system(command);

    display = new TCanvas("display","",850,1050);
    display->SetFillColor(10);
    display->SetGrid();
    display->Clear();
    display->GetFrame()->SetFillColor(10);
    display->GetFrame()->SetBorderSize(12);
    display->Divide(2,3);

    sprintf(command,"touch %s",rname);
    system(command);

    TFile *grbfile = new TFile(rname,"OPEN");
    
    sprintf(hname,"h%d",hid);
    hcand5=(TH2F*)grbfile->Get(hname);
    sprintf(hname,"h%d",hid+1000);
    hcand1=(TH1F*)grbfile->Get(hname);
    sprintf(hname,"h%d",hid+2000);
    hcand2=(TH1F*)grbfile->Get(hname);
    sprintf(hname,"h%d",hid+3000);
    hcand3=(TH1F*)grbfile->Get(hname);
    sprintf(hname,"h%d",hid+4000);
    hcand4=(TH1F*)grbfile->Get(hname);
    sprintf(hname,"h%d",hid+6000);
    hcand6=(TH1F*)grbfile->Get(hname);    
    sprintf(hname,"h%d",hid+5000);
    hcand7=(TH1F*)grbfile->Get(hname);    
    
    sprintf(psopen,"%s/%s",pubdir,psname);
    TPostScript ps(psopen,111);

    gStyle->SetOptStat(0);
    
    display->cd(1);
    hcand5->SetMarkerStyle(8);
    hcand5->SetMarkerSize(0.5);
    hcand5->SetMarkerColor(4);
    hcand5->SetXTitle("RA(deg)");
    hcand5->SetYTitle("Dec(deg)");
    hcand5->SetTitle("Candidate Map");
    hcand5->Draw();
    
    x=hcand5->GetXaxis();
    y=hcand5->GetYaxis();
    
    xmin=(float)x->GetXmin();
    xmax=(float)x->GetXmax();  
    ymin=(float)y->GetXmin();
    ymax=(float)y->GetXmax();
    halfbin = 1.5;
    corr= 1./(cos((ymin+5.)*3.141592/180.));
    x1=(xmin+xmax)/2.-halfbin*corr+0.1;
    x2=(xmin+xmax)/2.+halfbin*corr+0.1;
    y1=ymin+5.-halfbin+0.1;
    y2=ymin+5.+halfbin+0.1;
    TBox *box = new TBox(x1,y1,x2,y2);
    box->SetFillStyle(0);
    box->SetFillColor(10);
    box->SetLineWidth(2);
    box->Draw();
    
    display->cd(2);
    hcand1->SetLineColor(4);
    hcand1->SetXTitle("time (s)");
    hcand1->SetYTitle("Events in bin");
    hcand1->SetTitle("Bin light curve (coarse)");
    hcand1->Draw();
    
    display->cd(3);
    hcand2->SetLineColor(4);
    hcand2->SetYTitle("Events in bin");
    hcand2->SetXTitle("time (s)");
    hcand2->SetTitle("Bin light curve (fine)");
    max=(float)hcand2->GetMaximum();
    hcand2->Draw();
    TLine *bl = new TLine(0,max*1.025,dur,max*1.025);
    bl->Draw();
    
    display->cd(4);
    hcand3->SetLineColor(4);
    hcand3->SetYTitle("Events in entire sky");
    hcand3->SetXTitle("time (s)");
    hcand3->SetTitleSize(0.04,"Y");
    hcand3->SetTitleOffset(1.9,"Y");
    hcand3->SetTitle("Light curve (coarse)");
    hcand3->Draw();

    display->cd(5);
    hcand6->SetLineColor(4);
    hcand6->SetYTitle("Events/square steradian");
    hcand6->SetXTitle("DEG");
    hcand6->SetTitle("Radial Distribution of Events");
    hcand6->SetTitleSize(0.04,"Y");
    hcand6->SetTitleOffset(1.9,"Y");
    nbins=(int)hcand6->GetNbinsX();
    for(i=1;i<=nbins;i++){
      berr=(float)hcand7->GetBinError(i);
      bc=(float)hcand6->GetBinContent(i);
      obc=(float)hcand7->GetBinContent(i);
      if(obc!=0){
	nerr=berr*bc/obc;
	hcand6->SetBinError(i,nerr);
      }
    }

    hcand6->SetNormFactor(1);
    hcand6->Draw("e");
    
    display->cd(6);
    TText *text;
    sprintf(htmlname,"%s/grb.html",pubdir);
    fph=fopen(htmlname,"a");
    fp=fopen(mfile,"r");
    tk=0.99;
    fprintf(fph,"\n\n");
    fprintf(fph,
	    "<TH><A HREF='%s'>%0.2d/%0.2d/%0.4d</A></TH>\n",
	    psname,month,day,year);
    fprintf(fph,"<TH>%4.0d_%0.4d</TH>\n",run,subrun);
    fprintf(fph,"<TH>%2.4f SEC </TH>\n",dur);
    fprintf(fph,"<TH>%2.2f DEG, %2.2f DEG</TH>\n",ra,dec);
    fprintf(fph,"<TH>%2.2f DEG</TH>\n",zen);
    fprintf(fph,"<TH>%2.2f EVENTS </TH>\n",sig);
    fprintf(fph,"<TH>%2.2f EVENTS </TH>\n",bkg);
    fprintf(fph,"<TH>%e  (pre-trials) </TH>\n",prob);
    fprintf(fph,"<TH>%2.2f </TH>\n",rate);
    fprintf(fph,"</TR>\n");

    count=0;
    while(fgets(textline,1500,fp)!=NULL){
      if(count>12) break;
      text= new TText(0.1,tk,textline);
      text->SetTextSize(0.035);    
      text->Draw();
      tk-=0.06;
      count++;
    }
    
    display->Update();
    ps.Close();

    sprintf(command,
	    "metasend -b -t dnoyes@umdgrb.umd.edu -s 'MILAGRO BURST POSITION NOTICE: FOLLOW UP' -m Application/POSTSCRIPT -f %s -n -m TEXT/PLAIN -f %s",
	    psopen,mfile);

    system(command);

  }

  if(type==2){//daily plots 

    if(ultra){
      start=0;
      sprintf(rname,"%s/grb_ultrashort_%0.2d-%0.2d-%4d.root",dir,month,day,year);
    }
    else{
      start=NDURa;
      sprintf(rname,"%s/grb_short_%0.2d-%0.2d-%4d.root",dir,month,day,year);
    }


    TFile *grbfile = new TFile(rname,"OPEN");


    display = new TCanvas("display","",850,1100);
    display->SetFillColor(10);
    display->SetGrid();
    display->Clear();
    display->GetFrame()->SetFillColor(10);
    display->GetFrame()->SetBorderSize(12);
    gStyle->SetOptStat(0);
    display->SetLogy();

    for(i=0;i<NDURa;i++){
      sprintf(hname,"h%d",i*10+1);
      hs[i]=(TH1F*)grbfile->Get(hname);
      sprintf(hname,"h%d",i*10+2);
      hb[i]=(TH1F*)grbfile->Get(hname);
      sprintf(hname,"h%d",i*10+3);
      hp[i]=(TH1F*)grbfile->Get(hname);
      hp[i]->SetLineWidth(2);
      hp[i]->SetLineColor(4);
      hp[i]->Draw();
      
      if(ultra){
	sprintf(psname,
		"%s/grb/daily/prob_ultrashort%d.ps",pubdir,i+1);
	sprintf(jpgname,
		"%s/grb/daily/prob_ultrashort%d.jpg",pubdir,i+1);
      }
      else {
	sprintf(psname,
		"%s/grb/daily/prob_short%d.ps",pubdir,i+1);
	sprintf(jpgname,"%s/grb/daily/prob_short%d.jpg",pubdir,i+1);
      }
      display->Print(psname);
      if(ON) sprintf(command,"/usr/bin/X11R6/convert %s %s",psname,jpgname);
      else sprintf(command,"/usr/bin/X11/convert %s %s",psname,jpgname);
      system(command);
    } 
    //make webpage with date on it.
    sprintf(htmlname,"%s/grb_daily.html",dir);
    fpw=fopen(hname,"w");

    
    fprintf(fpw,"<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>\n");
    fprintf(fpw,"<html>\n");
    fprintf(fpw,"<head>\n");
    fprintf(fpw,"<title>GRB Search Results</title>\n");
    fprintf(fpw,"</head>\n");
    fprintf(fpw,"<body>\n");
    fprintf(fpw,"<h1>GRB Search Results(Last 24 hours)</h1>\n");
    fprintf(fpw,"<h2>\n");
    fprintf(fpw,"Last Updated:%0.2d-%0.2d-%4d\n",month,day,year);
    fprintf(fpw,"</h2>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort1.jpg><img src=grb/daily/prob_ultrashort1.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort2.jpg><img src=grb/daily/prob_ultrashort2.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort3.jpg><img src=grb/daily/prob_ultrashort3.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort4.jpg><img src=grb/daily/prob_ultrashort4.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort5.jpg><img src=grb/daily/prob_ultrashort5.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort6.jpg><img src=grb/daily/prob_ultrashort6.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort7.jpg><img src=grb/daily/prob_ultrashort7.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort8.jpg><img src=grb/daily/prob_ultrashort8.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort9.jpg><img src=grb/daily/prob_ultrashort9.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort10.jpg><img src=grb/daily/prob_ultrashort10.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort11.jpg><img src=grb/daily/prob_ultrashort11.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort12.jpg><img src=grb/daily/prob_ultrashort12.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_ultrashort13.jpg><img src=grb/daily/prob_ultrashort13.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short1.jpg><img src=grb/daily/prob_short1.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short2.jpg><img src=grb/daily/prob_short2.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short3.jpg><img src=grb/daily/prob_short3.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short4.jpg><img src=grb/daily/prob_short4.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short5.jpg><img src=grb/daily/prob_short5.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short6.jpg><img src=grb/daily/prob_short6.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short7.jpg><img src=grb/daily/prob_short7.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short8.jpg><img src=grb/daily/prob_short8.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short9.jpg><img src=grb/daily/prob_short9.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short10.jpg><img src=grb/daily/prob_short10.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short11.jpg><img src=grb/daily/prob_short11.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short12.jpg><img src=grb/daily/prob_short12.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short13.jpg><img src=grb/daily/prob_short13.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<BR>\n");
    fprintf(fpw,"<a href=grb/daily/prob_short14.jpg><img src=grb/daily/prob_short14.jpg BORDER='0' WIDTH='425' HEIGHT='550'> </a>\n");
    fprintf(fpw,"<h3>\n");
    fprintf(fpw,"<br><FONT COLOR='black'>\n");
    fprintf(fpw,"<hr>\n");
    fprintf(fpw,"<address><a href='mailto:dnoyes@umdgrb.umd.edu'>David Noyes</a></address>\n");

    fclose(fpw);

  }

}








