#include"functionA.h"

extern int TOTAL;
extern Cluster *C_List;

W_Tree *Allocate_Node(){
	  W_Tree *Node;
	  Node = (W_Tree *) malloc(sizeof(W_Tree));
	  if(!Node)
	      exit(-1);
	  return(Node);
}

W_Tree *Allocate_Leaf(){
	  W_Tree *Leaf;
	  Leaf = (W_Tree *) malloc(sizeof(W_Tree));
	  if(!Leaf)
	        exit(-1);
	  return(Leaf);
}

Cluster *Allocate_Cluster(){
	  Cluster *c;

	  c = (Cluster *) malloc(sizeof(Cluster));
	  if(!c)
	       exit(-1);
	  return c;
}

void Swap(Object *A,Object *B){
	  Object *tmp;

	  tmp = (Object *) malloc(sizeof(Object));
	  if(!tmp)
	       exit(-1);

	  memcpy(tmp,A,sizeof(Object));
	  memcpy(A,  B,sizeof(Object));
	  memcpy(B,  tmp,sizeof(Object));
	  free(tmp);
	  return;
}

/***********************F_PAIR**************************************/
void  FPair(Object S[], int i,Object **idx,int dim){
  int j, k;
  float fp = -1;
  float d;
  for(j = 0; j < dim; j++)
    for(k = j+1; k < dim; k++){
      d = Dist((S+(i+j)),(S+(i+k))); 
      if(d > fp){
	fp = d;
	memcpy((*idx),S+(i+j),sizeof(S[i+j]));
	memcpy((*idx)+1,S+(i+k),sizeof(S[i+k]));
      }
    }
  return;
}


Object *Furthest_Pair( Object S1[],int start, int end, int size, float d){
 
  int i,j,ii,k;
  int i1,i2;
  float dXY;
  Object *Vout,*S;
  
  Vout = (Object *) malloc(2*sizeof(Object));
  if(!Vout)
    exit(-1);
  S = (Object *) malloc(n*sizeof(Object));
  if(!S)
    exit(-1);
  for(i = start; i <= end; i++){
    S[i].X = S1[i].X;
    S[i].index = S1[i].index;
    S[i].idx_CLU = S1[i].idx_CLU;
    S[i].dvS = S1[i].dvS;
    S[i].Dv = S1[i].Dv;
   }
  ii = 0;
  j =   start;
  while(size > 2){
    for(k = start; k <= (size-1); k++){ //  RANDOMIZATION STEP
      i1 = start + (int)((size-1)*(rand()/(RAND_MAX+1.0)));
      i2 = start + (int)((size-1)*(rand()/(RAND_MAX+1.0)));
      Swap(&S[i1],&S[i2]);
    }    
    i = start;
    j = start;
    ii = 0;
    while(((start+size)-i) > 5){
      FPair(S,i,&Vout,3);
      dXY = Dist(Vout,Vout+1); 
      if(dXY > d){
	free(S);
	return Vout;
      }
      memcpy(S+(j),Vout,sizeof(Object));
      memcpy(S+(j+1),Vout+1,sizeof(Object));
      j += 2;
      i += 3;
      ii+=3;
    }
    
    FPair(S,i,&Vout,((start+size)-i)); 
    dXY = Dist(Vout,Vout+1);
    if(dXY > d){
      free(S);
      return Vout;
    }
    memcpy(S+(j),Vout,sizeof(Object));
    memcpy(S+(j+1),Vout+1,sizeof(Object));
    size = 2*(int)(size/3);
  }
  memcpy(Vout,S+(start),sizeof(Object));
  memcpy(Vout+1,S+(start+1),sizeof(Object));
  free(S);
  return Vout;
}
/***********************END F_PAIR**************************************/
/**************************CENTROID DETECTION **************************/

int Max(Object *S,int i){
   
   float d1, d2, d3;
 
   d1 = Dist((S+i),(S+(i+1)));
   d2 = Dist((S+i),(S+(i+2)));
   d3 = Dist((S+(i+1)),(S+(i+2)));
   
   if (d1 > d2)
     if(d1 > d3)
       return i+2; 
     else
       return i; 
   else
     if(d2 > d3)
       return i+1;
     else
       return i;
}


int centroid(Object *S1, int i, int size){
  
  float max = 0;
  float maxgen = INFTY;
  int j,k;
  int idx = 0;

  for (j = 0; j < size; j++){
    max = 0;
    for(k = 0 ; k < size; k++)
      if(j!=k) {
	max += Dist((S1+(i+j)),(S1+(i+k)));
      }
    if (maxgen > max){
      maxgen = max;
      idx = j+i;
    }
  }
  return idx;
}


Object *Centroid(Object S1[],int start, int end,int size){
  
  int i = 0 , j, ii,k,i1,i2;
  int idx;
  Object *S2=NULL;
  Object *T=NULL;
  
  S2 = (Object *) malloc(n * sizeof(Object));
  if(!S2)
    exit(-1);
  T = (Object *) malloc(sizeof(Object));
  if(!T)
    exit(-1);

  for(i = start; i <= end; i++){
    S2[i].index = S1[i].index;
    S2[i].idx_CLU = S1[i].idx_CLU;
    S2[i].X = S1[i].X;
    S2[i].dvS = S1[i].dvS;
    S2[i].Dv = S1[i].Dv;
  }

  ii = 0;

  while(size > 8){

    for(k = start; k <= (size-1); k++){ //  RANDOMIZATION STEP
      i1 = start + (int)((size-1)*(rand()/(RAND_MAX+1.0)));
      i2 = start + (int)((size-1)*(rand()/(RAND_MAX+1.0)));
      Swap(&S2[i1],&S2[i2]);
    }
    
    i = start;
    j = start;
    ii = 0;
    while((((start+size)-i)) > 5){
      idx = Max(S2,i); 
      memcpy(S2+j,S2+idx,sizeof(Object));
      i += 3;
      j++;
      ii+=3;
    }
    
    idx = centroid(S2,i,((start+size)-i));
    memcpy(S2+j,S2+idx,sizeof(Object));
    size = (int)(size/3);
  }
  
  idx = centroid(S2,start,size);
  memcpy(T,S2+idx,sizeof(Object));  
  free(S2);
  return T;
}


/*************************END CENTROID DETECTION ***********************/


/* This procedure builds tha Antipole Tree*/
W_Tree *Build_Tree(Object *S,int size, int start,int end, float d, Object *PAIR,int idx, W_Tree *pred) {
  Object *FP=NULL;
  Object *LFP=NULL;
  int END;
  int START;
  int i;
  int sizeA = 0, sizeB = 0;
  float dab;
  float distA, distB;
  int idxA = -1;
  int idxB = -1;
  W_Tree *NODE=NULL;
  W_Tree *LEAF=NULL;

  if(size == 0) {  
    return NULL;
  }
  if(size == 1){
    NODE = Allocate_Node();
    NODE->A = (Object *) malloc(sizeof(Object));
    if(!NODE->A) exit(-1);
    memcpy(NODE->A,S+start,sizeof(Object));
    NODE->Dab = INFTY;
    NODE->Size = 1;
    NODE->leaf = TRUE;
    NODE->clust = Add_Outlier(&C_List,S,size,start,end,NODE); 
    NODE->left = NULL;
    NODE->right = NULL;
    NODE->pred = pred;
    NODE->B=NULL;
    return NODE;
  }
  if(!PAIR) {
    FP = Furthest_Pair(S,start, end, size,d);
  }
  else  
    FP = PAIR;
  dab = Dist(FP,(FP+1));
  //  fprintf(stderr,"\n%f idx1:%d idx2:%d",dab,*FP[0].index,*FP[1].index);
  //getchar();
  if(dab <= d){

    LEAF = Allocate_Leaf();
    LEAF->leaf = TRUE;

    LEAF->Size = size;
    LEAF->A = (Object *) malloc(sizeof(Object));
    if(!LEAF->A) exit(-1);
    memcpy(LEAF->A,FP,sizeof(Object));
    LEAF->B = (Object *) malloc(sizeof(Object));
    if(!LEAF->B) exit(-1);
    memcpy(LEAF->B,FP+1,sizeof(Object));
    LEAF->Dab = dab;

    if(size > 2){
      LEAF->clust = Add_Cluster(&C_List,S,size,start,end,idx+2,LEAF);
    }
    else{
      LEAF->clust = Add_Outlier(&C_List,S,size,start,end,LEAF);
    }
    LEAF->start = start;
    LEAF->end = end;
    LEAF->left = NULL;
    LEAF->right = NULL;
    LEAF->pred = pred;
    if(FP) {
      free(FP);
      FP=NULL;
    }
    return LEAF;
  }
  
  NODE = Allocate_Node();
  NODE->leaf = FALSE;
  NODE->A = (Object *) malloc(sizeof(Object));
  if(!NODE->A) exit(-1);
  memcpy(NODE->A,FP,sizeof(Object));
  NODE->B = (Object *) malloc(sizeof(Object));
  if(!NODE->B) exit(-1); 
  memcpy(NODE->B,FP+1,sizeof(Object));
  NODE->Dab = dab;
  NODE->RadA = -INFTY;
  NODE->RadB = -INFTY;
  i = start;
  while(*S[i].index != *FP[0].index)
    i++;
  Swap(&S[start],&S[i]);
  start++;
  i = start;
  while(*S[i].index != *FP[1].index)
    i++;
  Swap(&S[end],&S[i]);
  end--;
  END = end+1;
  START = start - 1;
  // Prevedere il caso se si trova una dist. > d allora 
  // conservare questo punto come nuovo routing object con 
  // lo stesso punto di partenza 
  i = start;
  while(i <= end) {
    distA = Dist(NODE->A,(S+i));
    distB = Dist(NODE->B,(S+i));
    S[i].Dv = (float *)realloc(S[i].Dv,sizeof(float)*(idx+2));
    if(!S[i].Dv)
      exit(-1);
    S[i].Dv[idx] = distA;
    S[i].Dv[idx+1] = distB;
    S[i].dvS = idx+2;
    if(distA <= distB){
      if(distA > NODE->RadA){
	NODE->RadA = distA;
	idxA = i;
      }
      sizeA++;
      i++;
    }
    else {
      Swap(&S[i],&S[end]);
      end--;
      sizeB++;
      if(distB > NODE->RadB){
	NODE->RadB = distB;
	idxB = end+1;
      }
    }
  }
  //----------------------
  S[START].Dv = (float *)realloc(S[START].Dv,sizeof(float)*(idx+2));
  if(!S[START].Dv)
     exit(-1);
  S[END].Dv = (float *)realloc(S[END].Dv,sizeof(float)*(idx+2));
  if(!S[END].Dv)
     exit(-1);
  S[START].Dv[idx] = S[END].Dv[idx+1] = 0;
  S[START].Dv[idx+1] = S[END].Dv[idx] = dab;
  S[START].dvS = idx+2;  
  S[END].dvS = idx+2;
  //----------------------
  sizeA++;
  sizeB++;
  NODE->start = START;
  NODE->end = END;
  NODE->SizeA = sizeA;
  NODE->SizeB = sizeB;
  NODE->Size = size;
  NODE->pred = pred;
  free(FP);
  FP=NULL;
  if(NODE->RadA > d){
    LFP=(Object *)malloc(sizeof(Object)*2);
    memcpy(LFP,NODE->A,sizeof(Object));
    memcpy(LFP+1,S+idxA,sizeof(Object));
    NODE->left  = Build_Tree(S,sizeA,START,sizeA+START-1,d,LFP,idx+2,NODE);
  }
  else {     
    NODE->left  = Build_Tree(S,sizeA,START,sizeA+START-1,d,NULL,idx+2,NODE);
  }
  if(NODE->RadB > d){
    LFP=(Object *)malloc(sizeof(Object)*2);
    memcpy(LFP,NODE->B,sizeof(Object));
    memcpy(LFP+1,S+idxB,sizeof(Object));
    NODE->right = Build_Tree(S,sizeB,END-sizeB+1,END,d,LFP,idx+2,NODE);
  }
  else {
    NODE->right = Build_Tree(S,sizeB,END-sizeB+1,END,d,NULL,idx+2,NODE);
  }
  
  return NODE;
}

Cluster *Add_Cluster(Cluster **Clust,Object *S,int size, int start, int end, int idx,W_Tree *node){
  Object *T=NULL;
  int i,j;

  if(!(*Clust)){
    TOTAL++;
    (*Clust) = Allocate_Cluster();
    (*Clust)->next = NULL;

    (*Clust)->neighbor = NULL;
    (*Clust)->saturated = FALSE;

    T = Centroid(S,start,end,size);

    (*Clust)->Centroid = (Object *) malloc(sizeof(Object));
    if(!(*Clust)->Centroid)
      exit(-1);
    memcpy((*Clust)->Centroid,T,sizeof(Object));

    (*Clust)->radius = Radius(S,size, start, end, T);

    (*Clust)->size = size-1;
    (*Clust)->Elements = (Object *) malloc(sizeof(Object) *((size-1)));//+10000));
    (*Clust)->tree_node = node;
    if(!(*Clust)->Elements)
      exit(-1);
    i = start;
    j = 0;
    while(i <= end){
      if(*S[i].index != *T->index){
	memcpy((*Clust)->Elements+j,S+i,sizeof(Object));
	//(*Clust)->Elements[j].Dv = (float *) malloc(sizeof(float) *(idx));
       	j++;
      }
     
      i++;
    }
    free(T);
    return (*Clust);
  }   
  else
    return Add_Cluster(&(*Clust)->next,S,size, start, end,idx,node);
}

Cluster *Add_Outlier(Cluster **Clust,Object *S,int size, int start, int end,W_Tree *node){
  
  if(!(*Clust)){
    TOTAL++;
    (*Clust) = Allocate_Cluster();
    (*Clust)->next = NULL;
    (*Clust)->Centroid = (Object *) malloc(sizeof(Object));
    (*Clust)->tree_node = node;
    (*Clust)->neighbor = NULL;
    if(!(*Clust)->Centroid)
      exit(-1);
    memcpy((*Clust)->Centroid,S+start,sizeof(Object));
    (*Clust)->radius = 0;
    (*Clust)->size = size-1;
    //(*Clust)->Elements = NULL;
    (*Clust)->saturated = TRUE;
    if(size == 2){
      (*Clust)->saturated = FALSE;
      (*Clust)->Elements = (Object *) malloc(sizeof(Object));
      if(!(*Clust)->Elements)
	exit(-1);
      memcpy((*Clust)->Elements,S+end,sizeof(Object));
      (*Clust)->radius = Dist((*Clust)->Centroid,(*Clust)->Elements);
    }
    return (*Clust);
  }
  else
    return Add_Outlier(&(*Clust)->next,S,size, start, end,node);
}

float Radius(Object *S, int size, int start, int end, Object *T){      
  float r = -1;
  float v;
  int i;
  
  for(i = start; i <= end; i++) {
    if(*(S[i].index) != *T->index){
      v = Dist((S+i),T);
      S[i].Dc = v;
      if(r < v)
	r = v;
    }
  }

  return r;
}
