#include"functionB.h"
//#include <dmalloc.h>
#define LP 3

Object *S;
char choice = 'I'; // inner product as default

Cluster *G;

int *MAPPA[10000];
char *words[10000];
int cont_words = 0;
int loc_con[10000];

char directed;

int Right_Parser(int x,PriorityQueue *PQ) {
  if(2*x+1 <= PQ->heapsize)
    return 2*x+1;
  else
    return x;
}

int Left_Parser(int x,PriorityQueue *PQ) {
  if(2*x <= PQ->heapsize)
    return 2*x;
  else
    return x;
}

int Parent_Parser(int x) {
  return floor((float)(((float)(x))/2));
}

void Insert_Parser(PriorityQueue **PQ,int key,int idx) {
  int i,tmp;
  (*PQ)->heapsize++;
  i =  (*PQ)->heapsize;
  (*PQ)->dist = (Obj *)realloc((*PQ)->dist,sizeof(Obj)*(i+1));
  if((*PQ)->dist==NULL) {
    fprintf(stderr,"\nmemoria esaurita!!!");
    exit(1);
  }
  (*PQ)->dist[i].key = key;
  (*PQ)->dist[i].idx = idx;
  while(i > 1 && ((*PQ)->dist[Parent_Parser(i)].key < (*PQ)->dist[i].key)) {
    tmp = (*PQ)->dist[Parent_Parser(i)].key;
    (*PQ)->dist[Parent_Parser(i)].key = (*PQ)->dist[i].key;
    (*PQ)->dist[i].key = tmp;
    tmp = (*PQ)->dist[Parent_Parser(i)].idx;
    (*PQ)->dist[Parent_Parser(i)].idx = (*PQ)->dist[i].idx;
    (*PQ)->dist[i].idx = tmp;
    i = Parent_Parser(i);
  }
}

void Heapify_Parser(PriorityQueue **PQ,int i) {
  int largest,tmp;
  if((*PQ)->dist[i].key > (*PQ)->dist[Left_Parser(i,(*PQ))].key) {
    if((*PQ)->dist[i].key > (*PQ)->dist[Right_Parser(i,(*PQ))].key)
      largest = i;
    else
      largest = Right_Parser(i,(*PQ));
  }
  else
    if((*PQ)->dist[Left_Parser(i,(*PQ))].key > (*PQ)->dist[Right_Parser(i,(*PQ))].key)
      largest = Left_Parser(i,(*PQ));
    else
      largest = Right_Parser(i,(*PQ));
  if(largest != i) {
    tmp = (*PQ)->dist[i].key;
    (*PQ)->dist[i].key = (*PQ)->dist[largest].key;
    (*PQ)->dist[largest].key = tmp;
    tmp = (*PQ)->dist[i].idx;
    (*PQ)->dist[i].idx = (*PQ)->dist[largest].idx;
    (*PQ)->dist[largest].idx = tmp;
    Heapify_Parser(PQ,largest);
  }
}

int Dequeue_Parser(PriorityQueue **PQ) {
  int ret;
  ret = (*PQ)->dist[1].idx;
  (*PQ)->dist[1].key = (*PQ)->dist[(*PQ)->heapsize].key;
  (*PQ)->dist[1].idx = (*PQ)->dist[(*PQ)->heapsize].idx;
  ((*PQ)->heapsize)--;
  Heapify_Parser(PQ,1);
  return ret;
}

void AllPairShortestPath(int n,int *Adj[],int *cont,int ***pred,int ***Dis) {
  int i,tmp,u,j;
  PriorityQueue *PQ;
  PQ = NULL;
  *pred = (int **)malloc(n*sizeof(int *));
  *Dis = (int **)malloc(n*sizeof(int *));
  for(i=0;i<n;i++) {
    (*pred)[i] = (int *)malloc(n*sizeof(int));
    (*Dis)[i] = (int *)malloc(n*sizeof(int));
  }
  //  fprintf(stderr,"\n%d",n);
  //  getchar();
  for(j=0;j<n;j++) {
    memset((*pred)[j],-1,sizeof(int)*n);
    for(i=0;i<n;i++) {
      (*Dis)[j][i] = 99999999;
      (*pred)[i][i]=0;
    }
    (*Dis)[j][j] = 0;
    PQ = (PriorityQueue *)malloc(sizeof(PriorityQueue));
    PQ->dist = (Obj *)malloc(sizeof(Obj)*n);
    PQ->heapsize = 0;
    Insert_Parser(&PQ,-(*Dis)[j][j],j);
    while(PQ->heapsize > 0) {
      u = Dequeue_Parser(&PQ);
      for(i=0;i<cont[u];i++)
        if((*Dis)[j][Adj[u][i]] > (*Dis)[j][u] + 1) {
          tmp = (*Dis)[j][Adj[u][i]];
          (*Dis)[j][Adj[u][i]] = (*Dis)[j][u] + 1;
	  (*pred)[j][Adj[u][i]] = u;
	  if(tmp == 99999999) {
	    Insert_Parser(&PQ,-(*Dis)[j][Adj[u][i]],Adj[u][i]);
          }
        }
    }
    free(PQ->dist);
    free(PQ);
  }
}

void Visual_Parser(int start,char *stack[],int i,int num,char types[1000][50],int *cont_stack,int **pred,int num_grafo) {
  int j,m,c,l,flag,siz,cont,flag1;
  char **str=NULL;
  char *stringa;
  char *stringa_rev;
  
  for(j=0;j<num;j++) {
    flag1 = 0;
    m = j;
    c = 0;
    str = (char **)realloc(str,sizeof(char *)*(c+1));
    str[c] = types[m];
    if(m!=start)
      do {
	m = pred[start][m];
	if(m==-1) {
	  flag1 = 1;
	  break;
	}
	c++;
	str = (char **)realloc(str,sizeof(char *)*(c+1));
	str[c] = types[m];
	if(c >= LP)
	  break;
      }
      while(m!=start);

    if(flag1 == 1)
      continue;

    if(c<LP) {
      stringa = NULL;
      for(m=c;m>=0;m--) {
	if(stringa!=NULL) {
	  siz = strlen(stringa);
	  stringa = (char *)realloc(stringa,sizeof(char)*(siz+strlen(str[m]+1)));
	  stringa[siz+strlen(str[m])] = '\0';
	}
	else {
	  stringa = (char *)realloc(stringa,sizeof(char)*(strlen(str[m])+1));
	  strcpy(stringa,"");
	}
	strcat(stringa,str[m]);
      }
      
      stringa_rev = NULL;
      cont = 0;
      stringa_rev = (char *)malloc(sizeof(char)*(strlen(stringa)+1));
      for(l=strlen(stringa)-1;l>=0;l--)
	stringa_rev[cont++] = stringa[l];
      stringa_rev[cont] = '\0';
      //      fprintf(stderr,"\n%s ",stringa);
      //fprintf(stderr,"\n%s ",stringa_rev);
      //getchar();
      
      flag = 0;
      for(l=0;l<cont_words;l++)
	if(!strcmp(words[l],stringa) || (directed=='u' && !strcmp(words[l],stringa_rev))) {
	  MAPPA[num_grafo][l]++;
	  flag = 1;
      	  break;
      	}
      if(flag == 0) { // word still doesn't exist for graphs visit
	cont_words++;
	words[cont_words-1] = stringa;
	MAPPA[num_grafo] = (int *)realloc(MAPPA[num_grafo],sizeof(int)*cont_words);
	MAPPA[num_grafo][cont_words-1] = 1;
	loc_con[num_grafo] = cont_words;
      }
      else {
	free(stringa);
	stringa = NULL;
      }
      free(stringa_rev);
    }
  }
  free(str);
}

void Write_Output(Cluster *G,int num_clusters,char *name[10000],FILE *fp) {
  int i,j;
  for(i=0;i<num_clusters;i++) {
    fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n",i+1,G[i].size,G[i].radius);
    fprintf(fp,"     Centroid : '%s'\n",name[*S[G[i].Centroid].index]);
    for(j=0;j<G[i].size-1;j++) {
      fprintf(fp,"     Element  : '%s' [Dc:%f]\n",name[*S[G[i].Elements[j]].index],G[i].Dc[j]);
    }
    fprintf(fp,"\n");
  }
}

int main(int argc, char *argv[]) {
  int i,j=0,num,num_edge,e1,e2,num_grafo=0,*adj[1000],cont[1000];
  char types[1000][50];
  char *name[10000];
  int **pred,**Dis,cont_stack,num_clusters;
  float **Map;
  FILE *fp;
  char str[50],*stack[1000];

  if(argc != 4 && argc != 5) {
    printf("GraphClustB: Software for graphs clustering -- (C) 2003-2004\n");
    printf("USAGE:  <Dataset> <d/u> <number of clusters> [ <[I]nner Product / [E]uclidean [I/E]> ]\n");
    exit(-1);
  }
  if(argc == 5)
    sscanf(argv[4],"%c",&choice);
  
  if(choice!='I' && choice!='E') {
    fprintf(stderr,"\nUnrecognized value : %c. Please write 'I' or 'E'.\n",choice);
    exit(-1);
  }

  
  /* ----- PARSER STARTS ----- */

  
  fprintf(stderr,"\n\nParsing Dataset.....");
  sscanf(argv[2],"%c",&directed);
  if(directed!='d' && directed!='u') {
           fprintf(stderr,"\nUse 'd' or 'u' instead of %c\n\n",directed);
           exit(1);
  }
  fp = fopen(argv[1],"r");
  assert(fp);
  while(!feof(fp)) {
    fscanf(fp,"%s",str);
    if(feof(fp))
      break;
    if(str[0]=='#') { // New graph
      memset(cont,0,sizeof(int)*1000);
      for(i=0;i<1000;i++)
	adj[i] = NULL;
      name[num_grafo] = (char *)malloc(sizeof(char)*(strlen(str)+1));
      strcpy(name[num_grafo],str);
      fscanf(fp,"%d",&num);
      for(i=0;i<num;i++)
	fscanf(fp,"%s",types[i]);
      fscanf(fp,"%d",&num_edge);
      for(i=0;i<num_edge;i++) {
	fscanf(fp,"%d %d",&e1,&e2);
	adj[e1] = (int *)realloc(adj[e1],sizeof(int)*(cont[e1]+1));
	adj[e1][cont[e1]] = e2;
	cont[e1]++;
	if(directed=='u') {
	  adj[e2] = (int *)realloc(adj[e2],sizeof(int)*(cont[e2]+1));
	  adj[e2][cont[e2]] = e1;
	  cont[e2]++;
	}
      }
      AllPairShortestPath(num,adj,cont,&pred,&Dis);
      
      cont_stack = 0;
      
      MAPPA[num_grafo] = (int *)realloc(MAPPA[num_grafo],sizeof(int)*cont_words);
      loc_con[num_grafo] = cont_words;
      
      for(j=0;j<cont_words;j++)
	MAPPA[num_grafo][j] = 0;
      
      for(i=0;i<num;i++) {
	Visual_Parser(i,stack,i,num,types,&cont_stack,pred,num_grafo);
      }
      for(i=0;i<1000;i++)
      	if(adj[i]!=NULL)
      	  free(adj[i]);
      for(i=0;i<num;i++)
      	free(pred[i]);
      free(pred);
      for(i=0;i<num;i++)
      	free(Dis[i]);
      free(Dis);
      //      fprintf(stderr,"Processed graph number %d\n",num_grafo);   
      num_grafo++;
    }
  }
  fclose(fp);
  fprintf(stderr,"done\n");

  fprintf(stderr,"Writing file 'MAPPA'.....");
  fp = fopen("MAPPA","w");
  assert(fp);
  for(i=0;i<num_grafo;i++) {
    for(j=0;j<cont_words;j++) {
      if(loc_con[i] <= j)
      	fprintf(fp,"0 ");
      else
	fprintf(fp,"%d ",MAPPA[i][j]);
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
  fprintf(stderr,"done\n");
  
  //  fprintf(stderr,"\nNumber of patterns : %d\n\n",cont_words);
  
  //fp = fopen("words","w");
  //assert(fp);
  for(i=0;i<cont_words;i++) {
    // fprintf(fp,"%s\n",words[i]);
    free(words[i]);
  }
  //  fclose(fp);
  for(i=0;i<num_grafo;i++)
    free(MAPPA[i]);
  
  /* ----- PARSER ENDS ----- */
  /* It writes on 'MAPPA' the map, on 'words' all the patterns, on 'q' the converted query*/

  i=j=0;
  n = num_grafo;
  SpaceDim = cont_words;
  
  sscanf(argv[3],"%d",&num_clusters);

  //  fprintf(stderr,"\nSpaceDim:%d dim:%d d:%f",SpaceDim,n,d);

  if(!(fp = fopen("MAPPA","r+"))) {
    printf("file MAPPA not found. Exit...");
    exit(-1);
  }
  
  fprintf(stderr,"Allocating Memory.....");
  Map = (float **)malloc(sizeof(float)*n);
  for(i=0;i<n;i++)
    Map[i] = (float *)malloc(sizeof(float)*SpaceDim);

  S = (Object *) malloc(n * sizeof(Object));
  if(!S)
    exit(-1);
  for(i = 0; i < n; i++) {
    S[i].X = (float *) malloc(sizeof(float)*SpaceDim);
    if(!S[i].X)
      exit(-1);
    S[i].index = (int *) malloc(sizeof(int));
    if(!S[i].index)
      exit(-1);
    S[i].idx_CLU = (int *) malloc(sizeof(int));
    if(!S[i].idx_CLU)
      exit(-1);
    S[i].Dv = NULL;
  }
  fprintf(stderr,"done\n");
  
  //  fprintf(stderr,"IDF Computation.....");
  //IDF(n,SpaceDim,fp,Map);
  //  fclose(fp);
  //fprintf(stderr,"done\n");

  //fp = fopen("IDF","r+");
  assert(fp);
  fprintf(stderr,"Loading Data.....");
  Load_Data2(S, n,SpaceDim,fp);
  fprintf(stderr,"done\n");
  fclose(fp);
  
  fprintf(stderr,"Making Clusters.....");
  G = NULL;
  G = (Cluster *)malloc(sizeof(Cluster)*num_clusters);
  Build(S,num_clusters);
  fprintf(stderr,"done\n");

  fprintf(stderr,"Writing file 'output'.....");
  fp = fopen("output","w");
  Write_Output(G,num_clusters,name,fp);
  fclose(fp);
  fprintf(stderr,"done\n");

  //  Visit_Tree(Tree);
  //visualizza(Tree);
  //getchar();
  
  Libera(G,num_clusters);
  
  fprintf(stderr,"\n\n");
  for(i=0;i<n;i++)
    free(Map[i]);
  free(Map);
  for(i=0;i<10000;i++)
    free(name[i]);

  Libera_S(n);
  return 1;
}
