# Instructions on How to update Dr.Ecco website
_____________________________________________
For Prof. Shasha and future architects
_____________________________________________

## Steps:

1. First, update the year at the header file.
	cd /usr/httpd/entities/drecco2016
	nano header.php #replace the line ```<h1>DR. ECCO 2021</h1>``` with 2022.

2. Upload the games to /usr/httpd/entities/drecco2016/games folder as a *.zip:
	Option 1: scp to server :  
	```
	scp game.zip shasha@access.cims.nyu.edu://usr/httpd/entities/drecco2016/games
	```
	Option 2: Login to server and cd into games directory. Use get_game.sh to download from google drive. g-drive-file-id is the file id between /d/your_id/view when a shareable link is generated, i.e.,
	https://drive.google.com/file/d/1zNN3GHC8vDsidkcuHoKl-gSHSremUwtl/view?usp=sharing
	means that the file id is 1zNN3GHC8vDsidkcuHoKl-gSHSremUwtl .
	```
	./get_game.sh g-drive-file-id gamename
	```
	The games on the drive MUST be publicly shared for this to work.
3. Install the games from zip file:
	```
	python3 p3_add_game.py -gn "Game Name" -gp gamename
	```

_____________________________________________
For future architects
_____________________________________________

You can create a google drive folder and keep the submitted games at that folder. For downloading all the games a bash script can be created like download_all_games.sh as well as another bash script for installing all the games at once like install_all_games.sh . Then Prof. Shasha can transfer these scripts to the /usr/httpd/entities/drecco2016/games folder using scp and run them there so that the ownership of the new games will be automatically under Prof. Shasha's account. Note that once Prof Shasha has the scripts, he may have to change the file permissions to enable execution (the chmod commands below).

```
scp *.sh shasha@access.cims.nyu.edu://usr/httpd/entities/drecco2016/games
```
At @access.cims.nyu.edu:/usr/httpd/entities/drecco2016/games
```
chmod 700 download_all_games.sh
chmod 700 install_all_games.sh
./download_all_games.sh
./install_all_games.sh
```
