(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      8694,        246]
NotebookOptionsPosition[      8036,        219]
NotebookOutlinePosition[      8393,        235]
CellTagsIndexPosition[      8350,        232]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
   "Import", "[", 
    "\"\</Users/jkogan/Documents/BrainAnalysis/load_data/spiking_activity.txt\
\>\"", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.680723445525132*^9, 3.680723482454102*^9}, {
  3.682106976745935*^9, 3.6821069796641417`*^9}, {3.682597452022088*^9, 
  3.682597455179439*^9}, {3.685016884667385*^9, 3.6850168868084908`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fullData", "=", 
   RowBox[{"Take", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"StringSplit", "[", 
        RowBox[{"#", ",", "\"\<,\>\""}], "]"}], "&"}], "/@", 
      RowBox[{"StringSplit", "[", 
       RowBox[{"data", ",", "\"\<\\n\>\""}], "]"}]}], ",", "300"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.680723487898849*^9, 3.680723550031961*^9}, {
   3.680723792272203*^9, 3.680723814372797*^9}, 3.6807240616730633`*^9, {
   3.68072497597546*^9, 3.680724981197687*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeIntoNums", "[", "num_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"chars", ",", "eFormat"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"eFormat", "[", "number_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"partNum", ",", "expNum"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"partNum", "=", 
           RowBox[{"ToExpression", "@", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"Drop", "[", 
              RowBox[{
               RowBox[{"Characters", "[", "number", "]"}], ",", 
               RowBox[{"-", "4"}]}], "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"expNum", "=", 
           RowBox[{"ToExpression", "@", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"Characters", "[", "number", "]"}], ",", 
               RowBox[{"-", "3"}]}], "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"partNum", "*", 
           RowBox[{"10", "^", "expNum"}]}]}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"chars", "=", 
       RowBox[{"Characters", "[", "num", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ContainsAny", "[", 
         RowBox[{"chars", ",", 
          RowBox[{"{", "\"\<e\>\"", "}"}]}], "]"}], ",", 
        RowBox[{"eFormat", "[", "num", "]"}], ",", 
        RowBox[{"ToExpression", "[", "num", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.68077664914528*^9, 3.68077665698254*^9}, 
   3.682161751225531*^9, 3.6821620210321817`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"odor", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"makeIntoNums", "/@", 
      RowBox[{"Take", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"410", "-", "300"}], ",", 
          RowBox[{"410", "+", "300"}]}], "}"}]}], "]"}]}], "&"}], "/@", 
    "fullData"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"airpuff", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"makeIntoNums", "/@", 
      RowBox[{"Take", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1142", "-", "300"}], ",", 
          RowBox[{"1142", "+", "300"}]}], "}"}]}], "]"}]}], "&"}], "/@", 
    "fullData"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sound", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"makeIntoNums", "/@", 
      RowBox[{"Take", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2223", "-", "300"}], ",", 
          RowBox[{"2223", "+", "300"}]}], "}"}]}], "]"}]}], "&"}], "/@", 
    "fullData"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.68072383122047*^9, 3.680723861980817*^9}, 
   3.680724059401071*^9, {3.680724997279051*^9, 3.680724997765526*^9}, {
   3.6807250526152678`*^9, 3.680725053055182*^9}, {3.6807265581813593`*^9, 
   3.680726558803761*^9}, {3.6807754584143867`*^9, 3.680775458789098*^9}, {
   3.680776659736507*^9, 3.680776670788517*^9}, {3.682107001488428*^9, 
   3.682107010200561*^9}, {3.682107066656781*^9, 3.68210706803979*^9}, {
   3.685016917782082*^9, 3.685016978725067*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dataDict", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"\"\<odor\>\"", "\[Rule]", "odor"}], ",", 
     RowBox[{"\"\<airpuff\>\"", "\[Rule]", "airpuff"}], ",", 
     RowBox[{"\"\<sound\>\"", "\[Rule]", "sound"}]}], "|>"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.682107070062234*^9, 3.682107126886876*^9}, {
  3.685017192724452*^9, 3.6850171953465567`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"odor", "[", 
       RowBox[{"[", "x", "]"}], "]"}], ",", 
      RowBox[{"airpuff", "[", 
       RowBox[{"[", "x", "]"}], "]"}], ",", 
      RowBox[{"sound", "[", 
       RowBox[{"[", "x", "]"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "300", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.685016993105545*^9, 3.685017024858605*^9}, {
  3.685017088441635*^9, 3.685017161127158*^9}, {3.685017199554716*^9, 
  3.685017306143299*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 140, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 1, 300, 1}}, Typeset`size$$ = {
    360., {107., 112.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$1729303$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$1729303$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListLinePlot[{
         Part[$CellContext`odor, $CellContext`x$$], 
         Part[$CellContext`airpuff, $CellContext`x$$], 
         Part[$CellContext`sound, $CellContext`x$$]}], 
      "Specifications" :> {{$CellContext`x$$, 1, 300, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {152., 158.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.685017006289721*^9, 3.685017025313807*^9}, {
  3.685017108163127*^9, 3.685017161577257*^9}, {3.685017197342568*^9, 
  3.68501723756633*^9}, {3.68501726846852*^9, 3.68501730651971*^9}}]
}, Open  ]]
},
WindowSize->{808, 655},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 431, 10, 48, "Input",
 InitializationCell->True],
Cell[992, 32, 564, 15, 48, "Input",
 InitializationCell->True],
Cell[1559, 49, 1905, 49, 217, "Input",
 InitializationCell->True],
Cell[3467, 100, 1594, 44, 91, "Input",
 InitializationCell->True],
Cell[5064, 146, 428, 11, 48, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[5517, 161, 615, 16, 32, "Input"],
Cell[6135, 179, 1885, 37, 327, "Output"]
}, Open  ]]
}
]
*)

