# This file takes historical games in a csv file and ...

import csv

# DATA
visitorhist_secondhalf_score_firstisover ={}
visitor_totalscore_firstisover ={}
visitor_secondline_firstisover ={}
visitor_opponent_firstisover = {}

visitorhist_secondhalf_score_firstisunder ={}
visitor_totalscore_firstisunder ={}
visitor_secondline_firstisunder ={}
visitor_opponent_firstisunder = {}

homehist_secondhalf_score_firstisover ={}
home_totalscore_firstisover ={}
home_secondline_firstisover ={}
home_opponent_firstisover = {}

homehist_secondhalf_score_firstisunder ={}
home_totalscore_firstisunder ={}
home_secondline_firstisunder ={}
home_opponent_firstisunder = {}

visitor_gamescore_over={}
home_gamescore_over={} # +2 if final over and first half is over, 
    # 1 if final over and first half is under
    # -1 if final is under and first half is over
    # -2 if final is under and first half is under
debugging = 0

# EXECUTION

allrows=[]
with open('historicalgames.csv') as csvfile:
  csvin = csv.reader(csvfile, delimiter=',', quotechar='|')
  for row in csvin:
    allrows.append(row)

i = 1
while(i < len(allrows)):
  myrowvisitor = allrows[i]
  myrowhome = allrows[i+1]
  if  (myrowhome[8] not in ["NL","pk"]) and (myrowvisitor[8] not in ["NL","pk"]) and (myrowvisitor[10] not in ["NL","pk"]) and (myrowhome[10] not in ["NL","pk"]):
    linetotal = float(myrowvisitor[8])
    linesecondhalf = max(float(myrowvisitor[10]), float(myrowhome[10]))
    firsthalfline = (linetotal - 9)/2
    firsthalfreal = (float(myrowvisitor[4])) + (float(myrowhome[4]))
    secondhalfreal = float(myrowvisitor[5]) + float(myrowhome[5]) 
    if firsthalfline >= firsthalfreal:
      if not myrowvisitor[3] in list(visitorhist_secondhalf_score_firstisunder.keys()):
        visitorhist_secondhalf_score_firstisunder[myrowvisitor[3]] = [float(myrowvisitor[5])]
        visitor_totalscore_firstisunder[myrowvisitor[3]] = [secondhalfreal]
        visitor_secondline_firstisunder[myrowvisitor[3]] = [linesecondhalf]
        visitor_opponent_firstisunder[myrowvisitor[3]] = [myrowhome[3]]
      else:
        visitorhist_secondhalf_score_firstisunder[myrowvisitor[3]].append(float(myrowvisitor[5]))
        visitor_totalscore_firstisunder[myrowvisitor[3]].append(secondhalfreal)
        visitor_secondline_firstisunder[myrowvisitor[3]].append(linesecondhalf)
        visitor_opponent_firstisunder[myrowvisitor[3]].append(myrowhome[3])
      if not myrowhome[3] in list(homehist_secondhalf_score_firstisunder.keys()):
        homehist_secondhalf_score_firstisunder[myrowhome[3]] = [float(myrowhome[5])]
        home_totalscore_firstisunder[myrowhome[3]] = [secondhalfreal]
        home_secondline_firstisunder[myrowhome[3]] = [linesecondhalf]
        home_opponent_firstisunder[myrowhome[3]] = [myrowvisitor[3]]
      else:
        homehist_secondhalf_score_firstisunder[myrowhome[3]].append(float(myrowhome[5]))
        home_totalscore_firstisunder[myrowhome[3]].append(secondhalfreal)
        home_secondline_firstisunder[myrowhome[3]].append(linesecondhalf)
        home_opponent_firstisunder[myrowhome[3]].append(myrowvisitor[3])
    if firsthalfline < firsthalfreal:
      if not myrowvisitor[3] in list(visitorhist_secondhalf_score_firstisover.keys()):
        visitorhist_secondhalf_score_firstisover[myrowvisitor[3]] = [float(myrowvisitor[5])]
        visitor_totalscore_firstisover[myrowvisitor[3]] = [secondhalfreal]
        visitor_secondline_firstisover[myrowvisitor[3]] = [linesecondhalf]
        visitor_opponent_firstisover[myrowvisitor[3]] = [myrowhome[3]]
      else:
        visitorhist_secondhalf_score_firstisover[myrowvisitor[3]].append(float(myrowvisitor[5]))
        visitor_totalscore_firstisover[myrowvisitor[3]].append(secondhalfreal)
        visitor_secondline_firstisover[myrowvisitor[3]].append(linesecondhalf)
        visitor_opponent_firstisover[myrowvisitor[3]].append(myrowhome[3])
      if not myrowhome[3] in list(homehist_secondhalf_score_firstisover.keys()):
        homehist_secondhalf_score_firstisover[myrowhome[3]] = [float(myrowhome[5])]
        home_totalscore_firstisover[myrowhome[3]] = [secondhalfreal]
        home_secondline_firstisover[myrowhome[3]] = [linesecondhalf]
        home_opponent_firstisover[myrowhome[3]] = [myrowvisitor[3]]
      else:
        homehist_secondhalf_score_firstisover[myrowhome[3]].append(float(myrowhome[5]))
        home_totalscore_firstisover[myrowhome[3]].append(secondhalfreal)
        home_secondline_firstisover[myrowhome[3]].append(linesecondhalf)
        home_opponent_firstisover[myrowhome[3]].append(myrowvisitor[3])
    if (secondhalfreal >= linesecondhalf) and ( firsthalfline < firsthalfreal):
      over = 2
    elif (secondhalfreal >= linesecondhalf) and ( firsthalfline >= firsthalfreal):
      over = 1
    elif (secondhalfreal < linesecondhalf) and ( firsthalfline < firsthalfreal):
      over = -1
    elif (secondhalfreal < linesecondhalf) and ( firsthalfline >= firsthalfreal):
      over = -2
    else:
      print("This should not happen, so is an error")
    if not myrowvisitor[3] in list(visitor_gamescore_over.keys()):
      visitor_gamescore_over[myrowvisitor[3]]=[over]
    else:
      visitor_gamescore_over[myrowvisitor[3]].append(over)
    if not myrowhome[3] in list(home_gamescore_over.keys()):
      home_gamescore_over[myrowhome[3]]=[over]
    else:
      home_gamescore_over[myrowhome[3]].append(over)
  i+=2

x1 = [k for k in visitorhist_secondhalf_score_firstisover.keys()]
x2 =[k for k in visitorhist_secondhalf_score_firstisunder.keys()]
x3 = [k for k in homehist_secondhalf_score_firstisover.keys()]
x4 =  [k for k in homehist_secondhalf_score_firstisunder.keys()]
allkeys = x1
allkeys.extend(x2)
allkeys.extend(x3)
allkeys.extend(x4)
if (debugging == 1):
  print(x4)
  print(visitor_gamescore_over)
  print(home_gamescore_over)
  print("x1 is of length " + str(len(x1)))
  print("x2 is of length " + str(len(x2)))
  print("x3 is of length " + str(len(x3)))
  print("x4 is of length " + str(len(x4)))
  print(allkeys)


for k in set(allkeys):
 print("      ")
 if k in visitorhist_secondhalf_score_firstisover.keys():
   print("For team " + k + " as visitor when first half is over: ")
   print("  Second half visitor score when first half is over: ")
   print(visitorhist_secondhalf_score_firstisover[k])
   print("  Second half total score when first half is over: ")
   print(visitor_totalscore_firstisover[k])
   print("  Second half line when first half is over: ")
   print(visitor_secondline_firstisover[k])
   print("  Opponent when first half is over: ")
   print(visitor_opponent_firstisover[k])
   print("  Final over/under when first half is over: ")
   x = []
   for i in range(len(visitor_gamescore_over[k])):
     if visitor_gamescore_over[k][i] == 2:
       x.append(1)
     elif visitor_gamescore_over[k][i] == -1:
       x.append(-1)
   print(x)
 if k in visitorhist_secondhalf_score_firstisunder.keys():
   print("For team " + k + " as visitor but first half is under: ")
   print("  Second half visitor score when first half is under: ")
   print(visitorhist_secondhalf_score_firstisunder[k])
   print("  Second half total score when first half is under: ")
   print(visitor_totalscore_firstisunder[k])
   print("  Second half line when first half is under: ")
   print(visitor_secondline_firstisunder[k])
   print("  Opponent when first half is under: ")
   print(visitor_opponent_firstisunder[k])
   print("  Final over/under when first half is under: ")
   x = []
   for i in range(len(visitor_gamescore_over[k])):
     if visitor_gamescore_over[k][i] == 1:
       x.append(1)
     elif visitor_gamescore_over[k][i] == -2:
       x.append(-1)
   print(x)

 if k in homehist_secondhalf_score_firstisover.keys():
   print("For team " + k + " as home when first half is over: ")
   print("  Second half home score when first half is over: ")
   print(homehist_secondhalf_score_firstisover[k])
   print("  Second half total score when first half is over: ")
   print(home_totalscore_firstisover[k])
   print("  Second half linewhen first half is over: ")
   print(home_secondline_firstisover[k])
   print("  Opponent when first half is over: ")
   print(home_opponent_firstisover[k])
   print("  Final over/under when first half is over: ")
   x = []
   for i in range(len(home_gamescore_over[k])):
     if home_gamescore_over[k][i] == 2:
       x.append(1)
     elif home_gamescore_over[k][i] == -1:
       x.append(-1)
   print(x)
 if k in homehist_secondhalf_score_firstisunder.keys():
   print("For team " + k + " as home but first half is under: ")
   print("  Second half home score when first half is under: ")
   print(homehist_secondhalf_score_firstisunder[k])
   print("  Second half total score when first half is under: ")
   print(home_totalscore_firstisunder[k])
   print("  Second half line when first half is under: ")
   print(home_secondline_firstisunder[k])
   print("  Opponent when first half is under: ")
   print(home_opponent_firstisunder[k])
   print("  Final over/under when first half is under: ")
   x = []
   for i in range(len(home_gamescore_over[k])):
     if home_gamescore_over[k][i] == 1:
       x.append(1)
     elif home_gamescore_over[k][i] == -2:
       x.append(-1)
   print(x)



