//*****************************
//  VPoly.Java
//  A Polygon Class developed
//  by Monty Faidley and
//  Chris Poultney
//  December 2, 1996
//*****************************

import java.awt.*;

class VPoly
{
  static int sig=0;
  private VPoint Verts[];
  private int Cx;
  private int Cy;
  public double PArea;


//**Constructors**
  public VPoly(int inCX, int inCY )
  {
    Verts = new VPoint[0];
    Cx = inCX;
    Cy = inCY;
    PArea = 0;
  }

  public VPoly( VPoly A )
  {
    Cx = A.Cx;
    Cy = A.Cy;
    PArea = A.PArea;
    Verts = new VPoint[A.Verts.length];
    for( int i=0; i < A.Verts.length; i++)
      Verts[i] = new VPoint(A.Verts[i]);
  }

  public VPoly( VPoint VP )
  {
    Verts = new VPoint[0];
    Cx = VP.iX();
    Cy = VP.iY();
    PArea = 0;
  }

//**Public Functions**                
  public void Delete( VPoint VP )
  {
    int count = 0;
    boolean deleted=false;
    VPoint temp[] = new VPoint[Verts.length-1];
    int numDel;
    sig++;

    if(VP==null) {
      System.out.println("Big OOPS!");
    }

    numDel=0;
    for( int i=0; i<Verts.length; i++ )
    {
      if(Verts[i]==null) {
        System.out.println("Bigger OOPS!:i="+i+",length="+Verts.length);
      }      
      if( (VP.dX() == Verts[i].dX()) && (VP.dY() == Verts[i].dY()) ) {
        deleted=true;
        numDel++;
      } else {
        temp[count] = new VPoint(Verts[i]);
        count++;
      }
    }
    if(deleted) {
      Verts=temp;
    }
  }//End of Delete Point

  public void Add( VPoint inP )
  {
    VPoint VP = new VPoint( inP );
    if(inP==null) {
      System.out.println("null pointer passed to VPoly Add");
    }
    for( int y=0; y<Verts.length; y++ ) {
      if(Verts[y]==null) {
        System.out.println("null point detected at add entry: pt="+y+",len="+Verts.length);
      }
    }
    if( Verts.length == 0 )
    {
      Verts = new VPoint[1];
      Verts[0] = VP;
      return;
    }
    int AddFlag = 0,DupFlag=0;
    VPoint temp[] = new VPoint[Verts.length+1];
    for( int i=0; i<Verts.length; i++ )
    {
      if( VP.dX()==Verts[i].dX() &&  VP.dY()==Verts[i].dY()) {
        AddFlag=1;
        DupFlag=1;
        break;
      } else if( VP.Theta(Cx, Cy) < Verts[i].Theta(Cx, Cy) ) {
        temp[i] = VP;
        for( int x=i; x<Verts.length; x++ )
          temp[x+1] = Verts[x];
        AddFlag = 1;
        break;
      } else {
        temp[i] = Verts[i];
      }
    }//end for All Points
    if( AddFlag == 0 ) //new point not added yet
      temp[Verts.length] = VP;
    if(DupFlag==0) {
      Verts=temp;
    }
    for( int y=0; y<Verts.length; y++ ) {
      if(Verts[y]==null) {
        System.out.println("null point detected at add exit: pt="+y+",len="+Verts.length+",AddFlag="+AddFlag);
      }
    }
  }//End of Add Point

  public double Area()
  {
    double AREA = 0;
    for( int i=2; i<Verts.length; i++ )
    {
      if(Verts[i]==null) {
        System.out.println("null Vert, length="+Verts.length);
      }
       
      AREA += TriArea( Verts[0], Verts[i-1], Verts[i] );
    }
    PArea = AREA;
    return( AREA );
  }//End of Area

  public void Draw(Graphics myG, Color c)
  {
    int t;
    Polygon myPoly = new Polygon();
    for( int i=0; i<Verts.length; i++ )
    {
      myPoly.addPoint( Verts[i].iX(), Verts[i].iY() );
    }
    myG.setColor( c );
    myG.fillPolygon( myPoly );
    myG.setColor(Color.black);
    for( int i=0; i<Verts.length; i++ )
    {
      t=(i+1)%Verts.length;
      myG.drawLine(Verts[i].iX(),Verts[i].iY(),Verts[t].iX(),Verts[t].iY());
    }
  }//end of Draw

  public int NumPoints()
  {
    return( Verts.length );
  }

  public VPoint Get( int p )
  {
    if( (p >= Verts.length) || (p < 0) )
    {
      System.out.println("Array out of bounds in VPoint.Get");
      return( null );
    }
    return( Verts[p] );
  }

  public VPoint GetCenter() {
    VPoint c=new VPoint(Cx,Cy);
    return c;
  }

//**Private Functions**
  private double TriArea( VPoint A, VPoint B, VPoint C )
  {
    double ax=B.dX()-A.dX();
    double ay=B.dY()-A.dY();
    double bx=C.dX()-A.dX();
    double by=C.dY()-A.dY();

    return((Math.abs(ax*by-ay*bx))/2);
  }//End of TriArea

}//end of class VPoly
