package noon;

import java.util.*;

import org.json.*;

public class Board {
	
	public static class Parameter {
		public final int wallCoolDown;	// H may create a wall not more frequently than every wallCoolDown time steps
		public final int wallMaximum;	// At any given time the maximum number of walls there can be is wallMaximum.
		public Parameter(int wallCoolDown, int wallMaximum) {
			this.wallCoolDown = wallCoolDown;
			this.wallMaximum = wallMaximum;
		}
	}
	
	public static class Wall {
		// if isHorizontal == true, length >= 0
		// if isHorizontal == false, length >= 1
		public final boolean isHorizontal;
		public final XY position;
		public final int length;
		public Wall(boolean isHorizontal, XY position, int length) {
			this.isHorizontal = isHorizontal;
			this.position = position;
			this.length = length;
		}
		public boolean equals(Object obj) {
			Wall wall = (Wall)obj;
			if (this.isHorizontal != wall.isHorizontal) return false;
			if (!this.position.equals(wall.position)) return false;
			if (this.length != wall.length) return false;
			return true;
		}
		public int hashCode() {
			// Do not use this
			throw new RuntimeException();
		}
		public Wall(JSONObject json) throws JSONException {
			isHorizontal = json.getBoolean("isHorizontal");
			position = new XY(json.getJSONObject("position"));
			length = json.getInt("length");
		}
		public JSONObject toJson() throws JSONException {
			JSONObject ret = new JSONObject();
			ret.put("isHorizontal", isHorizontal);
			ret.put("position", position.toJson());
			ret.put("length", length);
			return ret;
		}
	}
	
	public static class HunterStep {
		/** wall may be null */
		public final Wall wall;
		public HunterStep(Wall wall) {
			this.wall = wall;
		}
	}
	
	public static class PreyStep {
		public final int dx;
		public final int dy;
		public PreyStep(int dx, int dy) {
			this.dx = dx;
			this.dy = dy;
		}
	}
	
	public Parameter getParameter() {
		return parameter;
	}
	
	private final Parameter parameter;
	private int time;			// Current time
	private XY hunterPosition;
	private XY hunterMove;
	private XY preyPosition;
	private int wallCountDown;	// H may create or remove a wall after wallCountDown time from now
	private ArrayList<Wall> walls;	// all created walls
	
	void setHunterPosition(XY pos) {
		hunterPosition = pos;
	}
	
	void setPreyPosition(XY pos) {
		preyPosition = pos;
	}
	
	void setHunterMove(XY dir) {
		hunterMove = dir;
	}
	
	void addWall(Wall wall) {
		walls.add(wall);
	}
	
	public Board(Parameter parameter) {
		this.parameter = parameter;
		time = 0;
		hunterPosition = new XY(0, 0);
		hunterMove = new XY(1, 1);
		preyPosition = new XY(330, 200);
		wallCountDown = 0;
		walls = new ArrayList<Wall>();
	}
	
	public Board(Board other) {
		parameter = other.parameter;
		time = other.time;
		hunterPosition = other.hunterPosition;
		hunterMove = other.hunterMove;
		preyPosition = other.preyPosition;
		wallCountDown = other.wallCountDown;
		walls = new ArrayList<Wall>(other.walls);
	}
	
/*	public Board(JSONObject json) throws JSONException {
		parameter = new Parameter(json.getInt("wallCoolDown"), json.getInt("wallMaximum"));
		time = json.getInt("time");
		hunterPosition = new XY(json.getJSONObject("hunterPosition"));
		preyPosition = new XY(json.getJSONObject("preyPosition"));
		wallCountDown = json.getInt("wallCountDown");
		JSONArray jsonWalls = json.getJSONArray("walls");
		for (int i = 0; i < jsonWalls.length(); ++i) {
			walls.add(new Wall(jsonWalls.getJSONObject(i)));
		}
	}*/
	
	public JSONObject toJson() throws JSONException {
		JSONObject ret = new JSONObject();
		ret.put("wallCoolDown", parameter.wallCoolDown);
		ret.put("wallMaximum", parameter.wallMaximum);
		ret.put("time", time);
		ret.put("hunterPosition", hunterPosition.toJson());
		ret.put("preyPosition", preyPosition.toJson());
		ret.put("wallCountDown", wallCountDown);
		ret.put("hunterMove", hunterMove.toJson());
		JSONArray jsonWalls = new JSONArray();
		for (Wall wall : walls) {
			jsonWalls.put(wall.toJson());
		}
		ret.put("walls", jsonWalls);
		return ret;
	}
	
	public boolean isCaught() {
		double precision = 0.0001;
		
		double distance = Math.pow (Math.pow( (preyPosition.x -hunterPosition.x),2) + Math.pow( (preyPosition.y -hunterPosition.y),2),0.5);
		if ( distance > Math.pow(32, 0.5) + precision){
		    return false;		
	    } else if (distance <= Math.pow(2, 0.5) -precision){ 
	    	return true;
	    }
		
		for (int w=0; w< walls.size(); w++){  
            if (  (walls.get(w).isHorizontal) && //check horizontal walls between them 
				(walls.get(w).position.x < Math.max(preyPosition.x,hunterPosition.x) ) &&
				(walls.get(w).position.y - preyPosition.y)*(walls.get(w).position.y - hunterPosition.y)< 0) {
				double crossX = preyPosition.x + 
				((double)(walls.get(w).position.y - preyPosition.y)/(hunterPosition.y - preyPosition.y))*(hunterPosition.x - preyPosition.x);
				//System.out.println("crossX=" + crossX);
				if ( (walls.get(w).position.x < crossX + 0.5 - precision) && 
					( walls.get(w).position.x + walls.get(w).length + 0.5 > crossX +precision) ) {
					return false; //found a horizontal wall between them
				}   
            } else if (  !(walls.get(w).isHorizontal) &&  //check vertical walls between them
					   (walls.get(w).position.y < Math.max(preyPosition.y,hunterPosition.y) ) &&
					   (walls.get(w).position.x - preyPosition.x)*(walls.get(w).position.x - hunterPosition.x  )< 0 ) {
			    double crossY = preyPosition.y + 
				((double)(walls.get(w).position.x - preyPosition.x)/(hunterPosition.x - preyPosition.x))*(hunterPosition.y - preyPosition.y);
			    //System.out.println("crossY=" + crossY);
				if ( (walls.get(w).position.y < crossY + 0.5 -precision ) && 
					( walls.get(w).position.y + walls.get(w).length + 0.5 > crossY +precision) ) {
					
					return false; 
				}
		    }
		}
		return true;		
	}
	
	public boolean canCreateWall(Wall wall) {
		if (wallCountDown > 0) { System.out.println("Cannot create wall because wallCountDown > 0.");return false;}
		if (walls.size() >= parameter.wallMaximum) { 
			System.out.println("walls.size() >= parameter.wallMaximum");
			return false;
		}
		if (wall.length < 0) {System.out.println("0");return false;}
		if (wall.length > 500) {System.out.println("00");return false;}
		
		//wall should contain the current hunter position
		if ( (wall.isHorizontal && (wall.position.y != hunterPosition.y)) ||
			(wall.isHorizontal && (wall.position.x - hunterPosition.x)*(wall.position.x + wall.length - hunterPosition.x)>0) ||	
			( !wall.isHorizontal && (wall.position.x != hunterPosition.x) ) ||
			( !wall.isHorizontal && (wall.position.y - hunterPosition.y)*(wall.position.y + wall.length - hunterPosition.y) > 0)
			){ return false;}
		//wall should not go through the prey:
		if ( (  (wall.isHorizontal && (wall.position.y == preyPosition.y)) && 
			  (wall.position.x - preyPosition.x)*(wall.position.x + wall.length - preyPosition.x) <=0) ||	
			( !wall.isHorizontal && (wall.position.x == preyPosition.x) && 
			 (wall.position.y - preyPosition.y)*(wall.position.y + wall.length - preyPosition.y) <=0)
			){ return false;  }
		
		if ( ( wall.isHorizontal && (wall.position.x + wall.length > 500)) 
			|| ( !wall.isHorizontal && (wall.position.y + wall.length >500) ) || wall.position.x<0 || wall.position.y<0) {return false; }

		walls.add(new Wall(true,new XY(0,0),500) );
		walls.add(new Wall(true,new XY(0,500),500) );
		walls.add(new Wall(false,new XY(0,0),500) );
		walls.add(new Wall(false,new XY(500,0),500) );
		
		try {
			
			
			if (wall.isHorizontal){
				for (int w=0; w< walls.size(); w++){ 
					//for coinciding walls => return false = may be it is redundant ??
					if ((walls.get(w).isHorizontal) && (walls.get(w).position.x == wall.position.x) 
						&& (walls.get(w).position.y == wall.position.y) && (walls.get(w).length == wall.length) ){
						return false;
					}
					
					if (  (walls.get(w).isHorizontal) && (walls.get(w).position.y == wall.position.y) &&
						//check if left endpoint of new wall is strictly inside of old wall	   
						( ( (walls.get(w).position.x - wall.position.x)* 
						   (walls.get(w).position.x + walls.get(w).length - wall.position.x) < 0) ||
						 ( (walls.get(w).position.x - wall.position.x - wall.length)*
						  (walls.get(w).position.x + walls.get(w).length - wall.position.x - wall.length) < 0) ||
						 ( (walls.get(w).position.x - wall.position.x)* 
						  (walls.get(w).position.x - wall.length - wall.position.x) < 0) ||
						 ( (walls.get(w).position.x + walls.get(w).length- wall.position.x)* 
						  (walls.get(w).position.x + walls.get(w).length - wall.position.x - wall.length) < 0)   
						 ) ){
							return false;  //walls cross
						}else if (  !(walls.get(w).isHorizontal) && 
								  ( (walls.get(w).position.x - wall.position.x)*(walls.get(w).position.x - wall.position.x - wall.length)<0) &&
								  (walls.get(w).position.y < wall.position.y) &&
								  (walls.get(w).position.y + walls.get(w).length > wall.position.y) ) {
							return false; //walls cross
						}
				}
				
			} else { //vertical wall
				for (int w=0; w< walls.size(); w++){
					//for coinciding walls => return false
					if (( !walls.get(w).isHorizontal) && (walls.get(w).position.x == wall.position.x) 
						&& (walls.get(w).position.y == wall.position.y) && (walls.get(w).length == wall.length) ){
						return false;
					}
					
					if (  (walls.get(w).isHorizontal) && 
						(  (walls.get(w).position.y - wall.position.y)*(walls.get(w).position.y - wall.position.y - wall.length) < 0) &&
						(   walls.get(w).position.x < wall.position.x ) &&
						(walls.get(w).position.x + walls.get(w).length > wall.position.x ) ) {
						return false;   //walls cross
					} else if ( ( !walls.get(w).isHorizontal) && (walls.get(w).position.x == wall.position.x) &&
							   ( ( (walls.get(w).position.y - wall.position.y)* (walls.get(w).position.y + walls.get(w).length - wall.position.y) < 0) ||
								( (walls.get(w).position.y - wall.length - wall.position.y)*
								 (walls.get(w).position.y + walls.get(w).length - wall.position.y - wall.length) < 0) ||
								( (walls.get(w).position.y - wall.position.y)*
								 (walls.get(w).position.y - wall.position.y - wall.length) < 0) ||  
								( (walls.get(w).position.y + walls.get(w).length- wall.position.y)*
								 (walls.get(w).position.y + walls.get(w).length- wall.position.y - wall.length) < 0)
								) ) {
								   return false;   //walls cross
							   }
				}
			}
			return true;
		} finally {
			walls.remove(new Wall(true,new XY(0,0),500) );
			walls.remove(new Wall(true,new XY(0,500),500) );
			walls.remove(new Wall(false,new XY(0,0),500) );
			walls.remove(new Wall(false,new XY(500,0),500) );		
		}
	}
	
	//checks if there is a wall that contains this point
	public boolean isWallHere(XY point) {
		for (int w=0; w< walls.size(); w++){ 
			
			if ( (walls.get(w).isHorizontal)&&
				(walls.get(w).position.y == point.y)&&
				(walls.get(w).position.x <= point.x)&&
				(walls.get(w).position.x + walls.get(w).length >= point.x) 
				){
				return true;
		    } else
				if ( ( !walls.get(w).isHorizontal)&&
					(walls.get(w).position.x == point.x)&&
					(walls.get(w).position.y <= point.y)&&
					(walls.get(w).position.y + walls.get(w).length >= point.y) 
                    ){
					return true;
				}
		}
		return false;
	}
	
	/**
	 * 
	 * @param wall
	 * @return true if valid, false if invalid
	 */
	public boolean applyHunterStep(HunterStep hunterStep) {

		if (hunterStep.wall != null) {
			if (!walls.contains(hunterStep.wall)) {
				if (canCreateWall(hunterStep.wall)) {
					walls.add(hunterStep.wall);
					wallCountDown = parameter.wallCoolDown;
				}  else {
					// What happen?
					System.out.println("Hunter output invalid wall.");
				}	
			} else {
				if (wallCountDown > 0) {
					System.out.println("Cannot remove wall because wallCountDown > 0.");
				} else {
					walls.remove(hunterStep.wall);
					wallCountDown = parameter.wallCoolDown;
				}
			}
		}

		walls.add(new Wall(true,new XY(0,0),500) );
		walls.add(new Wall(true,new XY(0,500),500) );
		walls.add(new Wall(false,new XY(0,0),500) );
		walls.add(new Wall(false,new XY(500,0),500) );
		
		try {
			
			
			//bounce the intersection of two walls = inside the corner => pos=same, dir = -dir
			if ( isWallHere(new XY(hunterPosition.x, hunterPosition.y + hunterMove.y) )&&
				isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y)) &&
				isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y + hunterMove.y))
				){
				setHunterMove(new XY( -hunterMove.x, -hunterMove.y));
				//System.out.print("hunterMove = " + hunterMove.x + "," + hunterMove.y  );
			} else  
				//bounce the bare corner => pos=same, dir = -dir
				if ( isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y + hunterMove.y) )&&
					!isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y))&&
					!isWallHere(new XY(hunterPosition.x, hunterPosition.y + hunterMove.y))
					){
					setHunterMove(new XY( -hunterMove.x, -hunterMove.y));
					//System.out.print("hunterMove = " + hunterMove.x + "," + hunterMove.y  );
				} else
					//just move => change the position only
					if ( !isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y + hunterMove.y) ) ){
						setHunterPosition(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y + hunterMove.y));
						//System.out.print("hunterMove = " + hunterMove.x + "," + hunterMove.y  );
					} else	   
						//bounce from vertical wall => change both position and direction
						if ( isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y) ) &&
							isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y + hunterMove.y) )   
							){
							setHunterPosition(new XY(hunterPosition.x, hunterPosition.y + hunterMove.y));
							setHunterMove(new XY( -hunterMove.x, hunterMove.y));
							//System.out.print("hunterMove = " + hunterMove.x + "," + hunterMove.y  );
						} else
							//bounce from horizontal wall => change both position and direction
							if ( isWallHere(new XY(hunterPosition.x, hunterPosition.y + hunterMove.y) ) &&
								isWallHere(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y + hunterMove.y) )   
								){
								setHunterPosition(new XY(hunterPosition.x + hunterMove.x, hunterPosition.y));
								setHunterMove(new XY( hunterMove.x, -hunterMove.y));
								//System.out.print("hunterMove = " + hunterMove.x + "," + hunterMove.y  );
							}
			return true;
		} finally {
			walls.remove(new Wall(true,new XY(0,0),500) );
			walls.remove(new Wall(true,new XY(0,500),500) );
			walls.remove(new Wall(false,new XY(0,0),500) );
			walls.remove(new Wall(false,new XY(500,0),500) );	
		}
	}
	
	/**
	 * 
	 * @param move
	 * @return true if valid, false if invalid
	 */
	public boolean applyPreyStep(PreyStep move) {
		
		walls.add(new Wall(true,new XY(0,0),500) );
		walls.add(new Wall(true,new XY(0,500),500) );
		walls.add(new Wall(false,new XY(0,0),500) );
		walls.add(new Wall(false,new XY(500,0),500) );
		
		try {
			
			//invalid move
			if (( Math.abs(move.dx) >1) || (Math.abs(move.dy) >1) ) { return false;}
			
			//for simple move up/down or left/right
			if ((  ( Math.abs(move.dx) + Math.abs(move.dy)) == 1) ){
				if ( !isWallHere(new XY(preyPosition.x + move.dx, preyPosition.y + move.dy) ) ){
					setPreyPosition(new XY(preyPosition.x + move.dx, preyPosition.y + move.dy));
				}//else prey bounces to the same place where it was before 
			}
			//for diagonal move			
			if ((  ( Math.abs(move.dx) + Math.abs(move.dy)) == 2) ){
				
				//just move => change the position only
				if ( !isWallHere(new XY(preyPosition.x + move.dx, preyPosition.y + move.dy) ) ){
					setPreyPosition(new XY(preyPosition.x + move.dx, preyPosition.y + move.dy));
					
				} else	   
					//bounce from vertical wall => change both position and direction
					if ( isWallHere(new XY(preyPosition.x + move.dx, preyPosition.y) ) &&
						isWallHere(new XY(preyPosition.x + move.dx, preyPosition.y + move.dy) )&&
						!isWallHere(new XY(preyPosition.x, preyPosition.y + move.dy))
						){
						setPreyPosition(new XY(preyPosition.x, preyPosition.y + move.dy));
						
					} else
						//bounce from horizontal wall => change both position and direction
						if ( isWallHere(new XY(preyPosition.x, preyPosition.y + move.dy) ) &&
							isWallHere(new XY(preyPosition.x + move.dx, preyPosition.y + move.dy) )&&
							!isWallHere(new XY(preyPosition.x + move.dx, preyPosition.y))
							){
							setPreyPosition(new XY(preyPosition.x + move.dx, preyPosition.y));
							
						}
			}
			return true;
		} finally {
			walls.remove(new Wall(true,new XY(0,0),500) );
			walls.remove(new Wall(true,new XY(0,500),500) );
			walls.remove(new Wall(false,new XY(0,0),500) );
			walls.remove(new Wall(false,new XY(500,0),500) );	
		}
	}
	
	public void tick() {
		++time;
		wallCountDown = Math.max(wallCountDown - 1, 0);
	}
	
	public int getTime() {
		return time;
	}
	
	public XY getHunterPosition() {
		return hunterPosition;
	}
	
	public XY getPreyPosition() {
		return preyPosition;
	}
	
	public int getWallCountDown() {
		return wallCountDown;
	}
	
	public ArrayList<Wall> getWalls() {
		return walls;
	}
	
}
