package noon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;

import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import java.util.*;

import org.json.JSONException;

import noon.Board.HunterStep;
import noon.Board.PreyStep;
import noon.Board.Wall;


public class ObserverConnector extends DebugBase {
	
	
	@SuppressWarnings("serial")
	private class Canvas extends JPanel {
		public KeyListener getKeyListener() {
			return new KeyListener() {
				public void keyTyped(KeyEvent e) {
				}
				public void keyPressed(KeyEvent e) {
					pressedKeys.add(e.getKeyCode());
				}
				public void keyReleased(KeyEvent e) {
					pressedKeys.remove(e.getKeyCode());
				}
			};
		}
		public Canvas() {
			hunter = new Game.HunterPlayer() {
				public String getName() {
					return "Human";
				}
				public HunterStep getHunterStep(Board board, Collection<PreyStep> preySteps) {
					if (pressedKeys.contains(KeyEvent.VK_D)) {
						ArrayList<Wall> walls = board.getWalls();
						if (!walls.isEmpty()) {
							Wall wall = walls.get(0);
							return new HunterStep(wall);
						}
					}
					if (pressedKeys.contains(KeyEvent.VK_E)) {
						ArrayList<Wall> walls = board.getWalls();
						if (!walls.isEmpty()) {
							Wall wall = walls.get(walls.size() - 1);
							return new HunterStep(wall);
						}
					}
					if (pressedKeys.contains(KeyEvent.VK_V)) {
						XY xy = board.getHunterPosition();
						int i = 0;
						for (;;) {
							++i;
							Wall wall = new Wall(false, new XY(xy.x, xy.y - i), i);
							if (!board.canCreateWall(wall)) break;
						}
						--i;
						int j = 0;
						for (;;) {
							++j;
							Wall wall = new Wall(false, new XY(xy.x, xy.y), j);
							if (!board.canCreateWall(wall)) break;
						}
						--j;
						return new HunterStep(new Wall(false, new XY(xy.x, xy.y - i), i + j));
					}
					if (pressedKeys.contains(KeyEvent.VK_H)) {
						XY xy = board.getHunterPosition();
						int i = 0;
						for (;;) {
							++i;
							Wall wall = new Wall(true, new XY(xy.x - i, xy.y), i);
							if (!board.canCreateWall(wall)) break;
						}
						--i;
						int j = 0;
						for (;;) {
							++j;
							Wall wall = new Wall(true, new XY(xy.x, xy.y), j);
							if (!board.canCreateWall(wall)) break;
						}
						--j;
						return new HunterStep(new Wall(true, new XY(xy.x - i, xy.y), i + j));
					}
					return new HunterStep(null);
				}
			};
			prey = new Game.PreyPlayer() {
				public String getName() {
					return "Human";
				}
				public PreyStep getPreyPlayer(Board board, Collection<HunterStep> hunterSteps) {
					int ud = 0;
					int lr = 0;
					if (pressedKeys.contains(KeyEvent.VK_UP)) {
						--ud;
					}
					if (pressedKeys.contains(KeyEvent.VK_DOWN)) {
						++ud;
					}
					if (pressedKeys.contains(KeyEvent.VK_LEFT)) {
						--lr;
					}
					if (pressedKeys.contains(KeyEvent.VK_RIGHT)) {
						++lr;
					}
					PreyStep ret = new PreyStep(lr, ud);
					return ret;
				}
			};
		}
		protected void paintComponent(Graphics g) {
			paintBoard(g, canvasBoard);
		}
		
		private Set<Integer> pressedKeys = new HashSet<Integer>();
		
		private Game.HunterPlayer hunter;
		private Game.PreyPlayer prey;
		
		public Game.HunterPlayer getHunter() {
			return hunter;
		}
		public Game.PreyPlayer getPrey() {
			return prey;
		}
	}
	
	JFrame frame;
	JPanel resultBoard;
	Canvas canvas;
	public Game.HunterPlayer getHunter() {
		return canvas.getHunter();
	}
	public Game.PreyPlayer getPrey() {
		return canvas.getPrey();
	}
	JPanel scoreBoard;
	JLabel hunterLabel;
	JLabel preyLabel;
	String hunterName;
	String preyName;
	JLabel score;
	JLabel wallLeft;
	Graphics g;
	private int port;
	private JApplet appletComponent;
	
	
	/**
	 * Start listening. No need to wait for a connection.
	 * Make an empty JFrame.
	 */
	class Started {
		boolean started;
	}
	private JButton btnStart;
	public void start(int port, final JApplet parentComponent) {
		appletComponent = parentComponent;
		this.port = port;
		if (port < 0) return;
		
		final Started started = new Started();
		System.out.println("1");
		started.started = false;
		System.out.println("2");
		try {
			SwingUtilities.invokeAndWait(checkRun(new Runnable() {
				@Override
				public void run() {
					System.out.println("3");
					if (parentComponent == null) {
						frame = new JFrame();
						frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
						frame.setPreferredSize(new Dimension(500, 650));
					}
					canvas = new Canvas();
					if (parentComponent == null) frame.getContentPane().add(canvas);
					else parentComponent.add(canvas);
					JPanel labels = new JPanel();
					hunterLabel = new JLabel("(waiting)");
					preyLabel = new JLabel("(waiting)");
//					labels.add(hunterLabel);
//					labels.add(preyLabel);
					
					System.out.println("4");
					score = new JLabel("Score: ");
					wallLeft = new JLabel("Wall Left: ");
					scoreBoard = new JPanel();
					scoreBoard.setLayout(new BoxLayout(scoreBoard, BoxLayout.Y_AXIS));
					scoreBoard.add(score);
					scoreBoard.add(wallLeft);
					
					canvas.setPreferredSize(new Dimension(500, 500));
//					canvas.setBorder(BorderFactory.createLineBorder(Color.black));
					canvas.setBackground(Color.BLACK);
					labels.setBackground(Color.WHITE);
					scoreBoard.setBackground(Color.WHITE);
					if (parentComponent == null) frame.setVisible(true);
					System.out.println("5");

					// put canvas and score together
					JPanel main = new JPanel();
					main.setBackground(Color.WHITE);
					main.setLayout(new BoxLayout(main, BoxLayout.Y_AXIS));
					main.add(canvas);
					main.add(scoreBoard);
					System.out.println("6");
					
					if (parentComponent == null) {
						Container cp = frame.getContentPane();
						cp.setLayout(new BorderLayout());
						cp.add(labels, BorderLayout.PAGE_START);
						cp.add(main, BorderLayout.CENTER);
						frame.addKeyListener(canvas.getKeyListener());
						frame.pack();
					} else {
						System.out.println("7");
						parentComponent.setLayout(new BorderLayout());
//						parentComponent.add(labels, BorderLayout.PAGE_START);
						parentComponent.add(main, BorderLayout.CENTER);
						parentComponent.setFocusable(true);
						parentComponent.addKeyListener(canvas.getKeyListener());

						System.out.println("8");
						btnStart = new JButton("Start");
						btnStart.addActionListener(new ActionListener() {

							@Override
							public void actionPerformed(ActionEvent arg0) {
								btnStart.setText("9");
								btnStart.setText("9");
								//canvas.remove(btnStart);
								btnStart.setVisible(false);
								
								btnStart.setText("10");
								synchronized(started) {
									btnStart.setText("11");
									started.started = true;
									started.notifyAll();
									btnStart.setText("12");
								}
								btnStart.setText("Start");
								
							}
						});
						btnStart.setText("14");
						canvas.add(btnStart);
						btnStart.setText("15");
					}
				}
			}));
		} catch (Exception e) {
			btnStart.setText("16");
			e.printStackTrace();
		} 
		btnStart.setText("17");
		synchronized(started) {
			btnStart.setText("18");
			try {
				btnStart.setText("19");
				for (;;) {
					btnStart.setText("Start");
					started.wait(0);
					btnStart.setText("21");
					if (started.started) {
						btnStart.setText("22");
						break;
					}
					btnStart.setText("23");
				}
			} catch (Exception e) {	
				btnStart.setText("24");
				e.printStackTrace();
			}
			btnStart.setText("25");
		}
		parentComponent.requestFocus();
		btnStart.setText("Start");
	}

	
	/**
	 * Notify that both players are connected
	 * @param hunter
	 * @param prey
	 */
	public void connected(Game.Player hunter, Game.Player prey) {
		this.hunterName = hunter == null ? "(waiting)" : hunter.getName();
		this.preyName = prey == null ? "(waiting)" : prey.getName();
		if (port < 0) {
			System.out.println("Connected. Hunter=" + this.hunterName + " Prey=" + this.preyName);
		} else {
			try {
				SwingUtilities.invokeAndWait(checkRun(new Runnable() {
					@Override
					public void run() {
						hunterLabel.setText("Hunter: " + hunterName);
						preyLabel.setText("Prey: " + preyName);
					}
				}));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	public void writeScore (Graphics g, Board board) {
		if (board == null) return;
		
	}

	public void paintBoard(Graphics g, Board board) {
//		Random r = new Random();
		if (board == null) return;
		g.setColor(Color.WHITE);
		g.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
		g.setColor(new Color(0, 0, 0));
		g.fillRect(0, 0, Config.BOARD_SIZE + 2, Config.BOARD_SIZE + 2);
		
		g = g.create(1, 1, Config.BOARD_SIZE, Config.BOARD_SIZE);
		
		// Draw hunter
		g.setColor(Color.RED);
		g.fillRect(board.getHunterPosition().x - 2, board.getHunterPosition().y - 2, 5, 5);
		g.setColor(Color.RED);
		g.drawRect(board.getHunterPosition().x, board.getHunterPosition().y, 3, 3);
		
		// Draw Prey
//		g.drawRect(r.nextInt(500), r.nextInt(500), 1, 1);
		g.setColor(new Color(33, 255, 255));
		g.fillRect(board.getPreyPosition().x - 2, board.getPreyPosition().y - 2, 5, 5);
		g.setColor(new Color(33, 255, 255));
		g.drawRect(board.getPreyPosition().x, board.getPreyPosition().y, 3, 3);
		
		// Draw walls
		g.setColor(Color.WHITE);
		for (Wall a : board.getWalls()) {
			g.drawLine(a.position.x,a.position.y,a.isHorizontal? a.position.x + a.length : a.position.x, a.isHorizontal? a.position.y : a.position.y + a.length);
		}
	}
	
	private Board canvasBoard;
	
	/**
	 * Notify that the board is updated.
	 * @param board
	 */
	public void update(Board board) {
/*		try {
			System.out.println("Board: " + board.toJson().toString());
		} catch (JSONException e) {
			e.printStackTrace();
		}*/
		if (port < 0) {
		} else {
			try {
				final Board b = new Board(board);
				SwingUtilities.invokeAndWait(checkRun(new Runnable() {
					@Override
					public void run() {
						canvasBoard = b;
						canvas.repaint();
						
						score.setText("Score: " + canvasBoard.getTime());
						wallLeft.setText("WallLeft: " + (canvasBoard.getParameter().wallMaximum - canvasBoard.getWalls().size()));
					}
				}));
				Thread.sleep(10);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * Just say something.
	 * @param who "S": server "H": hunter "P": prey
	 */
	public void log(String who, String text) {
		System.err.println("[" + who + "]" + text);
		// TODO Auto-generated method stub
	}
	
	/**
	 * Notify that the game is over.
	 * @param result
	 */
	public void over(Game.Result result) {
		
		String message = "";
		
		if (result == null) {
			message = "No result.";
		}
		else if (result.hunterTimeout && result.preyTimeout) {
			message = "Game Over: Time exceeded for both. Replay needed..";
		}
		else if (result.preyTimeout) {
			message = "Game Over: Congratulations Hunter! Your opponent has run out of time..";
		}
		else if (result.preyInvalid) {
			message = "Game Over: Congratulations Hunter! Your opponent did some wierd move..";
		}
		// They may run over their time at the same time.
		else if (result.hunterTimeout) {
			message = "Game Over: Congratulations Prey! Your opponent has run out of time..";
		}
		else if (result.hunterInvalid) {
			message = "Game Over: Congratulations Prey! Your opponent did some wierd move..";
		}
		else {
			message = "Game Over: Congratulations Hunter! ^O^ Score: " + result.board.getTime();
		}
		
		if (port < 0) {
			System.out.println(message);
		} else {
		
			JLabel msg = new JLabel();
			msg.setText(message);
			msg.setForeground(Color.RED);
			msg.setFont(new Font("aaa", Font.BOLD, 10));
			resultBoard = new JPanel();
			resultBoard.setBackground(Color.YELLOW);
			resultBoard.add(msg);
			
	//		frame.getContentPane().remove(canvas);
			resultBoard.setVisible(true);
			if (frame == null) {
				appletComponent.add(resultBoard, BorderLayout.SOUTH);
			} else {
				frame.getContentPane().add(resultBoard, BorderLayout.SOUTH);
				frame.pack();
			}
		}
	}
	
	/**
	 * Disconnect to client.
	 */
	public void close() {
		
	}

}
