/*
 * Decompiled with CFR 0.152.
 */
public class VBTree {
    static VBTree[] nodes;
    static VLine[] bisect;
    static int numPts;
    static int maxPts;
    static VBTree root;
    static VBTree head;
    static VBTree currentf;
    static VBTree currentb;
    static VPoint center;
    VPoint point;
    int num;
    double theta;
    VBTree left = null;
    VBTree right = null;
    VBTree prev = null;
    VBTree next = null;

    public void Reset() {
        for (int i = 0; i < numPts; ++i) {
            VBTree.nodes[i] = null;
        }
        numPts = 0;
        root = null;
        head = null;
        currentf = null;
        currentb = null;
    }

    public VBTree(int n) {
        nodes = new VBTree[n];
        bisect = new VLine[n + 3];
        maxPts = n;
        numPts = 0;
    }

    public VBTree(VPoint vPoint) {
        this.point = new VPoint(vPoint);
        this.num = numPts;
    }

    public void Add(VPoint vPoint) {
        if (numPts == 0) {
            VBTree.nodes[VBTree.numPts++] = this;
            this.point = new VPoint(vPoint);
            this.num = 0;
        } else {
            VBTree.nodes[VBTree.numPts] = new VBTree(vPoint);
            ++numPts;
        }
    }

    public int numPts() {
        return numPts;
    }

    public int num() {
        return this.num;
    }

    public VPoint point(int n) {
        return VBTree.nodes[n].point;
    }

    public VLine bisect(int n) {
        return bisect[n];
    }

    public void FindBisectors(VLine[] vLineArray, VPoint vPoint, int n) {
        int n2;
        VSegment vSegment = new VSegment();
        for (n2 = 0; n2 < 4; ++n2) {
            VBTree.bisect[n2] = vLineArray[n2];
        }
        for (n2 = 4; n2 < n + 3; ++n2) {
            vSegment.Set(this.point(n2 - 4), vPoint);
            VBTree.bisect[n2] = vSegment.PB();
        }
    }

    public void Sort(VPoint vPoint, int n) {
        int n2;
        center = vPoint;
        for (n2 = 0; n2 < numPts; ++n2) {
            VBTree.nodes[n2].theta = VBTree.nodes[n2].point.Theta(vPoint);
            VBTree.nodes[n2].left = null;
            VBTree.nodes[n2].right = null;
            VBTree.nodes[n2].prev = null;
            VBTree.nodes[n2].next = null;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == 0) {
                root = nodes[n2];
                head = nodes[n2];
                VBTree.nodes[n2].next = nodes[n2];
                VBTree.nodes[n2].prev = nodes[n2];
                continue;
            }
            VBTree vBTree = this.TreeInsert(root, nodes[n2]);
            if (vBTree == null) {
                vBTree = VBTree.head.prev;
                if (VBTree.nodes[n2].theta < VBTree.head.theta) {
                    head = nodes[n2];
                }
            }
            VBTree.nodes[n2].next = vBTree.next;
            VBTree.nodes[n2].prev = vBTree;
            vBTree.next = nodes[n2];
            VBTree.nodes[n2].next.prev = nodes[n2];
        }
    }

    VBTree TreeInsert(VBTree vBTree, VBTree vBTree2) {
        VBTree vBTree3 = null;
        if (vBTree2.theta <= vBTree.theta) {
            if (vBTree.left != null) {
                vBTree3 = this.TreeInsert(vBTree.left, vBTree2);
            } else {
                vBTree.left = vBTree2;
                vBTree3 = null;
            }
        } else if (vBTree.right != null) {
            vBTree3 = this.TreeInsert(vBTree.right, vBTree2);
        } else {
            vBTree.right = vBTree2;
            vBTree3 = null;
        }
        if (vBTree3 == null) {
            if (vBTree.theta < vBTree2.theta) {
                return vBTree;
            }
            return null;
        }
        if (vBTree.theta > vBTree3.theta && vBTree.theta < vBTree2.theta) {
            return vBTree;
        }
        return vBTree3;
    }

    public VBTree SetPrevNext(VPoint vPoint) {
        double d = vPoint.Theta(center);
        if (root == null) {
            currentf = null;
            currentb = null;
        } else {
            currentb = this.FindClosestUnder(root, d);
            if (currentb == null) {
                currentf = head;
                currentb = VBTree.currentf.prev;
            } else {
                currentf = VBTree.currentb.next;
            }
        }
        return currentf;
    }

    public VBTree GetNext() {
        currentf = VBTree.currentf.next;
        return VBTree.currentf.prev;
    }

    public VBTree GetPrev() {
        currentb = VBTree.currentb.prev;
        return VBTree.currentb.next;
    }

    public boolean IterDone() {
        return currentf == currentb;
    }

    public VBTree FindClosestUnder(VBTree vBTree, double d) {
        if (vBTree == null) {
            return null;
        }
        if (vBTree.theta < d) {
            if (vBTree.next.theta >= d) {
                return vBTree;
            }
            return this.FindClosestUnder(vBTree.right, d);
        }
        return this.FindClosestUnder(vBTree.left, d);
    }

    protected void recPrint(VBTree vBTree) {
        if (vBTree != null) {
            if (vBTree.left != null) {
                this.recPrint(vBTree.left);
            }
            System.out.println("(" + vBTree.point.dX() + "," + vBTree.point.dY() + ")" + "," + vBTree.theta);
            if (vBTree.right != null) {
                this.recPrint(vBTree.right);
            }
        }
    }

    protected void listPrintBack(VBTree vBTree) {
        VBTree vBTree2 = vBTree;
        if (vBTree2 != null) {
            System.out.println(vBTree2.num + ":(" + vBTree2.point.dX() + "," + vBTree2.point.dY() + ")" + "," + vBTree2.theta);
            vBTree2 = vBTree2.prev;
            while (vBTree2 != vBTree) {
                System.out.println(vBTree2.num + ":(" + vBTree2.point.dX() + "," + vBTree2.point.dY() + ")" + "," + vBTree2.theta);
                vBTree2 = vBTree2.prev;
            }
        }
    }

    protected void listPrint(VBTree vBTree) {
        VBTree vBTree2 = vBTree;
        if (vBTree2 != null) {
            System.out.println(vBTree2.num + ":(" + vBTree2.point.dX() + "," + vBTree2.point.dY() + ")" + "," + vBTree2.theta);
            vBTree2 = vBTree2.next;
            while (vBTree2 != vBTree) {
                System.out.println(vBTree2.num + ":(" + vBTree2.point.dX() + "," + vBTree2.point.dY() + ")" + "," + vBTree2.theta);
                vBTree2 = vBTree2.next;
            }
        }
    }

    static {
        maxPts = 0;
        root = null;
        head = null;
        currentf = null;
        currentb = null;
    }
}

