/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class Gamble {
    int id;
    int classId;
    double high_return;
    double highProb;
    double medium_return;
    double medProb;
    double low_return;
    double lowProb;
    List<Double> results = new ArrayList<Double>();

    public Gamble() {
    }

    public String toString() {
        return "Gamble [id=" + this.id + " classId=" + this.classId + " highProb=" + this.highProb + " medProb=" + this.medProb + " lowProb=" + this.lowProb + " high_return=" + this.high_return + " medium_return=" + this.medium_return + " low_return=" + this.low_return + "]\n";
    }

    public String outputToFile() {
        DecimalFormat nf = new DecimalFormat("#0.00");
        return "  " + this.id + "   " + this.classId + "     " + nf.format(this.high_return) + ":" + nf.format(this.highProb) + "     " + nf.format(this.medium_return) + ":" + nf.format(this.medProb) + "     " + nf.format(this.low_return) + ":" + nf.format(this.lowProb);
    }

    public Gamble(int id, int classId, double high_return, double highProb, double medium_return, double medProb, double low_return, double lowProb) {
        this.id = id;
        this.classId = classId;
        this.high_return = high_return;
        this.highProb = highProb;
        this.medium_return = medium_return;
        this.medProb = medProb;
        this.low_return = low_return;
        this.lowProb = lowProb;
    }

    public double play() {
        double dice = Math.random();
        if (dice < this.highProb) {
            this.results.add(this.high_return);
            return this.high_return;
        }
        if (dice < this.highProb + this.medProb) {
            this.results.add(this.medium_return);
            return this.medium_return;
        }
        this.results.add(this.low_return);
        return this.low_return;
    }

    public double playWithNewProb(double highprob, double medprob, double lowprob) {
        double dice = Math.random();
        if (dice < highprob) {
            this.results.add(this.high_return);
            return this.high_return;
        }
        if (dice < highprob + medprob) {
            this.results.add(this.medium_return);
            return this.medium_return;
        }
        this.results.add(this.low_return);
        return this.low_return;
    }

    public double getLastResult() {
        return this.results.get(this.results.size() - 1);
    }
}

