/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HumanPlayer {
    UserWindow userWindow;
    String name;
    private final int nGambles;
    private final int port;
    private final String host;
    private BufferedReader br;
    private BufferedWriter bw;
    private static final int windowWidth = 400;
    private static final int sliderHeight = 30;
    boolean connectionEstablished = false;

    public HumanPlayer(String host, int port, int nGambles, String fName) {
        this.nGambles = nGambles;
        this.host = host;
        this.port = port;
        this.userWindow = new UserWindow();
        this.userWindow.setSize(400, 65 + nGambles * 65);
        this.userWindow.setBackground(Color.WHITE);
        this.userWindow.setVisible(true);
    }

    private void play(Double[] allocs) {
        if (this.connectionEstablished) {
            String out = this.convertToString(this.nGambles, allocs);
            try {
                this.bw.write(String.valueOf(out) + "\n");
                this.bw.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void connect(String name) {
        System.out.println("connecting");
        try {
            Socket s = new Socket(this.host, this.port);
            this.bw = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
            this.br = new BufferedReader(new InputStreamReader(s.getInputStream()));
            this.bw.write(String.valueOf(name) + "\n");
            this.bw.flush();
            String in = this.br.readLine();
            if (!in.equals("OK")) {
                System.out.println("got back: " + in);
                throw new RuntimeException(in);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connectionEstablished = true;
    }

    public String convertToString(int nGambles, Double[] allocs) {
        DecimalFormat df = new DecimalFormat("0.00000");
        StringBuffer sb = new StringBuffer(nGambles * 8);
        int j = 0;
        while (j < nGambles) {
            sb.append(df.format(allocs[j])).append(" ");
            ++j;
        }
        String out = sb.toString();
        System.out.println("sending: " + out);
        return out;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.out.println("usage:  Java Player <Host> <Port> <Ngambles> <Datafilename>");
            System.exit(1);
        }
        new HumanPlayer(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]), args[3]);
    }

    static class MySlider
    extends JSlider {
        int num;
        static Font f2 = new Font("Dialog", 0, 12);

        public MySlider() {
            this.setMajorTickSpacing(10);
            this.setMinorTickSpacing(1);
            this.setFont(f2);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.repaint();
        }

        public void setNum(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }
    }

    static class ResultsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Double[] bets;
        MySlider[] slids;
        int nGambles;
        ChangeListener sliderChanged = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MySlider source = (MySlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    ResultsPanel.this.bets[source.getNum()] = source.getValue();
                    System.out.println(String.valueOf(source.getNum()) + " changed to " + source.getValue());
                }
            }
        };

        public ResultsPanel(int nGambles) {
            this.setPreferredSize(new Dimension(200, 300));
            this.setBorder(new BevelBorder(1));
            this.nGambles = nGambles;
            this.bets = new Double[nGambles];
            this.slids = new MySlider[nGambles];
            this.setBets();
        }

        public void setBets() {
            int i = this.nGambles - 1;
            while (i >= 0) {
                this.slids[i] = new MySlider();
                this.slids[i].setNum(i);
                this.slids[i].addChangeListener(this.sliderChanged);
                this.slids[i].setMajorTickSpacing(10);
                this.slids[i].setMinorTickSpacing(1);
                this.slids[i].setPaintTicks(true);
                this.slids[i].setPaintLabels(false);
                this.slids[i].setPreferredSize(new Dimension(375, 30));
                this.bets[i] = 50.0;
                JLabel sNum = new JLabel(String.valueOf(i) + " ", 0);
                sNum.setFont(new Font("Dialog", 0, 12));
                this.add(sNum);
                this.add(this.slids[i]);
                this.repaint();
                --i;
            }
        }

        public Double[] getBets() {
            return this.bets;
        }
    }

    class UserWindow
    extends JFrame {
        private static final long serialVersionUID = 1L;
        Font f1;
        Font f2;
        FontMetrics fm;
        JButton bPlay;
        JButton bSetName;
        JButton bStart;
        JTextField nameField;
        ResultsPanel pInputs;
        int idxOrder;
        double[] rets;
        double[] drs;
        Color[] colors;
        AffineTransform atVert;
        String name;
        JLabel lname;

        public UserWindow() {
            super("Human Player");
            this.f1 = new Font("Dialog", 1, 12);
            this.f2 = new Font("Dialog", 0, 12);
            this.fm = this.getFontMetrics(this.f2);
            this.idxOrder = -1;
            this.rets = new double[HumanPlayer.this.nGambles];
            this.drs = new double[HumanPlayer.this.nGambles];
            this.colors = new Color[HumanPlayer.this.nGambles];
            this.atVert = AffineTransform.getRotateInstance(-1.5707963267948966);
            this.name = "Human Player";
            this.buildGUI();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }

        void buildGUI() {
            this.lname = new JLabel("Name: " + this.name);
            JLabel lAttrs = new JLabel("Game with " + HumanPlayer.this.nGambles + " gambles");
            this.lname.setFont(this.f1);
            lAttrs.setFont(this.f2);
            this.bStart = new JButton("Start");
            this.bPlay = new JButton("Send");
            this.bSetName = new JButton("Set Name");
            this.nameField = new JTextField("Type your name", 10);
            this.bPlay.setFont(this.f1);
            this.bSetName.setFont(this.f1);
            this.bSetName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = UserWindow.this.nameField.getText();
                    System.out.println(UserWindow.this.nameField.getText());
                    if (!newName.equals("Type your name")) {
                        UserWindow.this.name = newName;
                        UserWindow.this.lname.setText("Name: " + UserWindow.this.name);
                        UserWindow.this.repaint();
                    }
                }
            });
            this.bStart.setFont(this.f1);
            this.bPlay.setEnabled(false);
            this.bStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserWindow.this.bPlay.setEnabled(true);
                    UserWindow.this.bStart.setEnabled(false);
                    UserWindow.this.bSetName.setEnabled(false);
                    HumanPlayer.this.connect(UserWindow.this.name);
                }
            });
            this.bPlay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Double[] bets = UserWindow.this.pInputs.getBets();
                    HumanPlayer.this.play(bets);
                }
            });
            JPanel pTop = new JPanel();
            pTop.add(this.lname);
            pTop.add(lAttrs);
            pTop.add(this.bPlay);
            pTop.add(this.nameField);
            pTop.add(this.bSetName);
            pTop.setPreferredSize(new Dimension(100, 65));
            JPanel pMid = new JPanel();
            pMid.add(this.bPlay);
            pMid.add(this.bStart);
            this.pInputs = new ResultsPanel(HumanPlayer.this.nGambles);
            this.pInputs.setBackground(Color.white);
            this.pInputs.setPreferredSize(new Dimension(100, HumanPlayer.this.nGambles * 100));
            Box boxNorth = Box.createVerticalBox();
            boxNorth.add(pTop);
            boxNorth.add(Box.createVerticalStrut(5));
            boxNorth.add(pMid);
            boxNorth.add(this.pInputs);
            boxNorth.add(Box.createVerticalStrut(5));
            JPanel pane = (JPanel)this.getContentPane();
            pane.setLayout(new BorderLayout());
            pane.setBorder(new EmptyBorder(5, 5, 5, 5));
            pane.add((Component)boxNorth, "North");
        }
    }
}

