/*
 * Decompiled with CFR 0.152.
 */
public class JumpSnatchGame {
    public Board board = new Board(3);
    public Player snatcher = null;
    public Player jumper = null;
    public boolean gameOver = false;
    public int numOfTurns = 0;
    public MoveList lastMoveList = null;
    public String mcMsg = null;

    public void newGame(int n) {
        this.board = new Board(n);
    }

    public void start(int n, int n2) {
        if (n == 0) {
            this.snatcher = new HumanPlayer(Integer.MAX_VALUE, n, 0);
        }
        if (n2 == 0) {
            this.jumper = new HumanPlayer(Integer.MAX_VALUE, n2, 1);
        }
        this.gameOver = false;
        this.numOfTurns = 0;
        this.lastMoveList = null;
    }

    public boolean isGameOver() {
        if (!this.gameOver && this.board.getNumOfStonesOnBoard() < 2) {
            this.gameOver = true;
        }
        return this.gameOver;
    }

    public Player getPreviousPlayer() {
        if (this.numOfTurns % 2 == 1) {
            return this.snatcher;
        }
        return this.jumper;
    }

    public Player getNextPlayer() {
        if (this.numOfTurns % 2 == 0) {
            return this.snatcher;
        }
        return this.jumper;
    }

    public boolean play(Player player, MoveList moveList) {
        boolean bl = false;
        Player player2 = this.getNextPlayer();
        MoveList moveList2 = null;
        Board board = null;
        this.mcMsg = null;
        if (!this.isGameOver()) {
            board = this.board.copy();
            moveList2 = player2.play(board);
            if (moveList2 != null) {
                this.mcMsg = this.board.editMoves(moveList2);
                if (this.mcMsg != null) {
                    this.board.executeMoves(moveList2);
                    bl = true;
                } else {
                    this.gameOver = true;
                }
            }
        } else {
            this.mcMsg = "Game is over";
        }
        ++this.numOfTurns;
        this.lastMoveList = moveList2;
        player = player2;
        moveList = moveList2;
        return bl;
    }

    public String getLastMsg() {
        return this.mcMsg;
    }
}

