/*
 * Decompiled with CFR 0.152.
 */
package nyu.hps.notipping.web;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import nyu.hps.notipping.web.HelpFrame;
import nyu.hps.notipping.web.Move;
import nyu.hps.notipping.web.Weight;
import optimalMove.NotippingAutoPlayer;

public class NoTippingComponent
extends Component
implements MouseListener,
MouseMotionListener,
ActionListener {
    private int width;
    private int height;
    private int meter;
    private int ss_width;
    private int horizon;
    private int ss_height;
    private int f_height;
    private Vector weights;
    private int weight_selected;
    private int selected_x;
    private int selected_y;
    private int whose_turn;
    private int left_torque;
    private int right_torque;
    private boolean game_over;
    private Stack moves;
    private int phase;
    private int num_on_grass;
    private int who_lost;
    private BufferedImage image;
    private HelpFrame help_frame;
    public String player1 = "human";
    public String player2 = "computer";
    boolean showhint = false;
    int difficulty = 0;
    int max_seconds = 3;
    int currentgame = 0;
    NotippingAutoPlayer comp_player = null;
    String hint = "";
    private Button startb = null;
    private int last_weight;
    private int last_position;
    private int last_player;
    private int max_weights = 10;
    private int max_positions = 15;
    public static String winner = "not set";
    public static String loser = "not set";
    public static String winnerScore = "not set";
    public static String loserScore = "not set";

    public static String getTheWinner() {
        return winner;
    }

    public static String getTheLoser() {
        return loser;
    }

    public static String getTheWinnerScore() {
        return winnerScore;
    }

    public static String getTheLoserScore() {
        return loserScore;
    }

    private Rectangle computeRectangle(Weight weight) {
        int n = weight.w * 2 + 17;
        if (weight.place == 0) {
            if (weight.whose == 0) {
                return new Rectangle(20 * weight.w + 10, 15 + (8 - weight.w) * 2, 12, n);
            }
            return new Rectangle(this.width - 20 * (10 - weight.w) - 20, 15 + (8 - weight.w) * 2, 12, n);
        }
        if (weight.place == 1) {
            return new Rectangle(this.screen_x(weight.position) - 6, this.horizon - this.ss_height - this.f_height - n, 12, n);
        }
        return new Rectangle(20 * weight.position + 10, this.height - 40 + (8 - weight.w) * 2, 12, n);
    }

    public void setPlayers(int n) {
        switch (n) {
            case 0: {
                System.out.println("human vs computer");
                this.player1 = "human";
                this.player2 = "computer";
                this.comp_player = new NotippingAutoPlayer(2, this.max_seconds);
                this.comp_player.setMaxWeights(this.max_weights);
                this.comp_player.start();
                break;
            }
            case 1: {
                System.out.println("computer vs human");
                this.player1 = "computer";
                this.player2 = "human";
                this.comp_player = new NotippingAutoPlayer(1, this.max_seconds);
                this.comp_player.setMaxWeights(this.max_weights);
                this.comp_player.start();
                break;
            }
            default: {
                System.out.println("human vs human");
                this.player1 = "human";
                this.player2 = "human";
            }
        }
        this.currentgame = n;
    }

    public void setDifficulty(int n) {
        this.difficulty = n;
        switch (this.difficulty) {
            case 0: {
                this.max_seconds = 3;
                break;
            }
            case 1: {
                this.max_seconds = 8;
                break;
            }
            case 2: {
                this.max_seconds = 15;
                break;
            }
            default: {
                this.max_seconds = 8;
            }
        }
        System.out.println("max_seconds=" + this.max_seconds);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("actionPerformed(" + actionEvent.getActionCommand() + ")");
        if (actionEvent.getActionCommand().equals("NumWeights")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n = jComboBox.getSelectedIndex();
            int n2 = n + 5;
            if (n2 >= this.max_positions) {
                JOptionPane.showMessageDialog(null, "Invalid. There cannot be more weights than available slots " + n2 + "," + this.max_positions);
                jComboBox.setSelectedIndex(this.max_weights - 5);
                return;
            }
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                jComboBox.setSelectedIndex(this.max_weights - 5);
                return;
            }
            this.max_weights = n + 5;
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (actionEvent.getActionCommand().equals("SeesawLength")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n = jComboBox.getSelectedIndex();
            int n3 = n + 5;
            if (this.max_weights >= n3) {
                JOptionPane.showMessageDialog(null, "Invalid. There cannot be more weights than available slots " + this.max_weights + "," + n3);
                jComboBox.setSelectedIndex(this.max_positions - 5);
                return;
            }
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                jComboBox.setSelectedIndex(this.max_positions - 5);
                return;
            }
            this.max_positions = n + 5;
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (actionEvent.getActionCommand().equals("Difficulty")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n = jComboBox.getSelectedIndex();
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                jComboBox.setSelectedIndex(this.currentgame);
                return;
            }
            this.setDifficulty(n);
            this.setPlayers(this.currentgame);
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (actionEvent.getActionCommand().equals("GameType")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n = jComboBox.getSelectedIndex();
            if (this.moves.size() != 0 && JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) != 0) {
                jComboBox.setSelectedIndex(this.currentgame);
                return;
            }
            this.setPlayers(n);
            this.begin();
            this.update(this.getGraphics());
            return;
        }
        if (actionEvent.getActionCommand().equals("Hint")) {
            if (this.currentgame == 2) {
                this.hint = "No hints for human vs human mode";
            } else if (this.isComputerMove()) {
                this.hint = "Not your move";
            } else if (this.comp_player != null) {
                String string = this.getCurrentState();
                this.hint = "Hint: " + this.comp_player.getHint(string);
            } else {
                this.hint = "Hint on First move? Common! Use Put 3 at -1";
            }
            this.showhint = true;
            this.paint(this.getGraphics());
            return;
        }
        if (actionEvent.getActionCommand().equals("Undo")) {
            System.out.println("Undo");
            if (this.moves.size() == 0) {
                return;
            }
            Move move = (Move)this.moves.pop();
            if (this.phase == 1) {
                --this.num_on_grass;
            }
            if (this.moves.size() == 13) {
                this.phase = 0;
            }
            this.whose_turn = 1 - this.whose_turn;
            Weight weight = (Weight)this.weights.get(move.w_index);
            if (move.position == -1) {
                weight.place = 0;
            } else {
                weight.place = 1;
                weight.position = move.position;
            }
            if (this.game_over) {
                this.game_over = false;
                int n = this.weights.size() - 1;
                for (int i = 0; i < n; ++i) {
                    weight = (Weight)this.weights.get(i);
                    weight.do_draw = true;
                }
            }
            this.update(this.getGraphics());
            return;
        }
        if (actionEvent.getActionCommand().equals("Restart")) {
            if (this.moves.size() == 0 || JOptionPane.showConfirmDialog(null, "Start New Game? Current game will be lost", "Confirmation", 2) == 0) {
                this.startb = (Button)actionEvent.getSource();
                this.begin();
                this.startb.setLabel("Restart");
                this.play1();
                this.update(this.getGraphics());
                winner = "not set";
                loser = "not set";
                winnerScore = "not set";
                loserScore = "not set";
            }
            return;
        }
        if (actionEvent.getActionCommand().equals("Help")) {
            this.help_frame.setVisible(true);
        }
        String string = actionEvent.getActionCommand();
        this.makethemove(string);
    }

    public String getCurrentState() {
        String string = "";
        string = this.phase == 0 ? "ADD|" : "REMOVE|";
        for (int i = 0; i < this.weights.size(); ++i) {
            Weight weight = (Weight)this.weights.get(i);
            if (weight.place != 1 || !weight.do_draw) continue;
            string = string + weight.w + "," + weight.position + " ";
        }
        string = string + "|";
        string = string + "in=" + this.right_torque + ",out=" + this.left_torque;
        System.out.println(string);
        return string;
    }

    public void makethemove(String string) {
        if (this.phase == 0) {
            Weight weight;
            int n = string.indexOf(44);
            if (n == -1) {
                System.out.println("Syntax Error");
                return;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            int n2 = new Integer(string2);
            int n3 = new Integer(string3);
            int n4 = this.weights.size() - 1;
            for (n = 0; n < n4; ++n) {
                weight = (Weight)this.weights.get(n);
                if (weight.position != n3 || weight.place != 1) continue;
                return;
            }
            for (n = 0; n < n4; ++n) {
                weight = (Weight)this.weights.get(n);
                if (n2 != weight.w || weight.whose != this.whose_turn || weight.place != 0) continue;
                weight.place = 1;
                weight.position = n3;
                this.moves.push(new Move(n, this.whose_turn, -1));
                if (this.moves.size() == this.max_weights * 2) {
                    ++this.phase;
                }
                this.last_player = this.whose_turn;
                this.last_weight = n2;
                this.last_position = n3;
                this.whose_turn = 1 - this.whose_turn;
                this.update(this.getGraphics());
                return;
            }
        } else {
            System.out.println("************Using this for removing....." + string);
            System.out.println("Player=" + this.whose_turn);
            int n = string.indexOf(44);
            if (n == -1) {
                System.out.println("Syntax Error");
                return;
            }
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1, string.length());
            int n5 = new Integer(string4);
            int n6 = new Integer(string5);
            int n7 = this.weights.size() - 1;
            for (n = 0; n < n7; ++n) {
                Weight weight = (Weight)this.weights.get(n);
                if (weight.w != n5 || weight.position != n6 || weight.place != 1) continue;
                weight.place = 2;
                this.moves.push(new Move(n, this.whose_turn, weight.position));
                weight.position = this.num_on_grass++;
                this.last_player = this.whose_turn;
                this.last_weight = n5;
                this.last_position = n6;
                this.whose_turn = 1 - this.whose_turn;
                this.update(this.getGraphics());
                return;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        System.out.println("getPreferredSize()");
        return new Dimension(500, 300);
    }

    @Override
    public void setSize(Dimension dimension) {
        System.out.println("setSize(Dimension)");
        this.setSize(dimension.width, dimension.height);
    }

    @Override
    public void setSize(int n, int n2) {
        System.out.println("setSize(int, int)");
        this.width = n;
        this.height = n2;
        super.setSize(n, n2);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        System.out.println("setBounds(Rectangle)");
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        System.out.println("setBounds(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        if (this.width == n3 && this.height == n4) {
            return;
        }
        this.width = n3;
        this.height = n4;
        super.setBounds(n, n2, n3, n4);
        this.image = new BufferedImage(n3, n4, 1);
    }

    public NoTippingComponent() {
        System.out.println("NoTippingComponent() v1.4");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.help_frame = new HelpFrame();
        this.help_frame.setVisible(false);
        this.begin();
    }

    @Override
    public void update(Graphics graphics) {
        System.out.println("update(Graphics()");
        this.paint(graphics);
    }

    private void begin() {
        Weight weight;
        this.weights = new Vector();
        this.weight_selected = -1;
        this.whose_turn = 0;
        this.game_over = false;
        this.moves = new Stack();
        this.phase = 0;
        this.num_on_grass = 0;
        for (int i = 1; i <= this.max_weights; ++i) {
            weight = new Weight(i, 0, 0, 0);
            this.weights.add(weight);
            weight = new Weight(i, 1, 0, 0);
            this.weights.add(weight);
        }
        this.weights.add(new Weight(3, 2, 1, -4));
        weight = new Weight(3, 2, 1, 0);
        weight.do_draw = false;
        this.weights.add(weight);
        this.last_weight = -1;
        this.last_position = -999;
        this.last_player = -999;
        if (this.startb != null) {
            this.startb.setLabel("Start");
        }
    }

    public void play1() {
        if (this.currentgame == 1) {
            try {
                String string = this.getCurrentState();
                String string2 = this.comp_player.getMove(string);
                String[] stringArray = string2.split(",");
                Weight weight = new Weight(Integer.parseInt(stringArray[0]), this.whose_turn, 0, 0);
                Rectangle rectangle = this.computeRectangle(weight);
                this.mousePressed(new MouseEvent(this, 501, (int)System.currentTimeMillis(), 1040, (int)rectangle.getCenterX(), (int)rectangle.getCenterY(), 1, false, 1));
                this.makethemove(string2);
                int n = this.screen_x(Integer.parseInt(stringArray[1]));
                int n2 = this.horizon - this.ss_height - this.f_height - 15;
                this.generateMouseMovements((int)rectangle.getCenterX(), (int)rectangle.getCenterY(), n, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void repaint() {
        System.out.println("repaint()");
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        Object object2;
        Object object3;
        int n;
        System.out.println("paint(Graphics)");
        this.horizon = this.height * 4 / 5;
        this.ss_height = this.height / 16;
        this.f_height = this.height / 10;
        this.ss_width = this.width - 100 + 16;
        this.meter = (this.ss_width - 16) / 30;
        int n2 = this.weights.size();
        this.left_torque = 0;
        this.right_torque = 0;
        for (n = 0; n < n2; ++n) {
            object3 = (Weight)this.weights.get(n);
            if (((Weight)object3).place != 1) continue;
            this.left_torque -= (((Weight)object3).position - -3) * ((Weight)object3).w;
            this.right_torque -= (((Weight)object3).position - -1) * ((Weight)object3).w;
        }
        if (this.left_torque > 0 || this.right_torque < 0) {
            if (!this.game_over) {
                this.who_lost = 1 - this.whose_turn;
                for (n = 0; n < n2; ++n) {
                    object3 = (Weight)this.weights.get(n);
                    if (((Weight)object3).place != 0) continue;
                    ((Weight)object3).do_draw = false;
                }
            }
            this.game_over = true;
        }
        object3 = this.image.createGraphics();
        ((Graphics)object3).setColor(new Color(140, 150, 200));
        ((Graphics)object3).drawRect(0, 0, this.width, this.height);
        ((Graphics)object3).fillRect(0, 0, this.width, this.height);
        ((Graphics)object3).setColor(new Color(250, 240, 230));
        ((Graphics)object3).fillOval(this.width - 100, 20, 50, 30);
        ((Graphics)object3).fillOval(this.width - 80, 30, 50, 30);
        ((Graphics)object3).fillOval(this.width - 90, 25, 40, 36);
        ((Graphics)object3).fillOval(this.width - 150, 15, 60, 40);
        ((Graphics)object3).fillOval(this.width - 160, 25, 50, 35);
        ((Graphics)object3).fillOval(this.width - 130, 30, 55, 35);
        ((Graphics)object3).fillOval(this.width - 50, 10, 40, 30);
        ((Graphics)object3).fillOval(this.width - 65, 15, 45, 35);
        ((Graphics)object3).fillOval(this.width - 130, 10, 80, 30);
        ((Graphics)object3).setColor(new Color(0, 255, 0));
        ((Graphics)object3).drawRect(0, this.horizon, this.width - 1, this.height - this.horizon);
        ((Graphics)object3).setColor(new Color(0, 255, 0));
        ((Graphics)object3).fillRect(0, this.horizon, this.width - 1, this.height - this.horizon);
        ((Graphics)object3).setColor(new Color(180, 120, 0));
        for (n = 0; n < 5; ++n) {
            ((Graphics)object3).drawLine(this.screen_x(-3) - n, this.horizon, this.screen_x(-3), this.horizon - this.f_height);
            ((Graphics)object3).drawLine(this.screen_x(-3), this.horizon - this.f_height, this.screen_x(-3) + n, this.horizon);
            ((Graphics)object3).drawLine(this.screen_x(-1) - n, this.horizon, this.screen_x(-1), this.horizon - this.f_height);
            ((Graphics)object3).drawLine(this.screen_x(-1), this.horizon - this.f_height, this.screen_x(-1) + n, this.horizon);
        }
        ((Graphics)object3).setColor(new Color(0, 0, 0));
        Font font = ((Graphics)object3).getFont();
        String string = Integer.toString(this.left_torque);
        String string2 = Integer.toString(this.right_torque);
        Graphics2D graphics2D = (Graphics2D)object3;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int n3 = (int)font.getStringBounds(string, fontRenderContext).getWidth();
        int n4 = (int)font.getStringBounds(string, fontRenderContext).getHeight();
        ((Graphics)object3).drawString(string, this.screen_x(-3) - n3 / 2, this.horizon + n4 + 3);
        n3 = (int)font.getStringBounds(string2, fontRenderContext).getWidth();
        n4 = (int)font.getStringBounds(string2, fontRenderContext).getHeight();
        ((Graphics)object3).drawString(string2, this.screen_x(-1) - n3 / 2, this.horizon + n4 + 3);
        if (this.showhint) {
            ((Graphics)object3).drawString(this.hint, 30, 120);
            this.showhint = false;
        }
        if (this.game_over) {
            object2 = new Font("SansSerif", 1, 30);
            object = ((Graphics)object3).getFont();
            ((Graphics)object3).setFont((Font)object2);
            ((Graphics)object3).drawString("Bummer, dude", 30, 100);
            if (this.who_lost == 0) {
                ((Graphics)object3).drawString("Red lost :(", 30, 140);
                winner = "Blue (" + this.player2 + ")";
                loser = "Red (" + this.player1 + ")";
                winnerScore = "won";
                loserScore = "lost";
            } else {
                ((Graphics)object3).drawString("Blue lost :(", 30, 140);
                winner = "Red (" + this.player1 + ")";
                loser = "Blue (" + this.player2 + ")";
                winnerScore = "won";
                loserScore = "lost";
            }
            ((Graphics)object3).setFont((Font)object);
            double d = 0.0;
            int n5 = 0;
            if (this.left_torque > 0) {
                d = -Math.atan((double)this.f_height / (double)(this.screen_x(-3) - this.screen_x(-10) + 8));
                n5 = this.screen_x(-3);
            }
            if (this.right_torque < 0) {
                d = Math.atan((double)this.f_height / (double)(this.screen_x(10) - this.screen_x(-1) + 8));
                n5 = this.screen_x(-1);
            }
            System.out.println("theta is " + d);
            System.out.println("taking atan of " + (double)this.f_height / (double)(this.screen_x(10) - this.screen_x(-1) + 8));
            graphics2D.rotate(d, n5, this.horizon - this.f_height);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.setColor(new Color(230, 235, 240));
        graphics2D.fillRect(42, this.horizon - this.ss_height - this.f_height, this.ss_width, this.ss_height);
        graphics2D.setColor(new Color(60, 20, 0));
        for (n = -1 * this.max_positions; n <= this.max_positions; ++n) {
            if (n == this.last_position) {
                graphics2D.drawLine(this.screen_x(n), this.horizon - this.ss_height - this.f_height, this.screen_x(n), this.horizon - this.f_height - this.ss_height * 15 / 4);
            } else {
                graphics2D.drawLine(this.screen_x(n), this.horizon - this.ss_height - this.f_height, this.screen_x(n), this.horizon - this.f_height - this.ss_height * 3 / 4);
            }
            object2 = "";
            font = ((Graphics)object3).getFont();
            int n6 = (int)font.getStringBounds((String)object2, graphics2D.getFontRenderContext()).getWidth();
            if (n % 2 == 0 && Math.abs(n) != this.max_positions) {
                object2 = new String(Integer.toString(n));
            }
            if (n == this.last_position) {
                object2 = (String)object2 + "*";
            }
            graphics2D.drawString((String)object2, this.screen_x(n) - n6 / 2, this.horizon - this.f_height - 1);
        }
        n2 = this.weights.size();
        for (n = 0; n < n2; ++n) {
            object = (Weight)this.weights.get(n);
            switch (((Weight)object).whose) {
                case 0: {
                    object2 = new Color(200, 0, 0);
                    break;
                }
                case 1: {
                    object2 = new Color(0, 0, 200);
                    break;
                }
                default: {
                    object2 = new Color(0, 180, 0);
                }
            }
            graphics2D.setColor((Color)object2);
            Rectangle rectangle = this.computeRectangle((Weight)object);
            if (!((Weight)object).do_draw || this.game_over && ((Weight)object).place != 1) continue;
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setColor(new Color(255, 255, 255));
            graphics2D.drawString(Integer.toString(((Weight)object).w), rectangle.x + 2, rectangle.y + rectangle.height - 2);
        }
        if (this.weight_selected >= 0) {
            object2 = (Weight)this.weights.get(this.weight_selected);
            switch (((Weight)object2).whose) {
                case 0: {
                    object = new Color(200, 0, 0);
                    break;
                }
                case 1: {
                    object = new Color(0, 0, 200);
                    break;
                }
                default: {
                    object = new Color(0, 180, 0);
                }
            }
            graphics2D.setColor((Color)object);
            Rectangle rectangle = new Rectangle(this.selected_x, this.selected_y, 12, ((Weight)object2).w * 2 + 17);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setColor(new Color(255, 255, 255));
            graphics2D.drawString(Integer.toString(((Weight)object2).w), rectangle.x + 2, rectangle.y + rectangle.height - 2);
        }
        if (!this.game_over) {
            if (this.whose_turn == 0) {
                object2 = new Color(150, 0, 0);
                object = new String("It's Red's turn");
                if (this.currentgame == 1) {
                    object = (String)object + ". (Thinking...may take up to " + this.max_seconds + " seconds)";
                }
            } else {
                object2 = new Color(0, 0, 150);
                object = new String("It's Blue's turn");
                if (this.currentgame == 0) {
                    object = (String)object + ". (Thinking...may take up to " + this.max_seconds + " seconds)";
                }
            }
            ((Graphics)object3).setColor((Color)object2);
            ((Graphics)object3).drawString((String)object, 30, 70);
            object2 = new Color(0, 0, 0);
            ((Graphics)object3).setColor((Color)object2);
            object = this.phase == 0 ? new String("Adding phase") : new String("Removing phase");
            ((Graphics)object3).drawString((String)object, 30, 90);
        }
        graphics.drawImage(this.image, 0, 0, null);
    }

    public boolean isComputerMove() {
        return this.whose_turn == 1 && this.player2.equals("computer") || this.whose_turn == 0 && this.player1.equals("computer");
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        System.out.println("mouseDragged(MouseEvent)");
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 0) {
            n = 0;
        }
        if (n >= this.width) {
            n = this.width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        if (this.weight_selected < 0) {
            return;
        }
        Weight weight = (Weight)this.weights.get(this.weight_selected);
        int n3 = weight.w * 2 + 17;
        this.selected_x = n - 6;
        this.selected_y = n2 - n3 / 2;
        this.update(this.getGraphics());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        System.out.println("mousePressed(MouseEvent)");
        if (this.isComputerMove()) {
            return;
        }
        int n = this.weights.size();
        for (int i = 0; i < n; ++i) {
            Weight weight = (Weight)this.weights.get(i);
            Rectangle rectangle = this.computeRectangle(weight);
            if (!rectangle.contains(mouseEvent.getPoint()) || weight.whose != this.whose_turn && this.phase == 0) continue;
            System.out.println("weight hit");
            this.weight_selected = i;
            weight.do_draw = false;
            this.selected_x = rectangle.x;
            this.selected_y = rectangle.y;
            this.update(this.getGraphics());
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        System.out.println("mouseReleased(MouseEvent)");
        if (this.weight_selected < 0) {
            return;
        }
        Weight weight = (Weight)this.weights.get(this.weight_selected);
        weight.do_draw = true;
        Point point = mouseEvent.getPoint();
        int n = this.horizon - this.ss_height - this.f_height - 40;
        Rectangle rectangle = new Rectangle(0, this.horizon, this.width, this.height - this.horizon);
        if (rectangle.contains(point)) {
            weight.place = 2;
            this.moves.push(new Move(this.weight_selected, this.whose_turn, weight.position));
            this.last_position = weight.position;
            this.last_player = this.whose_turn;
            this.last_weight = weight.w;
            weight.position = this.num_on_grass++;
            this.whose_turn = 1 - this.whose_turn;
            this.weight_selected = -1;
            this.update(this.getGraphics());
        } else {
            for (int i = -1 * this.max_positions; i <= this.max_positions; ++i) {
                object2 = new Rectangle(this.screen_x(i) - this.meter / 2, n, this.meter, 50);
                if (!((Rectangle)object2).contains(point)) continue;
                int n2 = this.weights.size() - 1;
                for (int j = 0; j < n2; ++j) {
                    object = (Weight)this.weights.get(j);
                    if (((Weight)object).place != 1 || ((Weight)object).position != i) continue;
                    this.weight_selected = -1;
                    this.update(this.getGraphics());
                    return;
                }
                weight.place = 1;
                weight.position = i;
                this.moves.push(new Move(this.weight_selected, this.whose_turn, -1));
                if (this.moves.size() == this.max_weights * 2) {
                    ++this.phase;
                }
                this.last_position = weight.position;
                this.last_player = this.whose_turn;
                this.last_weight = weight.w;
                this.whose_turn = 1 - this.whose_turn;
                break;
            }
            this.weight_selected = -1;
            this.update(this.getGraphics());
        }
        if (this.isComputerMove()) {
            if (this.comp_player == null) {
                this.comp_player = new NotippingAutoPlayer(2, this.max_seconds);
                this.comp_player.setMaxWeights(this.max_weights);
                this.comp_player.start();
            }
            String string = this.getCurrentState();
            object2 = this.comp_player.getMove(string);
            String[] stringArray = ((String)object2).split(",");
            Weight weight2 = new Weight(Integer.parseInt(stringArray[0]), this.whose_turn, 0, 0);
            object = this.computeRectangle(weight2);
            this.mousePressed(new MouseEvent(this, 501, (int)System.currentTimeMillis(), 1040, (int)((RectangularShape)object).getCenterX(), (int)((RectangularShape)object).getCenterY(), 1, false, 1));
            this.makethemove((String)object2);
            int n3 = this.screen_x(Integer.parseInt(stringArray[1]));
            int n4 = this.horizon - this.ss_height - this.f_height - 15;
            try {
                this.generateMouseMovements((int)((RectangularShape)object).getCenterX(), (int)((RectangularShape)object).getCenterY(), n3, n4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void generateMouseMovements(int n, int n2, int n3, int n4) throws Exception {
        int n5 = 1500;
        double d = n;
        double d2 = n2;
        double d3 = n3 - n;
        double d4 = n4 - n2;
        double d5 = (n2 + n4) / 2;
        double d6 = d3 / (double)n5;
        double d7 = d4 / (double)n5;
        do {
            Thread.sleep(30L);
            d2 = d5;
            this.mouseDragged(new MouseEvent(this, 506, (int)System.currentTimeMillis(), 1040, (int)d, (int)d2, 1, false, 0));
        } while (d2 != d5);
        do {
            Thread.sleep(30L);
            d = n3;
            this.mouseDragged(new MouseEvent(this, 506, (int)System.currentTimeMillis(), 1040, (int)d, (int)d2, 1, false, 0));
        } while (d != (double)n3);
        do {
            Thread.sleep(30L);
            d2 = n4;
            this.mouseDragged(new MouseEvent(this, 506, (int)System.currentTimeMillis(), 1040, (int)d, (int)d2, 1, false, 0));
        } while (d2 != (double)n4);
        this.mouseReleased(new MouseEvent(this, 502, (int)System.currentTimeMillis(), 16, (int)d, (int)d2, 1, false, 1));
    }

    private int screen_x(int n) {
        return 42 + this.ss_width / 2 + n * this.meter;
    }
}

