/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Superply
extends Applet
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    TextField player1Field;
    TextField player2Field;
    Button enterButton;
    Button start;
    Button askHint;
    Button infoOn;
    Button infoOff;
    public String winner = "not set";
    public String loser = "not set";
    private String[] player = new String[3];
    private boolean gameInProgress = false;
    private int currPlayer = 2;
    private int xPos;
    private int yPos;
    private String resultMessage = null;
    private String hint = "";
    private Board board = new Board();
    private boolean gameOver = false;
    private boolean hintIsOn = false;
    private boolean infoIsOn = true;

    @Override
    public void init() {
        this.setSize(580, 530);
        this.enterButton = new Button("Enter");
        this.player1Field = new TextField("Player 1");
        this.player2Field = new TextField("Player 2");
        this.enterButton.setBounds(100, 150, 120, 40);
        this.enterButton.addActionListener(this);
        this.player1Field.addActionListener(this);
        this.player2Field.addActionListener(this);
        this.add(this.player1Field);
        this.add(this.player2Field);
        this.add(this.enterButton);
        this.board = new Board();
        this.currPlayer = 2;
        this.gameOver = false;
    }

    public String getWinner() {
        return this.winner;
    }

    public String getLoser() {
        return this.loser;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.enterButton) {
            this.player[1] = this.player1Field.getText();
            this.player[2] = this.player2Field.getText();
            this.gameInProgress = true;
            this.remove(this.player1Field);
            this.remove(this.player2Field);
            this.remove(this.enterButton);
            System.out.println("here ");
            this.start = new Button("Restart");
            this.start.setBounds(420, 100, 100, 40);
            this.start.addActionListener(this);
            this.add(this.start);
            this.askHint = new Button("hint");
            this.askHint.setBounds(420, 160, 100, 40);
            this.askHint.addActionListener(this);
            this.add(this.askHint);
            this.infoOn = new Button("Info On");
            this.infoOn.setBounds(420, 220, 100, 40);
            this.infoOn.addActionListener(this);
            this.infoOff = new Button("Info Off");
            this.infoOff.setBounds(420, 220, 100, 40);
            this.infoOff.addActionListener(this);
            this.add(this.infoOff);
            this.addMouseListener(this);
            this.restart();
            System.out.println("names set to " + this.player[1] + " and " + this.player[2]);
        }
        if (actionEvent.getSource() == this.start) {
            this.restart();
        }
        if (actionEvent.getSource() == this.askHint) {
            this.hintIsOn = !this.hintIsOn;
            this.repaint();
        }
        if (actionEvent.getSource() == this.infoOff) {
            this.infoIsOn = false;
            this.remove(this.infoOff);
            this.add(this.infoOn);
            this.repaint();
        }
        if (actionEvent.getSource() == this.infoOn) {
            this.infoIsOn = true;
            this.remove(this.infoOn);
            this.add(this.infoOff);
            this.repaint();
        }
    }

    private void restart() {
        this.board = new Board();
        this.winner = "not set";
        this.loser = "not set";
        this.currPlayer = 2;
        this.gameOver = false;
        this.currPlayer = 3 - this.currPlayer;
        this.hint = this.board.generateNextHint();
        this.hintIsOn = false;
        this.resultMessage = "";
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        if (!this.gameInProgress) {
            return;
        }
        this.start.setBounds(420, 170, 100, 40);
        this.askHint.setBounds(420, 230, 100, 40);
        this.infoOn.setBounds(420, 290, 100, 40);
        this.infoOff.setBounds(420, 290, 100, 40);
        for (n = 1; n < 11; ++n) {
            graphics.drawString("" + n, 60, 30 * n + 130);
            graphics.drawString("" + n, 30 * n + 60, 138);
        }
        for (n = 0; n < 10; ++n) {
            for (int i = 0; i < 10; ++i) {
                switch (this.board.getPlayer(n, i)) {
                    case 1: {
                        graphics.setColor(Color.RED);
                        break;
                    }
                    case 2: {
                        graphics.setColor(Color.BLUE);
                        break;
                    }
                    case 4: {
                        if (this.hintIsOn) {
                            graphics.setColor(Color.GREEN);
                            break;
                        }
                    }
                    default: {
                        graphics.setColor(Color.GRAY);
                    }
                }
                graphics.fillRect(80 + n * 30, 140 + i * 30, 28, 28);
                if (this.board.getPlayer(n, i) != 1 && this.board.getPlayer(n, i) != 2) continue;
                graphics.setColor(Color.WHITE);
                graphics.drawString("" + (n + 1) * (i + 1), 87 + n * 30, 157 + i * 30);
            }
        }
        Font font = new Font("Dialog", 1, 14);
        graphics.setFont(font);
        if (this.infoIsOn) {
            graphics.setColor(Color.RED);
            graphics.drawString(this.player[1] + ", try to connect the upper side to the lower side with red squares", 30, 500);
            graphics.setColor(Color.BLUE);
            graphics.drawString(this.player[2] + ", try to connect the right side to the left side with blue squares", 30, 520);
        }
        if (this.currPlayer == 1) {
            graphics.setColor(Color.RED);
        } else {
            graphics.setColor(Color.BLUE);
        }
        if (this.gameOver) {
            font = new Font("Dialog", 1, 24);
            graphics.setFont(font);
            graphics.drawString("Winner is " + this.player[this.currPlayer] + "!!!", 100, 70);
            this.winner = this.player[this.currPlayer];
            this.loser = this.winner == this.player[1] ? this.player[2] : this.player[1];
        } else {
            graphics.drawString(this.player[this.currPlayer] + "'s turn", 100, 35);
            graphics.drawString(this.hint, 100, 57);
            graphics.setColor(Color.BLACK);
            graphics.drawString(this.resultMessage, 100, 79);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("mouse clicked");
        this.hintIsOn = false;
        this.repaint();
        this.xPos = mouseEvent.getX();
        this.yPos = mouseEvent.getY();
        if (this.xPos < 380 && this.xPos > 80 && this.yPos > 140 && this.yPos < 440 && !this.gameOver) {
            int n = this.board.acceptMove((this.xPos - 80) / 30, (this.yPos - 140) / 30, this.currPlayer);
            switch (n) {
                case 1: {
                    this.resultMessage = " Invalid Move!";
                    break;
                }
                case 2: {
                    this.resultMessage = this.player[this.currPlayer] + " had bad guess!";
                    this.currPlayer = 3 - this.currPlayer;
                    System.out.println("switch user");
                    this.hint = this.board.generateNextHint().toString();
                    this.repaint();
                    break;
                }
                case 0: {
                    if (this.board.isTherePath(this.currPlayer)) {
                        this.gameOver = true;
                        System.out.println("game over");
                    } else {
                        this.resultMessage = this.player[this.currPlayer] + " colored the square";
                        this.currPlayer = 3 - this.currPlayer;
                        this.hint = this.board.generateNextHint().toString();
                    }
                    this.repaint();
                    break;
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

