/*
 * Decompiled with CFR 0.152.
 */
public class Board {
    public int mnSize;
    public boolean[][] mbArrCellEmpty;

    public Board(int n) {
        this.mnSize = n;
        this.mbArrCellEmpty = new boolean[this.mnSize][this.mnSize];
        for (int i = 0; i < this.mnSize; ++i) {
            for (int j = 0; j < this.mnSize; ++j) {
                this.mbArrCellEmpty[i][j] = false;
            }
        }
    }

    public Board(Board board) {
        this.mnSize = board.mnSize;
        this.mbArrCellEmpty = new boolean[this.mnSize][this.mnSize];
        for (int i = 0; i < this.mnSize; ++i) {
            for (int j = 0; j < this.mnSize; ++j) {
                this.mbArrCellEmpty[i][j] = board.mbArrCellEmpty[i][j];
            }
        }
    }

    public Board copy() {
        Board board = new Board(this);
        return board;
    }

    public Board getBoard() {
        return this;
    }

    public boolean[][] getRawBoard() {
        return this.mbArrCellEmpty;
    }

    public boolean isEmpty(int n, int n2) {
        return this.mbArrCellEmpty[n][n2];
    }

    public boolean isValidIndex(int n, int n2) {
        return n >= 0 && n < this.mnSize && n2 >= 0 && n2 < this.mnSize;
    }

    public boolean isValidMoveIndex(Move move) {
        if (move != null) {
            return this.isValidIndex(move.x, move.y);
        }
        return false;
    }

    public boolean isValidMoveTo(Move move) {
        return this.isValidIndex(move.x, move.y) && this.mbArrCellEmpty[move.x][move.y];
    }

    public boolean isBoardFull() {
        return this.getNumOfStonesOnBoard() == this.mnSize * this.mnSize;
    }

    public int getNumOfStonesOnBoard() {
        int n = 0;
        for (int i = 0; i < this.mnSize; ++i) {
            for (int j = 0; j < this.mnSize; ++j) {
                if (this.mbArrCellEmpty[i][j]) continue;
                ++n;
            }
        }
        return n;
    }

    public String editMoves(MoveList moveList) {
        boolean bl = true;
        MoveIterator moveIterator = moveList.getIterator();
        Move move = null;
        Move move2 = null;
        Move move3 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        String string = null;
        int n = this.mnSize * this.mnSize;
        if (this.getNumOfStonesOnBoard() == n) {
            if (moveList.size() == 1) {
                move = moveIterator.next();
                if (!this.isValidIndex(move.x, move.y)) {
                    bl = false;
                    string = "Invalid index to snatch: " + move.toString();
                } else {
                    move.type = 0;
                }
            } else {
                bl = false;
                string = "Only one piece is allowed to snatch";
            }
        } else if (moveList.size() == 1) {
            move = moveIterator.next();
            bl = false;
            string = "Ending position is required for move starting at: " + move.toString();
        } else if (moveList.size() == 2) {
            move2 = moveIterator.next();
            move3 = moveIterator.next();
            if (!this.isValidIndex(move2.x, move2.y)) {
                bl = false;
                string = "Invalid from-index to move: " + move2.toString();
            } else if (!this.isValidIndex(move3.x, move3.y)) {
                bl = false;
                string = "Invalid to-index to move: " + move3.toString();
            }
            if (bl) {
                if (this.hasValidJumps()) {
                    if (this.isValidJump(move2, move3)) {
                        move2.type = 2;
                        move3.type = 2;
                    } else {
                        bl = false;
                        string = "Invalid jump starting at: " + move2.toString() + " ending at: " + move3.toString();
                    }
                } else {
                    boolean bl2 = this.IsSlidingToCenterPossible(move2);
                    if (this.isValidSlide(move2, move3, bl2)) {
                        move2.type = 1;
                        move3.type = 1;
                    } else {
                        bl = false;
                        string = "Invalid slide starting at: " + move2.toString() + " ending at: " + move3.toString();
                    }
                }
            }
        } else {
            move2 = moveIterator.next();
            if (!this.isValidIndex(move2.x, move2.y)) {
                bl = false;
                string = "Invalid from-index to jump: " + move2.toString();
            }
            if (bl) {
                while (moveIterator.hasNext()) {
                    move3 = moveIterator.next();
                    if (!this.isValidIndex(move3.x, move3.y)) {
                        bl = false;
                        string = "Invalid to-index to jump: " + move3.toString();
                        break;
                    }
                    if (!this.isValidJump(move2, move3)) {
                        bl = false;
                        string = "Invalid jump starting at: " + move2.toString() + " ending at: " + move3.toString();
                        break;
                    }
                    move2.type = 2;
                    move3.type = 2;
                    move2 = move3;
                }
            }
        }
        return string;
    }

    public void executeMoves(MoveList moveList) {
        MoveIterator moveIterator = moveList.getIterator();
        Move move = null;
        Move move2 = null;
        Move move3 = null;
        int n = this.mnSize * this.mnSize;
        if (this.getNumOfStonesOnBoard() == n) {
            if (moveList.size() == 1) {
                move = moveIterator.next();
                this.mbArrCellEmpty[move.x][move.y] = true;
            }
        } else if (moveList.size() == 2) {
            move2 = moveIterator.next();
            if (this.isValidJump(move2, move3 = moveIterator.next())) {
                this.jump(move2, move3);
            } else {
                this.slide(move2, move3);
            }
        } else {
            move2 = moveIterator.next();
            while (moveIterator.hasNext()) {
                move3 = moveIterator.next();
                this.jump(move2, move3);
                move2 = move3;
            }
        }
    }

    public void jump(Move move, Move move2) {
        int n = (move.x + move2.x) / 2;
        int n2 = (move.y + move2.y) / 2;
        this.mbArrCellEmpty[move.x][move.y] = true;
        this.mbArrCellEmpty[n][n2] = true;
        this.mbArrCellEmpty[move2.x][move2.y] = false;
    }

    public void slide(Move move, Move move2) {
        this.mbArrCellEmpty[move.x][move.y] = true;
        this.mbArrCellEmpty[move2.x][move2.y] = false;
    }

    public boolean hasValidJumps() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.mnSize; ++n) {
            for (n2 = 0; n2 < this.mnSize; ++n2) {
                if (!this.mbArrCellEmpty[n][n2]) {
                    for (n3 = 0; n3 < this.mnSize; ++n3) {
                        for (n4 = 0; n4 < this.mnSize; ++n4) {
                            if (!this.mbArrCellEmpty[n3][n4] || !this.isValidJump(new Move(n, n2), new Move(n3, n4))) continue;
                            bl = true;
                            break;
                        }
                        if (bl) break;
                    }
                }
                if (bl) break;
            }
            if (bl) break;
        }
        return bl;
    }

    public boolean findValidSlides(MoveList moveList, MoveList moveList2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        Move move = new Move(-1, -1);
        Move move2 = new Move(-1, -1);
        Move move3 = new Move(-1, -1);
        Move move4 = new Move(-1, -1);
        Move move5 = new Move(-1, -1);
        Move move6 = new Move(-1, -1);
        Move move7 = new Move(-1, -1);
        Move move8 = new Move(-1, -1);
        Move move9 = new Move(-1, -1);
        for (n = 0; n < this.mnSize; ++n) {
            for (n2 = 0; n2 < this.mnSize; ++n2) {
                if (this.mbArrCellEmpty[n][n2]) continue;
                move.set(n, n2);
                move2.set(n, n2 - 1);
                move3.set(n, n2 + 1);
                move4.set(n - 1, n2 - 1);
                move5.set(n - 1, n2);
                move6.set(n - 1, n2 + 1);
                move7.set(n + 1, n2 - 1);
                move8.set(n + 1, n2);
                move9.set(n + 1, n2 + 1);
                bl2 = this.IsSlidingToCenterPossible(move);
                if (this.isValidSlide(move, move2, bl2)) {
                    moveList.add(move.copy());
                    moveList2.add(move2.copy());
                }
                if (this.isValidSlide(move, move3, bl2)) {
                    moveList.add(move.copy());
                    moveList2.add(move3.copy());
                }
                if (this.isValidSlide(move, move4, bl2)) {
                    moveList.add(move.copy());
                    moveList2.add(move4.copy());
                }
                if (this.isValidSlide(move, move5, bl2)) {
                    moveList.add(move.copy());
                    moveList2.add(move5.copy());
                }
                if (this.isValidSlide(move, move6, bl2)) {
                    moveList.add(move.copy());
                    moveList2.add(move6.copy());
                }
                if (this.isValidSlide(move, move7, bl2)) {
                    moveList.add(move.copy());
                    moveList2.add(move7.copy());
                }
                if (this.isValidSlide(move, move8, bl2)) {
                    moveList.add(move.copy());
                    moveList2.add(move8.copy());
                }
                if (!this.isValidSlide(move, move9, bl2)) continue;
                moveList.add(move.copy());
                moveList2.add(move9.copy());
            }
        }
        if (moveList.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean IsSlidingToCenterPossible(Move move) {
        boolean bl = false;
        int n = move.x;
        int n2 = move.y;
        int n3 = 0;
        Move move2 = new Move(n, n2 - 1);
        Move move3 = new Move(n, n2 + 1);
        Move move4 = new Move(n - 1, n2 - 1);
        Move move5 = new Move(n - 1, n2);
        Move move6 = new Move(n - 1, n2 + 1);
        Move move7 = new Move(n + 1, n2 - 1);
        Move move8 = new Move(n + 1, n2);
        Move move9 = new Move(n + 1, n2 + 1);
        double d = this.distToCenter(move);
        if (this.isValidMoveTo(move2) && this.distToCenter(move2) < d) {
            ++n3;
        }
        if (this.isValidMoveTo(move3) && this.distToCenter(move3) < d) {
            ++n3;
        }
        if (this.isValidMoveTo(move4) && this.distToCenter(move4) < d) {
            ++n3;
        }
        if (this.isValidMoveTo(move5) && this.distToCenter(move5) < d) {
            ++n3;
        }
        if (this.isValidMoveTo(move6) && this.distToCenter(move6) < d) {
            ++n3;
        }
        if (this.isValidMoveTo(move7) && this.distToCenter(move7) < d) {
            ++n3;
        }
        if (this.isValidMoveTo(move8) && this.distToCenter(move8) < d) {
            ++n3;
        }
        if (this.isValidMoveTo(move9) && this.distToCenter(move9) < d) {
            ++n3;
        }
        if (n3 > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isValidJump(Move move, Move move2) {
        boolean bl = false;
        int n = Math.abs(move.x - move2.x);
        int n2 = Math.abs(move.y - move2.y);
        int n3 = (move.x + move2.x) / 2;
        int n4 = (move.y + move2.y) / 2;
        bl = n == 0 && n2 == 2 || n == 2 && n2 == 0 || n == 2 && n2 == 2;
        if (bl) {
            bl = !this.mbArrCellEmpty[move.x][move.y] && !this.mbArrCellEmpty[n3][n4] && this.mbArrCellEmpty[move2.x][move2.y];
        }
        return bl;
    }

    public boolean isValidSlide(Move move, Move move2, boolean bl) {
        boolean bl2 = false;
        int n = Math.abs(move.x - move2.x);
        int n2 = Math.abs(move.y - move2.y);
        bl2 = this.isValidMoveIndex(move) && this.isValidMoveIndex(move2);
        if (bl2) {
            bl2 = n == 0 && n2 == 1 || n == 1 && n2 == 0 || n == 1 && n2 == 1;
        }
        if (bl2) {
            bl2 = !this.mbArrCellEmpty[move.x][move.y] && this.mbArrCellEmpty[move2.x][move2.y] ? !this.isCenterPiece(move) : false;
        }
        if (bl2) {
            bl2 = this.distToCenter(move2) < this.distToCenter(move) ? true : !bl;
        }
        return bl2;
    }

    public double distToCenter(Move move) {
        double d;
        double d2 = 0.0;
        double d3 = d = 1.0 * (double)(this.mnSize - 1) / 2.0;
        d2 = Math.sqrt(Math.pow((double)move.x - d, 2.0) + Math.pow((double)move.y - d3, 2.0));
        return d2;
    }

    public boolean isCenterPiece(Move move) {
        boolean bl = false;
        if (this.mnSize % 2 == 1 && move.x == (this.mnSize - 1) / 2 && move.y == (this.mnSize - 1) / 2 && !this.mbArrCellEmpty[move.x][move.y]) {
            bl = true;
        }
        return bl;
    }
}

