import React from 'react';
import { Card, Row, Col, Container, Form, Button } from 'react-bootstrap';
import { Slider } from '@material-ui/core';

class Goals extends React.Component {
    constructor(props) {
        super(props);
        let goals = this.props.data
        let demographics = this.props.demographics

        this.state = {
            ...goals
        }
    }

    componentDidUpdate(prevProps, prevState) {
        if (prevState !== this.state) {
            this.props.onChange(this.state)
        }
    }

    computeNutrients(goal = this.state.diet) {
        if (this.props.demographics != null) {
            //Figure out the calories:

            let multiplier = 1;
            let calories = 0;
            let fat = 0;
            let carbohydrates = 0;
            let protein = 0;
            let kg = this.props.demographics.weight //Math.round(this.props.demographics.weight / 2.20462);
            let cm = this.props.demographics.height // Math.round(this.props.demographics.height / 0.393701);
            if (this.props.demographics.unit == "imperial") {
                kg = Math.round(this.props.demographics.weight / 2.20462);
                cm = Math.round(this.props.demographics.height / 0.393701);
            }
            if (this.props.demographics.activity == "sedentary") {
                multiplier = 4;
            }
            else if (this.props.demographics.activity == "moderate") {
                multiplier = 8;
            }
            else if (this.props.demographics.activity == "active") {
                multiplier = 12;
            }
            console.log(this.props.demographics.activity, multiplier)
            if (this.props.demographics.sex == "Male") {
                calories = Math.round(
                    (multiplier * kg) +
                    (5 + (10 * kg) +
                        (6.25 * cm) -
                        (5 * this.props.demographics.age)));
            }
            else {
                calories = Math.round(
                    (multiplier * kg) +
                    (-161 + (10 * kg) +
                        (6.25 * cm) -
                        (5 * this.props.demographics.age)));
            }
            console.log("Target cals", calories, cm, kg)
            if (goal == "negative") {
                calories = [(calories + Math.round(-4 * kg)), calories]
            }
            else {
                calories = [calories, (calories + Math.round(4 * kg))]
            }


            //Figure out the fat
            // carbs and protein = 4cal/g, fat = 9cals/g
            //The U.S. Dietary Guidelines say 45 to 65 percent of your calories should come from carbohydrates, while 20 to 35 percent should come from total fat. You should also get 10 to 35 percent of your calories from protein.


            fat = [Math.round((calories[0] * .20) / 9), Math.round((calories[1] * .30) / 9)]

            //Figure out the carbs
            carbohydrates = [Math.round((calories[0] * .45) / 4), Math.round((calories[1] * .65) / 4)]

            //Figure out the protein
            protein = [Math.round((calories[0] * .10) / 4), Math.round((calories[1] * .35) / 4)]

            ///https://pubmed.ncbi.nlm.nih.gov/16004827/#:~:text=The%20IOM%20calculated%20an%20acceptable,limit%20saturated%20and%20trans%20fats).
            console.log("computed ranges", { calories, carbohydrates, fat, protein })
            this.setState(prevState => ({ ...prevState, calories, carbohydrates, fat, protein }))
        }

    }

    render() {
        return <>
            <div style={{ paddingTop: 20 }}>
                <Card>
                    <Card.Body>
                        <Container style={{ fontSize: "larger" }}>
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Daily Cook Time (min)</b><br/><i style={{fontSize: "smaller"}}>Plans generated may be longer.</i></Col>
                                <Col xs={8} md={10}>
                                    <Slider
                                        min={0} max={21600}
                                        value={[this.state.time[0], this.state.time[1]]}
                                        onChange={(e, value) => this.setState(prevState => ({ ...prevState, time: value }))}
                                        scale={(x) => parseInt(x / 60)}
                                        valueLabelDisplay={true}
                                        valueLabelDisplay="auto"
                                        aria-labelledby="range-slider"

                                    />
                                </Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Goal</b></Col>
                                <Col xs={6} md={10}>
                                    <Form>
                                        <Form.Control onChange={(event) => {
                                            this.setState(prevState => ({ ...prevState, diet: event.target.value }), this.computeNutrients(event.target.value))

                                        }} defaultValue={this.state.diet} as="select" custom>
                                            <option value="positive">Increase calories</option>
                                            <option value="negative">Decrease calories</option>
                                        </Form.Control>
                                    </Form>

                                </Col>
                            </Row>
                            <Row>
                                <Col align="center" style={{ paddingTop: 20 }} >
                                    <Button variant="primary" onClick={() => { this.computeNutrients() }}>Calculate Nutritional Ranges</Button>

                                </Col>
                            </Row>
                        </Container>
                    </Card.Body>
                </Card></div>
            <div style={{ paddingTop: 20 }}>
                <h3>Nutritional Ranges</h3>
                <p><i>You can edit by moving the slider endpoints. Please remember to hit save when you're done.</i></p>
                <Card>
                    <Card.Body>
                        <Container style={{ fontSize: "larger" }}>
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Calories</b></Col>
                                <Col xs={8} md={10}>
                                    <Slider
                                        min={0} max={10000}
                                        value={[this.state.calories[0], this.state.calories[1]]}
                                        onChange={(e, value) => this.setState(prevState => ({ ...prevState, calories: value }))}
                                        scale={(x) => parseInt(x)}
                                        valueLabelDisplay={true}
                                        valueLabelDisplay="auto"
                                        aria-labelledby="range-slider"

                                    />
                                </Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Carbohydrates (g)</b></Col>
                                <Col xs={8} md={10}>
                                    <Slider
                                        min={0} max={1000}
                                        value={[this.state.carbohydrates[0], this.state.carbohydrates[1]]}
                                        onChange={(e, value) => this.setState(prevState => ({ ...prevState, carbohydrates: value }))}
                                        scale={(x) => parseInt(x)}
                                        valueLabelDisplay={true}
                                        valueLabelDisplay="auto"
                                        aria-labelledby="range-slider"

                                    />
                                </Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Fat (g)</b></Col>
                                <Col xs={8} md={10}>
                                    <Slider
                                        min={0} max={1000}
                                        value={[this.state.fat[0], this.state.fat[1]]}
                                        onChange={(e, value) => this.setState(prevState => ({ ...prevState, fat: value }))}
                                        scale={(x) => parseInt(x)}
                                        valueLabelDisplay={true}
                                        valueLabelDisplay="auto"
                                        aria-labelledby="range-slider"

                                    />
                                </Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Protein (g)</b></Col>
                                <Col xs={8} md={10}>
                                    <Slider
                                        min={0} max={1000}
                                        value={[this.state.protein[0], this.state.protein[1]]}
                                        onChange={(e, value) => this.setState(prevState => ({ ...prevState, protein: value }))}
                                        scale={(x) => parseInt(x)}
                                        valueLabelDisplay={true}
                                        valueLabelDisplay="auto"
                                        aria-labelledby="range-slider"

                                    />

                                </Col>
                            </Row>
                            <Row>

                            </Row>


                        </Container>
                    </Card.Body>
                </Card>
            </div></>

    }
}

export default Goals;