import React from 'react';
import ReactDOM from 'react-dom';
//import HTML5Backend from 'react-dnd-html5-backend';
import { WithContext as ReactTags } from 'react-tag-input';
import { connect } from 'react-redux';
import { Card } from 'react-bootstrap';


const KeyCodes = {
    comma: 188,
    enter: 13,
};

const delimiters = [KeyCodes.comma, KeyCodes.enter];



class Sharing extends React.Component {
    componentDidUpdate(prevProps, prevState) {
        if (prevState !== this.state) {
            this.props.onChange(this.state)
        }
    }
    constructor(props) {
        super(props);
        console.log("Allowed:", this.props.data.allowed)
        this.state = {
            //Assign to empty object in case it hasn't been created yet
            shareWith: Object.keys(Object.assign({}, this.props.data?.allowed))?.map((item) => {
                return { id: item.toString(), text: item };
            }) || [],

            cookFor: Object.keys(Object.assign({}, this.props.data?.cookFor))?.map((item) => {
                return { id: item.toString(), text: item };
            }) || [],

        };
        this.handleShareDelete = this.handleShareDelete.bind(this);
        this.handleShareAddition = this.handleShareAddition.bind(this);
        this.handleShareDrag = this.handleShareDrag.bind(this);

        this.handleCookDelete = this.handleCookDelete.bind(this);
        this.handleCookAddition = this.handleCookAddition.bind(this);
        this.handleCookDrag = this.handleCookDrag.bind(this);
    }

    handleShareDelete(i) {
        const { shareWith } = this.state;
        this.setState({
            shareWith: shareWith.filter((tag, index) => index !== i),
        });
    }
    handleCookDelete(i) {
        const { cookFor } = this.state;
        this.setState({
            cookFor: cookFor.filter((tag, index) => index !== i),
        });
    }

    handleShareAddition(tag) {
        this.setState(state => ({ shareWith: [...state.shareWith, tag] }));
    }

    handleCookAddition(tag) {
        this.setState(state => ({ cookFor: [...state.cookFor, tag] }));
    }

    handleShareDrag(tag, currPos, newPos) {
        const shareWith = [...this.state.shareWith];
        const newshareWith = shareWith.slice();

        newshareWith.splice(currPos, 1);
        newshareWith.splice(newPos, 0, tag);

        // re-render
        this.setState({ shareWith: newshareWith });
    }

    handleCookDrag(tag, currPos, newPos) {
        const cookFor = [...this.state.cookFor];
        const newcookFor = cookFor.slice();

        newcookFor.splice(currPos, 1);
        newcookFor.splice(newPos, 0, tag);

        // re-render
        this.setState({ cookFor: newcookFor });
    }
    render() {
        const { shareWith, cookFor, suggestions } = this.state;
        return (
            <div>
                <h2>Cooking for a group?</h2>
                
                <ol>
                    <li>Have each member create an account and add your email to their "Share with" section. </li>
                    <li>Enter each member's email in your "Cook for" section (you must have at least two people).</li>
                    <li>Save your preferences, head over to your Plan, activate group mode, then regenerate.</li>
                </ol>
                <h3 style={{ paddingTop: "20px" }}> Share with:</h3>
                <Card style={{ padding: 20}}>
                    <ReactTags tags={shareWith}
                        handleDelete={this.handleShareDelete}
                        handleAddition={this.handleShareAddition}
                        handleDrag={this.handleShareDrag}
                        handleTagClick={this.handleShareClick}
                        delimiters={delimiters} />
                </Card>

                <h3 style={{ paddingTop: "20px" }}>Cook for:</h3>
                <Card style={{ padding: 20 , marginBottom: 40 }}>
                    <ReactTags tags={cookFor}
                        handleDelete={this.handleCookDelete}
                        handleAddition={this.handleCookAddition}
                        handleDrag={this.handleCookDrag}
                        handleTagClick={this.handleCookClick}
                        delimiters={delimiters} />
                </Card>
            </div>
        )
    }
}


export default (Sharing);