import React from 'react';
import { connect } from 'react-redux';
import {
    getUserData, updateAuth, updateUserData

} from '../../helpers/DataActions.js';
import { withSnackbar } from 'notistack';
import { Container, Button, Spinner } from 'react-bootstrap';
import Profile from './Profile'
import Demographics from './Demographics'
import Goals from './Goals'
import Restrictions from './Restrictions';
import Recipes from './Recipes';
import Sharing from './Sharing'
import { Redirect } from 'react-router';
import { withRouter } from 'react-router-dom';
import data from "../plan/foods.json";

class Preferences extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            //Keep track of the demographics here because if the user changes them, we want to be able to modify goals
            unregistered: false,
            ...this.props.userData,
        }
    }
    componentDidMount() {
        window.scrollTo(0, 0);
        if (this.props.isAuthed) {
            if (this.props.userData?.unregistered) {
                this.props.enqueueSnackbar("Fill out your information to get started. Please don't forget to save.", { persist: true })
            }
        }
    }

    handleDemographics = (status) => {
        let privateData = { ...this.state.private }
        privateData.demographics = status
        this.setState(prevState => ({ ...prevState, "private": privateData }));

    }
    handleGoals = (status) => {
        let sharedData = { ...this.state.shared }
        sharedData.goals = status
        this.setState(prevState => ({ ...prevState, "shared": sharedData }));
    }
    handleRestrictions = (status) => {
        let sharedData = { ...this.state.shared }
        sharedData.allergens = status.allergenTags.map(elem => elem.text)
        sharedData.tastes = status.likedTags.map(elem => elem.text)
        this.setState(prevState => ({ ...prevState, "shared": sharedData }));
    }
    handleRecipes = (status) => {
        let sharedData = { ...this.state.shared }
        sharedData.blocked = status.blockedTags.map(elem => elem.id)
        sharedData.liked = status.likedTags.map(elem => elem.id)
        this.setState(prevState => ({ ...prevState, "shared": sharedData }));
    }
    handleSharing = (status) => {
        let sharedData = { ...this.state.shared }
        sharedData.cookFor = status.cookFor.reduce((acc, curr) => (acc[curr.id] = true, acc), {});
        sharedData.allowed = status.shareWith.reduce((acc, curr) => (acc[curr.id] = true, acc), {});
        this.setState(prevState => ({ ...prevState, "shared": sharedData }));
    }
    saveChanges = () => {
        const updated = Object.assign({ ...this.props.userData }, this.state)

        console.log("Saved state,", updated);
        this.props.updateUserData(this.props.token, updated, this.showToast);

        //this.props.history.push('/plan')
    }
    saveGenerate = () => {
        const updated = Object.assign({ ...this.props.userData }, this.state)

        console.log("Saved state,", updated);
        this.props.updateUserData(this.props.token, updated, this.showToast);

        this.props.history.push('/plan/generate')
    }
    showToast = (msg, variant) => {
        this.props.enqueueSnackbar(msg, { variant });
    }
    render() {
        if (this.props.isAuthed && (this.props.userData == false || this.props.userData == null)) {
            return <div align="center" style={{ padding: "7vh" }}>
                <h2>Fetching your data...</h2>
                <div style={{ margin: "5vh" }}>
                    <Spinner animation="grow" />
                </div>
                <p><i>This shouldn't take long.</i></p>
            </div>
        }
        else if ((this.props.isAuthed) && (this.props.userData != null) && ("shared" in this.props.userData) && ("private" in this.props.userData)) {
            return <div>
                <Container style={{ paddingTop: 40 }}>

                    <div >
                        <h1>My Info: <div style={{ float: 'right' }}>
                            <Button onClick={this.saveChanges} variant="success">Save</Button> <Button onClick={this.saveGenerate} variant="primary">Save and generate</Button>

                        </div>
                        </h1>
                    </div>
                    <Demographics data={this.props.userData?.private} onChange={this.handleDemographics} />
                    <Goals demographics={this.state.private?.demographics} data={this.props.userData?.shared.goals} onChange={this.handleGoals} />
                    <Restrictions data={this.props.userData?.shared} onChange={this.handleRestrictions} />
                    <Recipes data={this.props.userData?.shared} onChange={this.handleRecipes} />
                    <Sharing data={this.props.userData?.shared} onChange={this.handleSharing} />
                    <div style={{ paddingBottom: 40 }} align="center">
                        <Button onClick={this.saveChanges} variant="success">Save</Button>
                        <Button onClick={this.saveGenerate} variant="primary" style={{ marginLeft: 20 }}>Save and generate</Button>
                    </div>
                </Container>

            </div>
        }
        else {
            return <div>
                <Redirect to="/"></Redirect>
            </div>
        }

    }
}
const mapStateToProps = state => ({
    token: state.reducer.token,
    userData: state.reducer.userData,
    isAuthed: state.reducer.isAuthed,
});

export default (
    connect(
        mapStateToProps,
        { updateUserData }
    )(withRouter(withSnackbar(Preferences))));

