import React from 'react';
import { connect } from 'react-redux';
import { Card, Row, Col, Container, Form, FormControl, FormCheck, ToggleButtonGroup, ToggleButton } from 'react-bootstrap';

class Demographics extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            ...this.props.data?.demographics
        }
    }
    componentDidUpdate(prevProps, prevState) {
        if (prevState !== this.state) {
            this.props.onChange(this.state)
        }
    }
    lbOrkg() {
        if (this.state.unit == "metric") {
            return "Weight (kg)"
        }
        else {
            return "Weight (lb)"
        }
    }
    inOrcm() {
        if (this.state.unit == "metric") {
            return "Height (cm)"
        }
        else {
            return "Height (in)"
        }
    }
    render() {
        //TODO: Replace onChange functions    this.setState({form: {...this.state.form, [fieldName]: fleldVal}})


        return <>
            <div style={{ paddingTop: 20 }}>
                <h3>Profile</h3>
                <Card>
                    <Card.Body>
                        <Container style={{ fontSize: "larger" }}>
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Name</b></Col>
                                <Col xs={8} md={10}> {this.state.firstName} {this.state.lastName}</Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Email</b></Col>
                                <Col xs={8} md={10}>{this.state.emailAddress}</Col>
                            </Row>
                        </Container>
                    </Card.Body>
                </Card>
            </div>
            <div style={{ paddingTop: 20 }}>
                <h3>Demographics <div style={{ float: "right" }}>
                    <ToggleButtonGroup onChange={(value) => { this.setState(prevState => ({ ...prevState, unit: value })) }} type="radio" name="options" defaultValue={this.state.unit}>
                        <ToggleButton size="sm" value={"imperial"}>Imperial</ToggleButton>
                        <ToggleButton size="sm" value={"metric"}>Metric</ToggleButton>
                    </ToggleButtonGroup>
                </div></h3>
                <Card>
                    <Card.Body>
                        <Container style={{ fontSize: "larger" }}>
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Age</b></Col>
                                <Col xs={8} md={10}>
                                    <Form.Control type="number" onChange={(event) => { this.setState(prevState => ({ ...prevState, age: parseInt(event.target.value) })) }} defaultValue={this.state.age} />
                                </Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Sex</b></Col>
                                <Col xs={8} md={10}>
                                    <Form>
                                        <Form.Control onChange={(event) => { this.setState(prevState => ({ ...prevState, sex: event.target.value })) }} defaultValue={this.state.sex} as="select" custom>
                                            <option>Male</option>
                                            <option>Female</option>
                                        </Form.Control>
                                    </Form>

                                </Col>
                            </Row>

                            <br />

                            <Row>
                                <Col align="right" xs={4} md={2}><b>{this.lbOrkg()}</b></Col>
                                <Col xs={8} md={10}> <Form.Control onChange={(event) => { this.setState(prevState => ({ ...prevState, weight: parseInt(event.target.value) })) }} type="number" defaultValue={this.state.weight} /></Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>{this.inOrcm()}</b></Col>
                                <Col xs={8} md={10}><Form.Control onChange={(event) => { this.setState(prevState => ({ ...prevState, height: parseInt(event.target.value) })) }} type="number" defaultValue={this.state.height} /></Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Lifestyle</b></Col>
                                <Col xs={8} md={10}>
                                    <Form>
                                        <Form.Control onChange={(event) => { this.setState(prevState => ({ ...prevState, activity: event.target.value })) }} defaultValue={this.state.activity} as="select" custom>
                                            <option value="" disabled>Please select</option>
                                            <option value="sedentary">Sedentary (no special exercise)</option>
                                            <option value="moderate">Moderately Active (walk ~1-2 miles per day)</option>
                                            <option value="active">Active (walk > 3 miles per day)</option>
                                        </Form.Control>
                                    </Form>

                                </Col>
                            </Row>
                            <br />
                            <Row>
                                <Col align="right" xs={4} md={2}><b>Minimum Meals/Day</b></Col>
                                <Col xs={8} md={10}>
                                    <Form>
                                        <Form.Control onChange={(event) => { this.setState(prevState => ({ ...prevState, meals: parseInt(event.target.value) })) }} defaultValue={this.state.meals} as="select" custom>
                                            <option value={2}>2</option>
                                            <option value={3}>3</option>
                                        </Form.Control>
                                    </Form>

                                </Col>
                            </Row>
                        </Container>
                    </Card.Body>
                </Card>
            </div >
        </>

    }
}



export default (
    Demographics);


/*                        <!-- <br />
                    <Row>
                        <Col align="right" xs={4} md={2}><b>Unit</b></Col>
                        <Col xs={8} md={10}>

                            <ToggleButtonGroup onChange={(value) => { this.setState(prevState => ({ ...prevState, unit: value })) }} type="radio" name="options" defaultValue={this.state.unit}>
                                <ToggleButton value={"imperial"}>Imperial</ToggleButton>
                                <ToggleButton value={"metric"}>Metric</ToggleButton>
                            </ToggleButtonGroup>

                        </Col>
                    </Row>*/