import React from "react";
import { connect } from "react-redux";
import {
    getUserData,
    addSolution,
    updateUserData,
} from "../../helpers/DataActions.js";
import { withSnackbar } from "notistack";
import { withRouter } from "react-router-dom";
import { Container, Button, Col, Row, Spinner } from "react-bootstrap";
import { FormGroup, FormControlLabel, Switch } from "@material-ui/core"
import { Redirect, useHistory } from "react-router";
import GroupDay from "./GroupDay.js";
import data from "./foods.json";
import worker from "workerize-loader!./worker"; // eslint-disable-line import/no-webpack-loader-syntax
import ontology from "./onology.json";
import { ThreeSixty } from "@material-ui/icons";

class GroupPlan extends React.Component {
    opts;
    solutions;
    days = 7;
    constructor(props) {
        super(props);
        this.terminate = this.terminate.bind(this);
        if (this.props.isAuthed) {
            this.state = {
                finished: false,
                clicked: false,
                workforce: [],
                solutions: [],
                diet: this.props.userData.private.diet || [],
            };
            this.opts = {
                calories: {
                    min: this.props.userData.shared.goals.calories[0],
                    max: this.props.userData.shared.goals.calories[1],
                }, //"priority": 0
                protein: {
                    min: this.props.userData.shared.goals.protein[0],
                    max: this.props.userData.shared.goals.protein[1],
                }, //, "priority": 1
                carbohydrates: {
                    min: this.props.userData.shared.goals.carbohydrates[0],
                    max: this.props.userData.shared.goals.carbohydrates[1],
                }, //, "priority": 2
                fat: {
                    min: this.props.userData.shared.goals.fat[0],
                    max: this.props.userData.shared.goals.fat[1],
                }, //, "priority": 1
                seconds: {
                    min: this.props.userData.shared.goals.time[0],
                    max: this.props.userData.shared.goals.time[1],
                },
            };
        }
    }

    displayDiet() {
        console.log("Rendering with displayDiet", this.state.diet)
        this.setState(
            {
                solutions: []
            }
        );
        if (window.innerWidth < 1024) {
            this.state.diet?.forEach((entry, index) => {
                this.setState((prevState) => ({
                    solutions: prevState.solutions.concat(
                        <Col xs={12}>
                            <GroupDay
                                day={index + 1}
                                meals={entry}
                            ></GroupDay>
                        </Col>
                    ),
                }));
            });
        }
        else {
            this.state.diet?.forEach((entry, index) => {
                this.setState((prevState) => ({
                    solutions: prevState.solutions.concat(
                        <Col>
                            <GroupDay
                                day={index + 1}
                                meals={entry}
                            ></GroupDay>
                        </Col>
                    ),
                }));
            });
        }

    }
    componentWillMount() {
        window.scrollTo(0, 0);
        if (this.state.diet != null) {
            this.displayDiet()
        }
        this.unlisten = this.props.history.listen((location, action) => {
            console.log("route change", location, action, this.props.action);
            const term = location.pathname.split("/").pop();
            if (term == "failed") {
                this.displayDiet();
                alert("We were not able to generate any plans that satisfied your constraints. Please try widening them.")
                this.props.history.push('/plan')
            }
        });

    }
    componentWillUnmount() {
        this.unlisten();
    }


    componentDidMount() {
        if (this.props.action == "generate") {
            this.props.history.push('/plan');
            let self = this;
            setTimeout(function () {
                self.generateIndividualMeals();
            }, 500);

        }
    }

    componentDidUpdate(prevProps, prevState) {
        if (prevState.finished !== this.state.finished) {
            console.log("STATE CHANGE", prevState, this.state)
          this.saveChanges(this.state.diet)
        }
      }
      
    restrictUniverse(allergenList) {
        return new Promise((resolve, reject) => {
            //Take total dataset and filter out allergens. Return a nested array split into indices for worker use.
            let groupList = [];
            for (const item of allergenList) {
                if (item.indexOf("(all)") != -1) {
                    let category = item.replace(" (all)", "");

                    let ingredients = [...ontology[category]];

                    groupList = groupList.concat(ingredients);
                }
            }
            let allergens = [...allergenList, ...groupList];
            console.log("Full ingredient list:", allergens);
            let recipes = Object.keys(data).filter((item) => {
                //Do this globally one time on the dataset
                //allergens = allergens.concat()
                if (
                    allergens?.some((element) =>
                        data[item]["ingredients"].toLowerCase().includes(element)
                    ) ||
                    allergens?.some((element) =>
                        data[item]["name"].toLowerCase().includes(element)
                    )
                ) {
                    console.log(data[item]["name"] + " is not allowed, excluding.");
                    return false;
                }
                return true;
            });
            resolve(
                recipes.reduce((resultArray, item, index) => {
                    const chunkIndex = Math.floor(
                        index / Math.floor(recipes.length / this.days)
                    );
                    if (!resultArray[chunkIndex]) {
                        resultArray[chunkIndex] = []; // start a new chunk
                    }
                    resultArray[chunkIndex].push(item);
                    return resultArray;
                }, [])
            );
        });
    }

    createWorkers(amt) {
        let workers = new Array(amt);
        for (var i = 0; i < amt; i++) {
            workers[i] = worker();
        }
        return workers;
    }

    intersection() {
        var result = [];
        var lists;

        if (arguments.length === 1) {
            lists = arguments[0];
        } else {
            lists = arguments;
        }

        for (var i = 0; i < lists.length; i++) {
            var currentList = lists[i];
            for (var y = 0; y < currentList.length; y++) {
                var currentValue = currentList[y];
                if (result.indexOf(currentValue) === -1) {
                    if (lists.filter(function (obj) { return obj.indexOf(currentValue) == -1 }).length == 0) {
                        result.push(currentValue);
                    }
                }
            }
        }
        return result;
    }


    async generateGroupMeals() {
        this.setState((prevState) => ({
            /* solutions: [],*/
            clicked: true,
        }));

        //fetch the data 
        let profiles = []
        let users = Object.keys(this.props.userData.shared.cookFor) || []
        try {
            profiles = await Promise.all(users.map(async email => {
                const headers = {
                    'Authorization': `Bearer ${this.props.token}`
                };
                let url = "https://us-central1-dietlp.cloudfunctions.net/app/fetch?user=" + email //endpoint here
                const resp = await fetch(url, { headers });
                const respJson = await resp.json();
                return respJson["success"]
            }));
        }
        catch (e) {
            console.error(e)
            alert(e)
            if (profiles.length > 0) {
                console.log("We can still try our best")
            }
            else {
                return e
            }
        }

        let allergens = [...new Set(profiles.map((item) => item.allergens).flat())]
        let tastes = [...new Set(this.intersection(profiles.map((item) => item.tastes)))]
        console.log(profiles, allergens, tastes)

        //Calculate ratios 

        let ratioedProfiles = []
        for (let i = 0; i < profiles.length; i++) {
            let modify = Object.assign({}, profiles[i]);
            modify["ratios"] = {}

            modify.ratios["carbsFat"] = (modify["goals"].carbohydrates[1] / modify["goals"].fat[1])
            modify.ratios["carbsProtein"] = (modify["goals"].carbohydrates[1] / modify["goals"].protein[1])
            modify.ratios["fatProtein"] = (modify["goals"].fat[1] / modify["goals"].protein[1])

            ratioedProfiles.push(modify)
        }
        //Ratios: [[(highest), (user)], [(lowest), (user)], (sum)]
        console.log("RatioedProfiles", ratioedProfiles)
        let initial = ratioedProfiles[0]
        let carbsFatSum = [[initial.ratios.carbsFat, initial.user], [initial.ratios.carbsFat, initial.user], initial.ratios.carbsFat]
        let carbsProteinSum = [[initial.ratios.carbsProtein, initial.user], [initial.ratios.carbsProtein, initial.user], initial.ratios.carbsProtein]
        let fatProteinSum = [[initial.ratios.fatProtein, initial.user], [initial.ratios.fatProtein, initial.user], initial.ratios.fatProtein]

        for (let i = 1; i < ratioedProfiles.length; i++) {
            let profile = Object.assign({}, ratioedProfiles[i]);
            carbsFatSum[2] += profile.ratios["carbsFat"]
            if (profile.ratios["carbsFat"] < carbsFatSum[0][0]) {
                carbsFatSum[0][0] = profile.ratios["carbsFat"]
                carbsFatSum[0][1] = profile.user
            }
            else if (profile.ratios["carbsFat"] > carbsFatSum[1][0]) {
                //It is higher than the prev high: set new
                carbsFatSum[1][0] = profile.ratios["carbsFat"]
                carbsFatSum[1][1] = profile.user
            }

            carbsProteinSum[2] += profile.ratios["carbsProtein"]
            if (profile.ratios["carbsProtein"] < carbsProteinSum[0][0]) {
                //It is lower than the prev low: set new
                carbsProteinSum[0][0] = profile.ratios["carbsProtein"]
                carbsProteinSum[0][1] = profile.user
            }
            else if (profile.ratios["carbsProtein"] > carbsProteinSum[1][0]) {
                //It is higher than the prev high: set new
                carbsProteinSum[1][0] = profile.ratios["carbsProtein"]
                carbsProteinSum[1][1] = profile.user
            }

            fatProteinSum[2] += profile.ratios["fatProtein"]
            if (profile.ratios["fatProtein"] < fatProteinSum[0][0]) {
                //It is lower than the prev low: set new
                fatProteinSum[0][0] = profile.ratios["fatProtein"]
                fatProteinSum[0][1] = profile.user
            }
            else if (profile.ratios["fatProtein"] > fatProteinSum[1][0]) {
                //It is higher than the prev high: set new
                fatProteinSum[1][0] = profile.ratios["fatProtein"]
                fatProteinSum[1][1] = profile.user
            }

        }
        carbsFatSum[2] = carbsFatSum[2] / ratioedProfiles.length
        carbsProteinSum[2] = carbsProteinSum[2] / ratioedProfiles.length
        fatProteinSum[2] = fatProteinSum[2] / ratioedProfiles.length

        console.log("carbsFat:", carbsFatSum)
        console.log("carbsProtein:", carbsProteinSum)
        console.log("fatProteinSum:", fatProteinSum)
        //Calculate 2 outliers max 
        let outliers = new Set()
        if (outliers.size < 2 && ((Math.abs(carbsProteinSum[1][0] - carbsProteinSum[2]) / carbsProteinSum[2]) >= .5)) {
            outliers.add(carbsProteinSum[1][1])
        }
        else if (outliers.size < 2 && ((Math.abs(carbsProteinSum[0][0] - carbsProteinSum[2]) / carbsProteinSum[2]) >= .5)) {
            outliers.add(carbsProteinSum[0][1])
        }
        else if (outliers.size < 2 && ((Math.abs(fatProteinSum[1][0] - fatProteinSum[2]) / fatProteinSum[2]) >= .5)) {
            outliers.add(fatProteinSum[1][1])
        }
        else if (outliers.size < 2 && ((Math.abs(fatProteinSum[0][0] - fatProteinSum[2]) / fatProteinSum[2]) >= .5)) {
            outliers.add(fatProteinSum[0][1])
        }

        else if (outliers.size < 2 && ((Math.abs(carbsFatSum[1][0] - carbsFatSum[2]) / carbsFatSum[2]) >= .5)) {
            outliers.add(carbsFatSum[1][1])
        }
        else if (outliers.size < 2 && ((Math.abs(carbsFatSum[0][0] - carbsFatSum[2]) / carbsFatSum[2]) >= .5)) {
            outliers.add(carbsFatSum[0][1])
        }
        else if (outliers.size < 2) {
            //no outliers: we still need to select 2 so lets pick randomly
            let selected = ratioedProfiles.sort(() => 0.5 - Math.random()).slice(0, 2).map((element) => element.user)
            console.log(selected)
            outliers = new Set(selected)
        }


        outliers = [...outliers].map((element) => {
            return profiles.find((profile) => profile.user == element)
        })
        console.log("Outliers:", outliers)

        //We want to take the union of allergens and intersection of liked 
        //First restrict global set of recipes.
        let solutionSet;
        let workforce = this.createWorkers(this.days);
        this.setState((prevState) => ({
            workforce,
        }));
        let time = {
            min: this.props.userData.shared.goals.time[0],
            max: this.props.userData.shared.goals.time[1],
        }

        solutionSet = this.restrictUniverse(allergens).then((universe) => {
            let dayCount = 0;

            return Promise.all(workforce.map((instance, index) => {
                return new Promise((resolve, reject) => {
                    console.log(index, universe)
                    console.log("instance with", universe[index]);
                    instance
                        .calculateGroup(
                            universe[index],
                            outliers,
                            time,
                            index
                        ).then((solution) => resolve(solution))
                });
            }, this)).then((solutionSet) => {
                console.log("\n\n\n\nDone with part 1: ", solutionSet)

                return solutionSet


            }).then((restrictedUniverse) => {
                return Promise.all(workforce.map((instance, index) => {
                    return new Promise(async (resolve, reject) => {
                        console.log("instance with", restrictedUniverse[index]);

                        const promises = profiles.map((profile) => {
                            return instance
                                .calculatePortions(
                                    restrictedUniverse[index],
                                    { ...profile, time: [time.min, time.max] },
                                    index
                                )
                        })

                        const solutions = await Promise.all(promises)


                        let day = solutions.filter((item) => item != null).reduce((obj, item) => {
                            console.log("ITEM:", item)
                            return Object.assign(obj, item);
                        }, {})

                        if (Object.keys(day).length == profiles.length) {
                            resolve(day)
                        }
                        else {
                            resolve(null)
                        }
                    });
                }, this)).then((finalSet) => {
                    finalSet = finalSet.filter((item) => item != null)
                    console.log("Finally:", finalSet);
                    return finalSet;
                })
            })
        }).then((solutions) => {
            //render them 
            console.log(solutions)
            this.setState((prevState) => ({
                solutions: solutions.map((element, index) => {
                    return <Col>
                        <GroupDay
                            day={index + 1}
                            meals={element}
                        ></GroupDay>
                    </Col>
                }),
                diet: solutions,
                finished: true,
                workforce: [],
            }));
            //
        })




        /*

        */


    }


    showToast = (msg, variant) => {
        this.props.enqueueSnackbar(msg, { variant });
    };

    saveChanges = (set) => {
        console.log(this.state);
        let privateData = { ...this.props.userData.private }
        privateData.diet = set
        const updated = Object.assign({ ...this.props.userData }, { "private": privateData });

        console.log("Saved state below:");
        console.log(updated);
        this.props.updateUserData(this.props.token, updated, this.showToast);
    };
    terminate() {
        console.log("killing process")
        this.state.workforce.map((instance, index) => {
            instance.terminate();
        });
        //this.forceUpdate();
        this.setState(
            (prevState) => ({
                clicked: false,
                workforce: [],
                diet: this.props.userData.diet || [],
            }),
            this.props.history.push("/plan/failed")
        );
    }

    render() {
        if (this.props.isAuthed) {
            if (this.props.userData.unregistered) {
                return <Redirect to="/settings"></Redirect>;
            }
            if (!this.state.clicked || this.state.finished) {
                return (
                    <div>
                                                
                        <Button variant="primary" size="sm" style={{float: "right", margin: 40}}
                                onClick={() => {
                                    window.print()
                                }}
                            >
                                Print
                            </Button>
                        <Container align="center" style={{ paddingTop: 40 }}>
                            <FormGroup row>
                                <FormControlLabel
                                    control={<Switch checked={true} onChange={() => { this.props.history.push("/plan/") }} name="groupToggle" />}
                                    label="Group Mode"
                                />
                            </FormGroup>
                            <h3>My Week's Plan</h3>
                            <br></br>
                            <p>
                                <b>Calories:</b> [{this.props.userData.shared?.goals.calories[0]},{" "}
                                {this.props.userData.shared?.goals.calories[1]}], &nbsp;
                                <b>Fat:</b> [{this.props.userData.shared.goals.fat[0]},{" "}
                                {this.props.userData.shared?.goals.fat[1]}], &nbsp;
                                <b>Carbohydrates:</b> [
                                {this.props.userData.shared?.goals.carbohydrates[0]},{" "}
                                {this.props.userData.shared?.goals.carbohydrates[1]}], &nbsp;
                                <b>Protein:</b> [{this.props.userData.shared?.goals.protein[0]},{" "}
                                {this.props.userData.shared?.goals.protein[1]}],&nbsp;
                                <b>Time:</b> [{parseInt(this.props.userData.shared?.goals.time[0] / 60)}
                                , {parseInt(this.props.userData.shared?.goals.time[1] / 60)}]
                            </p>
                            <br></br>
                            <Button
                                onClick={() => {
                                    this.generateGroupMeals();
                                }}
                            >
                                Generate a new group plan
                            </Button>
                        </Container>
                        <div style={{ paddingTop: 30 }}>
                            <Container fluid>
                                <Row> {this.state.solutions} </Row>
                            </Container>
                        </div>
                    </div>
                );
            } else {
                return (
                    <div>
                        
                        <Container style={{ paddingTop: 40 }}>
                            <FormGroup row>
                                <FormControlLabel
                                    control={<Switch checked={true} onChange={() => { this.props.history.push("/plan/") }} name="groupToggle" />}
                                    label="Group Mode"
                                />
                            </FormGroup>
                            <br></br>
                            <div align="center">
                                <h3>My Week's Plan</h3>
                                <br></br>
                                <p>
                                    <b>Calories:</b> [{this.props.userData.shared?.goals.calories[0]},{" "}
                                    {this.props.userData.shared?.goals.calories[1]}], &nbsp;
                                    <b>Fat:</b> [{this.props.userData.shared?.goals.fat[0]},{" "}
                                    {this.props.userData.shared?.goals.fat[1]}], &nbsp;
                                    <b>Carbohydrates:</b> [
                                    {this.props.userData.shared?.goals.carbohydrates[0]},{" "}
                                    {this.props.userData.shared?.goals.carbohydrates[1]}], &nbsp;
                                    <b>Protein:</b> [{this.props.userData.shared?.goals.protein[0]},{" "}
                                    {this.props.userData.shared?.goals.protein[1]}],&nbsp;
                                    <b>Time:</b> [
                                    {parseInt(this.props.userData.shared.goals.time[0] / 60)},{" "}
                                    {parseInt(this.props.userData.shared.goals.time[1] / 60)}]
                                </p>
                                <br></br>
                                <h6>
                                    Working some magic to find make your meal plan (this will take
                                    a few moments)...
                                </h6>
                                <br></br>
                                <Button
                                    variant="danger"

                                    onClick={() => {
                                        //this.forceUpdate();
                                        this.terminate();
                                    }}
                                >
                                    Cancel process
                                </Button>
                            </div>
                        </Container>
                        <br></br>
                        <div style={{ paddingTop: 30 }}>
                            <Container fluid>
                                <Row> {this.state.solutions} </Row>
                            </Container>
                        </div>
                    </div>
                );
            }
        }

        return (
            <div>
                <Redirect to="/"></Redirect>
            </div>
        );
    }
}

const mapStateToProps = (state) => ({
    token: state.reducer.token,
    userData: state.reducer.userData,
    isAuthed: state.reducer.isAuthed,
});

export default connect(mapStateToProps, { getUserData, updateUserData })(
    withRouter(withSnackbar(GroupPlan))
);
