import React from "react";
import { connect } from "react-redux";
import {
    getUserData,
    addSolution,
    updateUserData,
} from "../../helpers/DataActions.js";
import { withSnackbar } from "notistack";
import { withRouter } from "react-router-dom";
import { Card, CardContent, Typography, IconButton, Grid, Tooltip } from '@material-ui/core'
import FavoriteIcon from '@material-ui/icons/Favorite';
import NotInterestedIcon from '@material-ui/icons/NotInterested'


class Day extends React.Component {
    goals;
    accurateTime = true;
    shownWarning = false;
    constructor(props) {
        super(props);
    }
    renderCards(meals) {
        return Object.entries(meals).map(([key, elem]) => {
            //Render each meal as a card and add its nutrient values to the totals
            if (isNaN(parseInt(elem["seconds"]))) {
                this.accurateTime = false;
            }
            return <Card style={{ marginBottom: 15 }}>
                <CardContent>
                    <Typography gutterBottom variant="h5" component="h2">
                        <a target="_blank" style={{ color: "black" }} href={elem["src"]}>
                            {elem["name"]}
                        </a>
                    </Typography>
                    <Grid container spacing={0}>
                        <Grid item xs={10}>

                            <Typography variant="body2" component="p">
                                <b>Calories:</b> {elem["calories"]}

                            </Typography>
                            <Typography variant="body2" component="p">
                                <b>Carbohydrates (g): </b>{elem["carbohydrates"]}
                            </Typography>
                            <Typography variant="body2" component="p">
                                <b>Fat (g):</b> {elem["fat"]}
                            </Typography>
                            <Typography variant="body2" component="p">
                                <b> Protein (g):</b> {elem["protein"]}
                            </Typography>
                            <Typography variant="body2" component="p">
                                <b> Time (min):</b> {parseInt(elem["seconds"] / 60) || "N/A"}
                            </Typography>

                        </Grid>
                        <Grid item xs={2} container direction="column"
                            justify="flex-end"
                            alignItems="flex-start"
                        >
                            <Grid item xs={2}>
                                <Tooltip title="Like Recipe" placement="right" aria-label="add">
                                    <IconButton disabled={this.props.userData.shared.blocked.indexOf(key) < 0 ? false : true} onClick={() => { this.toggleLiked(key) }} size="small" aria-label="add to favorites">
                                        <FavoriteIcon color={this.props.userData.shared.liked.indexOf(key) < 0 ? "inherit" : "secondary"} />
                                    </IconButton>
                                </Tooltip>

                            </Grid>
                            <Grid item xs={2}>
                                <Tooltip title="Block Recipe" placement="right" aria-label="add">
                                    <IconButton disabled={this.props.userData.shared.liked.indexOf(key) < 0 ? false : true} onClick={() => { this.toggleBlocked(key) }} size="small" aria-label="add to not interested">
                                        <NotInterestedIcon color={this.props.userData.shared.blocked.indexOf(key) < 0 ? "inherit" : "secondary"} />
                                    </IconButton>
                                </Tooltip>
                            </Grid>

                        </Grid>
                    </Grid>
                </CardContent>
            </Card>
        })
    }
    showTotals(totals, goals) {

        let sum = totals;
        let breaksCalories = false;
        let numberBroken = 0;

        //console.log(totals, goals)

        if (sum.calories < goals.calories[0]) {
            sum.calories = <span style={{ color: "red" }}>{sum.calories}<br /> <i>(below threshold)</i></span>
            breaksCalories = true;
            numberBroken += 1;
        } else if (sum.calories > goals.calories[1]) {
            sum.calories = <span style={{ color: "red" }}>{sum.calories}<br /> <i>(exceeds limit)</i></span>
            breaksCalories = true;
            numberBroken += 1;
        }

        if (sum.carbohydrates < goals.carbohydrates[0]) {
            sum.carbohydrates = <span style={{ color: "red" }}>{sum.carbs}<br /> <i>(below threshold)</i></span>
            numberBroken += 1;
        } else if (sum.carbohydrates > goals.carbohydrates[1]) {
            sum.carbohydrates = <span style={{ color: "red" }}>{sum.carbohydrates}<br /> <i>(exceeds limit)</i></span>
            numberBroken += 1;
        }


        if (sum.fat < goals.fat[0]) {
            sum.fat = <span style={{ color: "red" }}>{sum.fat}<br /> <i>(below threshold)</i></span>
            numberBroken += 1;
        } else if (sum.fat > goals.fat[1]) {
            sum.fat = <span style={{ color: "red" }}>{sum.fat}<br /> <i>(exceeds limit)</i></span>
            numberBroken += 1;
        }


        if (sum.protein < goals.protein[0]) {
            sum.protein = <span style={{ color: "red" }}>{sum.protein}<br /> <i>(below threshold)</i></span>
            numberBroken += 1;
        } else if (sum.protein > goals.protein[1]) {
            sum.protein = <span style={{ color: "red" }}>{sum.protein}<br /> <i>(exceeds limit)</i></span>
            numberBroken += 1;
        }


        if (sum.seconds < goals.time[0]) {
            sum.seconds = <span style={{ color: "red" }}>{sum.seconds}<br /> <i>(below threshold)</i></span>
        } else if (sum.seconds > goals.time[1]) {
            sum.seconds = <span style={{ color: "red" }}>{sum.seconds}<br /> <i>(exceeds limit)</i></span>
        }
        else {
            sum.seconds = parseInt(sum.seconds / 60);
        }


        if (!this.accurateTime) {
            sum.seconds = <span>{sum.seconds}<span style={{ color: "red" }}>*</span></span>
        }
        return <Card style={{ marginBottom: 15, width: "100%" }}>
            <CardContent>
                <Typography gutterBottom variant="h6" component="h2">
                    Totals:
                </Typography>
                <Typography variant="body2" component="p">
                    <b>Calories:</b> {sum.calories}
                </Typography>
                <Typography variant="body2" component="p">
                    <b>Carbohydrates (g): </b>{sum.carbohydrates}
                </Typography>
                <Typography variant="body2" component="p">
                    <b>Fat (g):</b> {sum.fat}
                </Typography>
                <Typography variant="body2" component="p">
                    <b> Protein (g):</b> {sum.protein}
                </Typography>
                <Typography variant="body2" component="p">
                    <b> Time (min):</b> {sum.seconds}
                </Typography>
            </CardContent>
        </Card>
    }
    toggleLiked = (id) => {
        let loc = this.props.userData.shared.liked.indexOf(id);
        let sharedData = { ...this.props.userData.shared }


        console.log(loc);
        if (loc < 0) {
            console.log("Liking...", id);
            sharedData.liked = this.props.userData.shared.liked.concat(id)
        }
        else {
            console.log("Unliking...", id);
            let temp = [...this.props.userData.shared.liked]
            temp.splice(loc, 1)
            sharedData.liked = temp;
        }
        const updated = Object.assign({ ...this.props.userData }, { "shared": sharedData });
        this.props.updateUserData(this.props.token, updated, this.showToast);
        this.forceUpdate();
    };

    toggleBlocked = (id) => {
        let loc = this.props.userData.shared.blocked.indexOf(id);
        let sharedData = { ...this.props.userData.shared }

        if (loc < 0) {
            console.log("Blocking...", id);
            sharedData.blocked = this.props.userData.shared.blocked.concat(id)
        }
        else {
            console.log("Unblocking...", id);
            let temp = [...this.props.userData.shared.blocked]
            temp.splice(loc, 1)
            sharedData.blocked = temp;

        }
        this.forceUpdate();
        const updated = Object.assign({ ...this.props.userData }, { "shared": sharedData });
        this.props.updateUserData(this.props.token, updated, this.showToast);
    };

    showToast = (msg, variant) => {
        //this.props.enqueueSnackbar(msg, { variant });
    };

    render() {
        const { meals, constraints, day } = this.props;
        if (isNaN(Object.keys(meals)[0])){
            console.log("This is a group layout")
            return <></>

        }
        const totals = Object.entries(meals).map(([key, value]) => value).reduce((total, meal) => {
            return {
                calories: total.calories + (Math.round(meal.calories * 100) / 100),
                fat: total.fat + (Math.round(meal.fat * 100) / 100),
                carbohydrates: total.carbohydrates + (Math.round(meal.carbohydrates * 100) / 100),
                protein: total.protein + (Math.round(meal.protein * 100) / 100),
                seconds: total.seconds + (meal.seconds || 0)
            }
        })

        //console.log(totals)
        //Call meals and total display functions
        return <div style={{ paddingBottom: 40 }} >
            <h4>Day {day}</h4>
            {this.renderCards(meals)}
            {this.showTotals(totals, constraints)}
        </div>
    }
}


const mapStateToProps = (state) => ({
    token: state.reducer.token,
    userData: state.reducer.userData,
    isAuthed: state.reducer.isAuthed,
});

export default connect(mapStateToProps, { getUserData, updateUserData })(
    withRouter(withSnackbar(Day))
);
