import React from 'react';
import { connect } from 'react-redux';
import { Navbar, Nav } from 'react-bootstrap';
import {signOut} from '../../helpers/DataActions'
class Menu extends React.Component {
    render() {
        if (this.props.isAuthed) {
            //If the user is authenticated, show this menu. 
            return <div>
                <Navbar variant="dark" style={{ background: "black", color: "white!important" }} expand="lg">
                    <Navbar.Brand href="#" style={{ fontSize: "1.5rem", fontWeight: "bolder", textTransform: "uppercase", color: "white" }}>
                        <span style={{ verticalAlign: "middle", margin: "0px 10px" }} class="material-icons">restaurant</span><span style={{ verticalAlign: "middle" }}>Tasty Target
                </span></Navbar.Brand>
                    <Navbar.Toggle aria-controls="basic-navbar-nav" />
                    <Navbar.Collapse id="basic-navbar-nav">
                        <Nav className="ml-auto">
                            <Nav.Link style={{ color: "white", fontSize: "larger" }} href="#plan">My Plan</Nav.Link>
                            <Nav.Link style={{ color: "white", fontSize: "larger" }} href="#settings">Settings</Nav.Link>
                            <Nav.Link onClick={this.props.signOut} style={{ color: "white", fontSize: "larger" }} href="/"><span style={{ verticalAlign: "middle", margin: "0px 10px" }} class="material-icons">logout</span></Nav.Link>
                        </Nav>
                    </Navbar.Collapse>
                </Navbar>
            </div>
        }


        return <div>
            <Navbar bg="light" expand="lg">
                <Navbar.Brand href="#" style={{ fontSize: "1.5rem", fontWeight: "bolder", textTransform: "uppercase" }}>
                    <span style={{ verticalAlign: "middle", margin: "0px 10px" }} class="material-icons">restaurant</span><span style={{ verticalAlign: "middle" }}>Tasty Target
                </span></Navbar.Brand>
                <Navbar.Toggle aria-controls="basic-navbar-nav" />
                <Navbar.Collapse id="basic-navbar-nav">
                    <Nav className="ml-auto">
                    </Nav>
                </Navbar.Collapse>
            </Navbar>
        </div>
    }
}


const mapStateToProps = state => ({
    token: state.reducer.token,
    userData: state.reducer.userData,
    isAuthed: state.reducer.isAuthed,
});

export default (
    connect(
        mapStateToProps,
        {signOut}
    )(Menu));

