import React from 'react';
import { connect } from 'react-redux';
import { Redirect } from 'react-router'
import { Link } from 'react-router-dom'
import './App.css';
import {
  getUserData, updateToken
} from './helpers/DataActions.js';
import StyledFirebaseAuth from 'react-firebaseui/StyledFirebaseAuth';
import firebase from 'firebase';
import { Container, Button } from 'react-bootstrap';

class Home extends React.Component {
  // Configure FirebaseUI.
  uiConfig = {
    // Popup signin flow rather than redirect flow.
    signInFlow: 'popup',
    // Redirect to /signedIn after sign in is successful. Alternatively you can provide a callbacks.signInSuccess function.
    //signInSuccessUrl: '/signedIn',
    callbacks: {
      signInSuccessWithAuthResult: () => firebase.auth().currentUser.getIdToken(true).then(async (idToken) => {
        this.props.getUserData(idToken);
        this.props.updateToken(idToken);
        return false;
      })
    },
    // We will display Google and Facebook as auth providers.
    signInOptions: [
      firebase.auth.GoogleAuthProvider.PROVIDER_ID,
      /*firebase.auth.FacebookAuthProvider.PROVIDER_ID*/
    ]
  };

  // Make sure we un-register Firebase observers when the component unmounts.

  render() {
    //Displaying firebase auth when user is not signed in
    if (!this.props.isAuthed) {
      return <div>
        <Container style={{ paddingTop: 40 }}>
          <h2>
            Tasty Target aims to improve your eating habits while giving you recipes you'll enjoy. </h2> <br />
          <p> Using Tasty Target is simple: you describe yourself, your likes, and dislikes, then you ask for a plan.</p>
          <br></br>
          <p><i>Your basic data will only be used to provide functionality and will not be shared.</i></p>
          <br></br>
          <StyledFirebaseAuth uiConfig={this.uiConfig} firebaseAuth={firebase.auth()} />
        </Container>

      </div>
    }
    else if (this.props.userData.unregistered) {
      return <Redirect to="/settings"></Redirect>
    }
    return <div> <Container style={{ paddingTop: 40 }}><h2> Tasty Target aims to improve your eating habits while giving you recipes you'll enjoy. </h2> <br /> <p> Using Tasty Target is simple: you describe yourself, your likes, and dislikes, then you ask for a plan.</p> <br></br> <div> <Link to="settings"> <Button> Set My Preferences </Button> </Link> <br /><br /> <Link to="plan"> <Button> View My Plan </Button> </Link> </div> </Container> </div>;
  }
}

const mapStateToProps = state => ({
  token: state.reducer.token,
  userData: state.reducer.userData,
  isAuthed: state.reducer.isAuthed,
});

export default (
  connect(
    mapStateToProps,
    { getUserData, updateToken }
  )(Home));


