// Firebase App (the core Firebase SDK) is always required and must be listed first
import firebase from "firebase/app";
import "firebase/auth";

import React from 'react';
import { Route } from "react-router-dom";
import { connect } from 'react-redux';

import Home from './Home'
import Plan from "./components/plan/Plan";
import GroupPlan from "./components/plan/GroupPlan"
import Preferences from './components/preferences/Preferences';
import './App.css';
import {
  getUserData, updateToken

} from './helpers/DataActions.js';
import Menu from './components/menu/Menu'
import { Container } from 'react-bootstrap';

class App extends React.Component {
  render() {
    return <div>
      <Menu />
      <Route exact path="/"><Container><Home /></Container></Route>
      <Route path="/settings"><Container><Preferences /></Container></Route>
      <Route path="/plan/:action?" render={(props) => <Plan action={props.match.params.action} {...props}></Plan>}></Route>
      <Route path="/group/plan/:action?" render={(props) => <GroupPlan action={props.match.params.action} {...props}></GroupPlan>}></Route>
    </div>
  }
}

const mapStateToProps = state => ({
  token: state.reducer.token,
  userData: state.reducer.userData,
  isAuthed: state.reducer.isAuthed,
});

export default (
  connect(
    mapStateToProps,
    { getUserData, updateToken }
  )(App));


