/* eslint-disable eqeqeq */
const functions = require('firebase-functions');
const admin = require('firebase-admin');
const firebase = require('firebase');
const express = require('express');
const cookieParser = require('cookie-parser')();
const app = express();
const cors = require('cors')({ origin: true });

var serviceAccount = require("./serviceAccountKey.json");
const { exampleObjectMetadata } = require('firebase-functions-test/lib/providers/storage');

admin.initializeApp({
    credential: admin.credential.cert(serviceAccount),
    databaseURL: "https://dietlp.firebaseio.com"
});


const validateFirebaseIdToken = async (req, res, next) => {
    console.log('Check if request is authorized with Firebase ID token');

    if ((!req.headers.authorization || !req.headers.authorization.startsWith('Bearer ')) &&
        !(req.cookies && req.cookies.__session)) {
        console.error('No Firebase ID token was passed as a Bearer token in the Authorization header.',
            'Make sure you authorize your request by providing the following HTTP header:',
            'Authorization: Bearer <Firebase ID Token>',
            'or by passing a "__session" cookie.');
        res.status(403).send('Unauthorized');
        return;
    }

    let idToken;
    if (req.headers.authorization && req.headers.authorization.startsWith('Bearer ')) {
        console.log('Found "Authorization" header');
        // Read the ID Token from the Authorization header.
        idToken = req.headers.authorization.split('Bearer ')[1];
    } else if (req.cookies) {
        console.log('Found "__session" cookie');
        // Read the ID Token from cookie.
        idToken = req.cookies.__session;
    } else {
        // No cookie
        res.status(403).send('Unauthorized');
        return;
    }

    try {
        const decodedIdToken = await admin.auth().verifyIdToken(idToken);
        console.log('ID Token correctly decoded', decodedIdToken);
        req.user = decodedIdToken;
        next();
        return;
    } catch (error) {
        console.error('Error while verifying Firebase ID token:', error);
        res.status(403).send('Unauthorized');
        return;
    }
};

const purifyData = (data) => {
    const purifiedData = Object.keys(data).reduce((accumulator, prop) => {
        const propData = data[prop];
        if (propData instanceof firebase.firestore.DocumentReference) {
            accumulator[prop] = propData.path;
        } else {
            accumulator[prop] = propData;
        }

        return accumulator;
    }, {});

    return purifiedData;
};


const db = admin.firestore();


app.use(cors);
app.use(express.json());
app.use(cookieParser);
app.use(validateFirebaseIdToken);



app.get('/', (req, res) => {
    res.send("Hello, World! \n I am wondering why you are here.")
})


app.get('/user/:function', async (req, res) => {
    //Get user data
    const firstName = req.user.name.split(" ")[0] || "";
    const lastName = req.user.name.split(" ")[1] || "";
    const email = req.user.email;
    const uid = req.user.uid;

    let shared = {};
    let private = {};

    if (req.params.function == "shared") {
        try {
            shared = await db.collection('users').doc(uid).collection('shared').doc(uid).get()
            shared = await shared.data();
        } catch (e) {
            res.status(500).json({ "error": e })
        }
    }
    else if (req.params.function == "private") {
        try {
            private = await db.collection('users').doc(uid).collection('private').doc(uid).get()
            private = await private.data();
        } catch (e) {
            res.status(500).json({ "error": e })
        }

    }
    else if (req.params.function == "all") {
        //Get shared and private sub-collections
        try {
            shared = await db.collection('users').doc(uid).collection('shared').doc(uid).get()
            shared = await shared.data();

            private = await db.collection('users').doc(uid).collection('private').doc(uid).get()
            private = await private.data();
        } catch (e) {
            res.status(500).json({ "error": e })
        }
    }
    else {
        res.status(400).json({ "error": "Missing type of collection!" })

    }
    // eslint-disable-next-line no-eq-null
    if (shared == null) {
        shared = {
            "goals": {
                "calories": [1900, 2100],
                "carbohydrates": [200, 300],
                "protein": [25, 80],
                "fat": [45, 75],
                "time": [0, 7200],
                "diet": "negative",
            },
            "allergens": [],
            "tastes": [],
            "liked": [],
            "blocked": [],
            "allowed": {
                email: true,
            }
        };

    }
    // eslint-disable-next-line no-eq-null
    if (private == null) {
        private = {
            "unregistered": true,
            "demographics": {
                "firstName": firstName,
                "lastName": lastName,
                "emailAddress": email,
                "age": '',
                "height": '',
                "weight": '',
                "sex": "Male",
                "meals": 3,
                "unit": "imperial",
                "activity": "sedentary"
            },
            "diet": []
        };
    }

    if (req.params.function == "shared") {
        res.status(200).json({
            "success": {
                "shared": shared
            }
        })
    }
    else if (req.params.function == "private") {
        res.status(200).json({
            "success": {
                "private": private
            }
        })
    }
    else {
        //All (by default)
        res.status(200).json({
            "success": {
                "private": private,
                "shared": shared,
            }
        })
    }

});


app.post('/user/', async (req, res) => {
    //Create & update personal data for user

    const document = req.body;
    const email = req.user.email;
    const uid = req.user.uid;

    let private = {}
    let shared = {}
    let respObj = {}

    if ("private" in document) {
        const defaultDemographics = {
            "firstName": document.private.firstName,
            "lastName": document.private.lastName,
            "emailAddress": document.private.email,
            "age": '',
            "height": '',
            "weight": '',
            "sex": "Male",
            "meals": 3,
            "unit": "imperial",
            "activity": "sedentary"
        }
        const demographics = Object.assign(defaultDemographics, document.private.demographics);
        const diet = Object.assign([], document.private.diet);

        try {
            privRef = await db.collection('users').doc(uid).collection('private').doc(uid)
            await privRef.update(
                {
                    "demographics": demographics,
                    "diet": diet,
                }
            )
        } catch (e) {
            console.error(e);
            res.status(400).json({ "error": e })
        }

        //Fetch the updated data
        try {
            private = await db.collection('users').doc(uid).collection('private').doc(uid).get()
            private = await private.data();
        } catch (e) {
            console.error("There was an error, procceeding regardless", e);
        }

        respObj = Object.assign(respObj, { "private": private });
    }

    if ("shared" in document) {
        const defaultGoals = {
            "calories": [1900, 2100],
            "carbohydrates": [200, 300],
            "protein": [25, 80],
            "fat": [45, 75],
            "time": [0, 7200],
            "diet": "negative",
        };

        const goals = Object.assign(defaultGoals, document.shared.goals);
        const allergens = Object.assign([], document.shared.allergens);
        const tastes = Object.assign([], document.shared.tastes);
        const liked = Object.assign([], document.shared.liked);
        const blocked = Object.assign([], document.shared.blocked);
        const allowed = Object.assign({}, document.shared.allowed);
        const cookFor = Object.assign({ [email]: true }, document.shared.cookFor);

        try {
            sharedRef = await db.collection('users').doc(uid).collection('shared').doc(uid)
            await sharedRef.update(
                {
                    "goals": goals,
                    "allergens": allergens,
                    "tastes": tastes,
                    "liked": liked,
                    "blocked": blocked,
                    "allowed": allowed,
                    "cookFor": cookFor
                }
            )
        } catch (e) {
            console.error(e);
            res.status(400).json({ "error": e })
        }

        //Fetch the updated data 
        try {
            shared = await db.collection('users').doc(uid).collection('shared').doc(uid).get()
            shared = await shared.data();
        } catch (e) {
            console.error("There was an error, procceeding regardless", e);
        }
        respObj = Object.assign(respObj, { "shared": shared });
    }

    res.status(200).json({ "success": respObj });
});

app.get('/fetch', async (req, res) => {
    //Get user data
    let desired = req.query.user;


    let uid;
    let userData;
    /* 
     let firstName = req.user.name.split(" ")[0] || "";
     let lastName = req.user.name.split(" ")[1] || "";
     let email = req.user.email;
     let uid = req.user.uid
    */

    try {
        uid = await db.collection('shared').doc(desired).get();
        uid = await uid.data().uid;
        console.log("UID of queried: ", uid)
        //userDataRef = userDataRef["_path"]["segments"].join("/");

    } catch (e) {
        res.status(400).json({ "errorName": e.name, "errorMessage": e.message, "errorStack": e.stack })
    }

    try {
        userData = await db.collection('users').doc(uid).collection('shared').doc(uid).get()
        userData = await userData.data();

    } catch (e) {
        res.status(400).json({ "errorName": e.name, "errorMessage": e.message, "errorStack": e.stack, "ref": uid })
    }

    userData["user"] = desired;
    console.log(userData);
    res.status(200).json({ "success": userData })
})


app.get('/test/:function', async (req, res) => {
    //Get user data
    let userData;
    let firstName = req.user.name.split(" ")[0] || "";
    let lastName = req.user.name.split(" ")[1] || "";
    let email = req.user.email;
    let uid = req.user.uid


    try {
        userData = await db.collection('users').doc(uid).collection('shared').doc(uid).get()
        userData = await userData.data();

    } catch (e) {
        res.status(400).json({ "error": e })
    }
    console.log(userData);
    res.status(200).json({ "success": req.params.function })
})


exports.app = functions.https.onRequest(app);
