import java.util.ListIterator;
import java.util.Vector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;



public class Utilities{
	private final static String LOG_FILE = "responder.log";
	public  final static Location START = new Location(1,11);
	public  final static Location END = new Location(30,10);
	public  final static int NUMBER_OF_ROWS = 30;
	public  final static int NUMBER_OF_COLUMNS = 20;
	public  final static int NUMBER_OF_ANTS = 30;
	public  final static int MAX_NUMBER_OF_ANTS_RESPONDER_KILL = 5;

/**
 * Prints a network (Can be used by the Responder to print
 * its network, or by the Finder to print the network that it revealed)
 * @param networkToPrint A vector of the Locations in the 
 * network - doesn't need to have a particular order. 
 */
public static void print(Vector networkToPrint){
	boolean[][] arrayOfNetwork;
	arrayOfNetwork = new boolean[NUMBER_OF_ROWS][NUMBER_OF_COLUMNS];
	for (int i = 0; i < NUMBER_OF_ROWS; i++) {
        for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
        	arrayOfNetwork[i][j] = false;
        }
    }	
	Location temp = null;
	boolean hasBadLocations = false;
	for(ListIterator it = networkToPrint.listIterator() ; it.hasNext() ; ){        //going over the messages
		temp = (Location)it.next();
		if((temp.getX()>NUMBER_OF_ROWS) | (temp.getX()<1) | (temp.getY()>NUMBER_OF_COLUMNS) | (temp.getY()<1)){
			System.out.println("Location " + temp.getX() + "," + temp.getY() + " is illigal");
			hasBadLocations = true;
			continue;
		}			
		arrayOfNetwork[temp.getX()-1][temp.getY()-1] = true;
	}
	if(hasBadLocations)
		return;
	String row;
	for(int i = NUMBER_OF_ROWS-1; i>=0; i--){
		row = "";
		for(int j=0; j<NUMBER_OF_COLUMNS; j++){
			if(arrayOfNetwork[i][j]){
				if(i == START.getX()-1 & j == START.getY()-1){
					row = row + "S";
					continue;
				}
				if(i == END.getX()-1 & j == END.getY()-1){
					row = row + "D";
					continue;
				}
				row = row + "X";
			}
			else{
				row = row + " ";
			}
		}
		System.out.println(row);
		System.out.flush();
	}
}
/**
 * Prints sessions results to the end of the file 'responder.log'.
 * If the file doesn't already exit it will be created. 
 * @param finderName The name of the finder.
 * @param isd An indication of whether the finder detected a valid path of length d, in case that such a path exists, or if it didn't report any in case none exist.
 * @param isdp An indication of whether the finder detected a valid path of length d+1, in case that such a path exists, or if it didn't report any in case none exist.
 * @param isdpp An indication of whether the finder detected a valid path of length d+2, in case that such a path exists, or if it didn't report any in case none exist.
 * @param numbderOfRounds The number of rounds the it took the Finder to complete its task.
 * @param message Any message
 */
public static void printResults(String finderName, boolean isd, boolean isdp, boolean isdpp, int numbderOfRounds, String message){
	try{
		PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(LOG_FILE, true)), true);  //create log file - in case it is not already exist
		out.println("===== Sessions Summary: =====");
		out.println("Finder's name: " + finderName);
		out.println("The number of rounds it took the Finder to figure the network:  " + numbderOfRounds);
		if(isd)
			out.println("+ Finder provided a correct answer regarding a path of length d");
		else
			out.println("- Finder didn't provide a correct answer regarding a path of length d");	
//		if(isdp)
//			out.println("+ Finder provided a correct answer regarding a path of length d+1");
//		else
//			out.println("- Finder didn't provide a correct answer regarding a path of length d+1");	
		if(isdpp)
			out.println("+ Finder provided a correct answer regarding a path of length d+2");
		else
			out.println("- Finder didn't provide a correct answer regarding a path of length d+2");
		if(message != null)
			out.println("A message from Responder: " + message);
		out.println("===== End of Sessions Summary =====");
		out.println();
		out.flush();
		out.close();
	}catch(IOException e){System.out.println("Could not print to " + LOG_FILE);}
}

}