import java.util.Vector;
import java.util.Random;
import java.rmi.*;


/**
 * @author A C
 */
public class AntImp implements Ant{
	private int ID;
	private Location currentLocation;
	private boolean alive;
	private Responder responder;
	private FinderImp finder;
	private Vector neighborsOfCurrentNode;
    private String responderHost;
    private String responderName;
	
	
	public AntImp(int ID, FinderImp finder, String responderName, String responderHost){
		this.ID = ID;
		neighborsOfCurrentNode = new Vector();
		this.finder = finder; 
		this.responderHost = responderHost;
		this.responderName = responderName;
	}
                      
    public void run(){  
		System.out.println("Ant " + ID + ": I'm alive!");
		System.out.flush();
		currentLocation = new Location(1,11);
		alive = true;
		if(!initializeResponder(responderName, responderHost))
			alive = false;
		Location oldLocation = new Location(1,11);
		Location newLocation = null;
		while(alive)
		{
			neighborsOfCurrentNode.clear();
			try{
				AntResponsePair antResponsePair = null;
				antResponsePair = responder.getNeighborsOfCurrentNode(ID,currentLocation);
				if(antResponsePair.killAnt){
					alive = false;
					finder.reportDeadAnt(ID);
				}
				else{
					if(antResponsePair.listOfLocations != null)
						neighborsOfCurrentNode = antResponsePair.listOfLocations;
					if(neighborsOfCurrentNode.size() > 0){ //ant should report only if there is atleast one neighbor!!
						Random generator = new Random();
						int randomIndex = generator.nextInt(neighborsOfCurrentNode.size());
						oldLocation.setX(currentLocation.getX());
						oldLocation.setY(currentLocation.getY());
						newLocation = (Location)neighborsOfCurrentNode.get(randomIndex);
						goToLocation(newLocation.getX(), newLocation.getY());
						finder.reportLocations(ID, oldLocation, neighborsOfCurrentNode);
//						try{
//							Thread.sleep(1);
//						}catch(InterruptedException e){}
					}
				}
			}catch(RemoteException e) {
				System.out.println("Ant " + ID + ": I lost the connection with the Responder!"); 
				System.out.flush();
				alive = false;
				finder.reportDeadAnt(ID);
			}
		}
		System.out.println("Ant " + ID + ": I'm dead!");
		System.out.flush();
    }

   
    private void goToLocation(int x, int y) throws RemoteException{
    	Location newLocation = new Location(x,y);
		int answer = responder.updateAntLocation(ID, newLocation);
		if(answer == 1){
			currentLocation.setX(x);
			currentLocation.setY(y);
		}
		if(answer == -1){
			alive = false;
			finder.reportDeadAnt(ID);
		}
	}
    
  
	public boolean initializeResponder(String responderName, String responderHost){
		try{
			responder = (Responder)Naming.lookup("rmi://" + responderHost + "/" + responderName);
			System.out.println("Ant " + ID + ": I have a connection with the Responder!");
			return true;
		}catch(Exception e){System.out.println("Ant " + ID + ": I could not initiate a connection with the Responder");}
		return false;
	}
    
	public int getID(){
		return ID;
	}
	
    public synchronized void kill(){
    	alive = false;
    }
}
