import numpy as np
import h5py
import pyepipolicy
import json as js
import os
import matplotlib.pyplot as plt
from datetime import datetime

def generate_model_from_params(params, path_file ,config = pyepipolicy.Config('35.209.8.72')) :
    # function to generate one model for the given params, return the computation of the model. 

    # params : probabilities => dictionnary of parameters sorted like the results json generated by epipolicy
    # path_file : path to json file representing one model
    # config : configuration to run the computation, default = pyepipolicy.Config('ec2-18-219-205-255.us-east-2.compute.amazonaws.com')
    
    jsonFile = open(path_file,"r")
    data = js.load(jsonFile)
    jsonFile.close()
    idx = 0
    for param in params :
        data["model"]["parameters"][idx]["default_value"] = params[param]
        idx = idx + 1
    
    jsonFile = open(path_file,"w+")
    jsonFile.write(js.dumps(data))
    jsonFile.close()
    
    project = pyepipolicy.Project(path_file)
    
    results = project.run(config)
    return results

def x_y_from_Json(path_to_JsonFile):
    # Function to extract X, beta, gamma from a JSon result file 
    
    # Params : path_to_JsonFile : path to json file of the model results
    # retrun :  X the evolution of infectious people , y the parameters of the model
    file = open(path_to_JsonFile,"r")
    data = js.load(file)
    file.close()
    y = np.empty(len(data[len(data)-1]["param"]))
    i = 0
    for name in data[len(data)-1]["param"] :
        y[i] = data[len(data)-1]["param"][name]
        i = i + 1
    #print(len(data)-1)
    X = np.empty(len(data)-1)
    for day in range(len(data)-1) :
        somme = 0
        for i in range(len(data[day]["result"][0]["compartments"])) :
            if data[day]["result"][0]["compartments"][i]["compartment_name"][0] == 'I' :
                #print(data[day]["result"][0]["compartments"][i]["compartment_name"])
                somme = somme + data[day]["result"][0]["compartments"][i]["groups"][0]["count"]
        X[day] = somme
        #print(somme)
        
    return X, y

def x_y_from_Json_all(path_to_JsonFile, file_path_model):
    # Function to extract X, beta, gamma from a JSon result file 
    
    # Params : path_to_JsonFile : path to json file of the model results
            #  file_path_model :  path to json model file used to generate the results
    # retrun :  X the evolution of infectious people , y the parameters of the model
    file = open(path_to_JsonFile,"r")
    data = js.load(file)
    file.close()
    y = np.empty(len(data[len(data)-1]["param"]))
    i = 0
    for name in data[len(data)-1]["param"] :
        y[i] = data[len(data)-1]["param"][name]
        i = i + 1
    #print(len(data)-1)
    X = np.empty(len(data)-1)
    
    #On peut utiliser la fonction get_name_infection_comp mais il faut prendre en entre le path_file du model 
    infectious_compartment = get_name_infection_comp(file_path_model)
    
    
    #infectious_compartment = ['Ipre', 'Iasym', 'Imild', 'Hsev', 'Hcri', 'Qpre', 'Qasym', 'Hmild']
    for day in range(len(data)-1) :
        somme = 0
        for i in range(len(data[day]["result"][0]["compartments"])) :
            c = data[day]["result"][0]["compartments"][i]["compartment_name"]
            #print(c)
            if c in infectious_compartment :
                #print(data[day]["result"][0]["compartments"][i]["compartment_name"])
                somme = somme + data[day]["result"][0]["compartments"][i]["groups"][0]["count"]
        X[day] = somme
        #print(somme)
        
    return X, y
    
def load_data(path_file):
    liste_fichier = os.listdir(path_file)
    first_path_file = path_file + liste_fichier[0]
    file = open(first_path_file,"r")
    data = js.load(file)
    file.close()
    nb_params = len(data[len(data)-1]["param"])
    nb_days = len(data)-1
    nb_fichier = len(liste_fichier)

    y = np.empty((nb_fichier,nb_params), dtype = float)
    X = np.empty((nb_fichier,nb_days))

    num_simulation=0
    for filename in sorted(liste_fichier):
    	X[num_simulation], y[num_simulation] = x_y_from_Json(path_file+filename)
    	num_simulation = num_simulation + 1
        #file = open(path_file+filename,"r")
        #data = js.load(file)
        #y[num_simulation][0] = data[nb_days]["param"]["beta"]
        #y[num_simulation][1] = data[nb_days]["param"]["gamma"]
        #for day in range(nb_days) :
            # get the Infectious count
            #X[num_simulation][day] = data[day]["result"][0]["compartments"][1]["groups"][0]["count"]

    return X , y

def add_noise(nb_infected, j) :
    a = 0.05 * nb_infected
    noise = a * np.random.normal(0, j, nb_infected.shape)
    new_signal = nb_infected + noise
    
    return new_signal

def get_ParamsDict(jsonModelPath) : 
    file = open(jsonModelPath,"r")
    data = js.load(file)
    file.close()

    
    dic = {}
    for i in range(len(data["model"]["parameters"])) : 
        dic[data["model"]["parameters"][i]["name"]] = float(data["model"]["parameters"][i]["default_value"])
    
    return dic


def get_name_infection_comp(path_file):
    # path_file of the model
    # return list of name compartments
    name_comp_inf = []
    file = open(path_file,"r")
    model = js.load(file)
    file.close()

    for idx in range(len(model["model"]["compartments"])):

        for tag in model["model"]["compartments"][idx]["tags"]:
            if tag == 'infectious':
                name_comp_inf.append(model["model"]["compartments"][idx]['name'])

        
    return name_comp_inf


def plot_result(path_result_file,path_model_file) :
    X,y = x_y_from_Json_all(path_result_file,path_model_file)
    plt.plot(X)
    
def logs(file_path_log,dictionnaire) : 
    
    now = datetime.now()
    with open(file_path_log,'a') as log: 
        log.write(now.strftime("%d/%m/%Y %H:%M:%S"))
        log.write(str(dictionnaire)+'\n')

Covid_params_BS = {'beta' : (0,2.7),
                'sigma' : (0,2.1739),
                'psym': (0,6.3658),
                'psev': (0,0.4865),
                'pcri': (0,0.8557),
                'pdeath': (0,7.5472),
                'ra': (0,0.5),
                'ri': (0,7.75188),
                'rm': (0,1.25),
                'rs': (0,0.7143),
                'rc': (0,0.7143),
                'is_': (0,0.2643),
                'iqs': (0,0.7143),
                'ie': (0,0.9301),
                'ipre': (0,1.6179),
                'iasym': (0,1.6179),
                'imild' : (0,1.9231),
                'pvac': (0,9),
                'vs': (0,0.095),
                'vsq' : (0,0.095),
                'gamma' : (0,0.333)
                }
Covid_params = {'beta' : (0,1),
                'sigma' : (0,1),
                'psym': (0,1),
                'psev': (0,0.4865),
                'pcri': (0,0.8557),
                'pdeath': (0,1),
                'ra': (0,0.5),
                'ri': (0,1),
                'rm': (0,1),
                'rs': (0,0.7143),
                'rc': (0,0.7143),
                'is_': (0,0.2643),
                'iqs': (0,0.7143),
                'ie': (0,0.9301),
                'ipre': (0,1),
                'iasym': (0,1),
                'imild' : (0,1),
                'pvac': (0,1),
                'vs': (0,0.095),
                'vsq' : (0,0.095),
                'gamma' : (0,0.333)
                }

