#!/usr/bin/env python
#
# Good site: http://german.about.com/library/blcase_sum.htm
# translating from english to german
# e.g. Accusative a good book
# should return ein gutes Buch
# Accusative a good man
# should return einen guten Mann

# Data flow is this: take English and find gender, number and gloss of noun.
# Use that plus  the case to get article and adjective.
# Combine together. 

cases = {"AccusativeSingularIndefiniteMasculine" : "einen guten", "AccusativeSingularIndefiniteFeminine" : "eine gute", "AccusativeSingularIndefiniteNeuter" : "ein gutes", "AccusativeSingularDefiniteMasculine" : "den guten", "AccusativeSingularDefiniteFeminine" : "die gute", "AccusativeSingularDefiniteNeuter" : "das gute", "NominativeSingularIndefiniteMasculine" : "ein guter", "NominativeSingularIndefiniteFeminine" : "eine gute", "NominativeSingularIndefiniteNeuter" : "ein gutes", "NominativeSingularDefiniteMasculine" : "der gute", "NominativeSingularDefiniteFeminine" : "die gute", "NominativeSingularDefiniteNeuter" : "das gute"}

minidict = {"book" : ["Singular",  "Neuter", "Buch"], "man" : ["Singular", "Masculine", "Mann"], "woman" : ["Singular", "Feminine", "Frau"]}



ineng = input ("Please give me a case followed by a noun phrase, e.g., 'Accusative a good man'. ")
mywords = ineng.split(" ")
print(mywords) # all the words
noun = mywords[len(mywords) - 1] 
print(noun) # print just the noun

numbergenderword = minidict[noun]
print(numbergenderword) # print number, gender, word

determiner = 'Indefinite' # a or an
if mywords[1] == 'the': 
	determiner = 'Definite' # definite article the

prenoun = mywords[0] + numbergenderword[0] + determiner + numbergenderword[1] 
print(prenoun)
print(ineng)
print("is translated to: ")
print(cases[prenoun] + (" ") + numbergenderword[2])





