import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.sound.midi.*;
import java.util.*;

import java.io.*;

public class playmidi{

    Sequencer sequencer;
    Sequence sequence;
    Synthesizer synthesizer;
    Instrument instruments[];
    MidiChannel cc;
    
    static int[] nn={60, 57,57,60,62,55};
    static int[] du={4,10,2,2,2,8};
    
    public playmidi() {
    }


    public void open() {
        try {
            if (synthesizer == null) {
                if ((synthesizer = MidiSystem.getSynthesizer()) == null) {
                    System.out.println("getSynthesizer() failed!");
                    return;
                }
            } 
            synthesizer.open();
            sequencer = MidiSystem.getSequencer();
            sequence = new Sequence(Sequence.PPQ, 10);
        } catch (Exception ex) { ex.printStackTrace(); return; }

        Soundbank sb = synthesizer.getDefaultSoundbank();
		if (sb != null) {
            instruments = synthesizer.getDefaultSoundbank().getInstruments();
            synthesizer.loadInstrument(instruments[0]);
        }
        MidiChannel midiChannels[] = synthesizer.getChannels();
        cc=midiChannels[0];
    }

	public void close() {
        if (synthesizer != null) {
            synthesizer.close();
        }
        if (sequencer != null) {
            sequencer.close();
        }
	}
	
	public void play(int notes[],int duration[]){
		if (notes.length!=duration.length){
			System.out.println("Error:the lengths of the notes and duration do not match.\n");
			return;
		}
		if(cc==null)	open();
		for(int i=0;i<notes.length;i++){
            cc.noteOn(notes[i], 64);
	        try{Thread.sleep(duration[i],0);}catch(InterruptedException ie){}
	        cc.noteOff(notes[i], 64);
	    }
	}
	
	public void play(Vector notes, Vector duration){
		if (notes.size()!=duration.size()){
			System.out.println("Error:the lengths of the notes and duration do not match.\n");
			return;
		}
		if(cc==null)	open();
		for(int i=0;i<notes.size();i++){
          cc.noteOn(((Integer)notes.get(i)).intValue(), 64);
	        try{Thread.sleep(((Integer)duration.get(i)).intValue(),0);}catch(InterruptedException ie){}
	        cc.noteOff(((Integer)notes.get(i)).intValue(), 64);
	    }
	}
	
	public void playFile(String filename){
		try {
			//read stat map from files
				BufferedReader ins= new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
				String line;
				Vector notes = new Vector();
				Vector durations = new Vector();
				while((line=ins.readLine())!=null){
					if (line.trim().length()==0)continue;
					StringTokenizer st= new StringTokenizer(line.trim(),",");
					int note = (new Integer(st.nextToken().trim())).intValue();
					int duration = (new Integer(st.nextToken().trim())).intValue();
					if (note==0) continue;
					notes.add(new Integer(note));
					durations.add(new Integer(duration*200));
	     	}
	     	play(notes,durations);
     		ins.close();
     	}catch(Exception e) {
	      System.out.println("palyFile err:"+e.getMessage());
    	}
    }
		
		
  public static void main(String args[]) {
      final playmidi pm = new playmidi();
      pm.open();
      for(int i=0;i<du.length;i++)du[i]*=100;
      pm.playFile(args[0]);
    System.exit(0);
  }
} 
