import java.awt.*;


public class PostOffice
{
  public Letter[] mailBag;

  public static final int NUM_POLYGONS = 1;
  public static final double FACE_RADIUS = 100.0;

  public Color regular_color;
  public Color active_color;
  public boolean is_active;

  public double main_length;
  public double[][][] initial_coordinates;
  public Matrix_3x3[] polygon_matrices;
  public Matrix_3x3 viewing_matrix;
  public int[][][] appearance_coordinates;

  public double scale_value;
  public double[] offset;

  public double[] font_coordinates;
  public int[] real_font_coordinates;
  public Matrix_3x3 font_matrix, real_font_matrix;
  public String message;

  public PostOffice(int binSize, double scale, double x, double y, String msg)
  {
    int i, j, k;

    this.mailBag = new Letter[binSize];

    this.regular_color = new Color(128, 128, 255);
    this.active_color = Color.pink;
    this.is_active = false;

    this.scale_value = scale;
    this.main_length = scale_value * FACE_RADIUS;

    this.initial_coordinates = new double[NUM_POLYGONS][][];
    this.polygon_matrices = new Matrix_3x3[NUM_POLYGONS];

    this.initial_coordinates[0] = new double[2][4];
    initial_coordinates[0][0][0] = -1.0 * main_length;
    initial_coordinates[0][1][0] = -1.0 * main_length;
    initial_coordinates[0][0][1] = main_length;
    initial_coordinates[0][1][1] = -1.0 * main_length;
    initial_coordinates[0][0][2] = main_length;
    initial_coordinates[0][1][2] = main_length;
    initial_coordinates[0][0][3] = -1.0 * main_length;
    initial_coordinates[0][1][3] = main_length;
    polygon_matrices[0] = new Matrix_3x3();
    polygon_matrices[0].identity();
    // scale
    polygon_matrices[0].translate(0.0, 0.0);

    this.viewing_matrix = new Matrix_3x3();
    this.appearance_coordinates = new int[this.initial_coordinates.length][][];
    for (i = 0; i < this.appearance_coordinates.length; i++)
    {
      this.appearance_coordinates[i] = new int[this.initial_coordinates[i].
                                       length][];
      for (j = 0; j < this.appearance_coordinates[i].length; j++)
      {
        this.appearance_coordinates[i][j] = new int[this.initial_coordinates[i][
                                            j].length];
        for (k = 0; k < this.appearance_coordinates[i][j].length; k++)
        {
          this.appearance_coordinates[i][j][k] = 0;
        }
      }
    }

    this.offset = new double[2];
    offset[0] = x;
    offset[1] = y;

    this.font_coordinates = new double[2];
    this.real_font_coordinates = new int[2];
    this.font_matrix = new Matrix_3x3();
    this.real_font_matrix = new Matrix_3x3();
    this.message = msg;

    font_coordinates[0] = -5.0 * scale;
    font_coordinates[1] = -5.0 * scale;

    font_matrix.identity();
  }

  public void addLetter(Letter l)
  {
    addLetter(l, l.daysToSend);
  }

  public void addLetter(Letter l, int days)
  {
    int i, j, key = -1;
    boolean breakout = false;

    for (i = 0; (i < this.mailBag.length) && (!breakout); i++)
    {
      if (this.mailBag[i] == null)
      {
        key = i;
        breakout = true;
      }
    }

    if (breakout)
    {
      System.out.print("Person " + l.personFrom
                       + " is sending to post office # " + l.postOfficeIdUsed +
                       " an envelope directed to person " + l.personTo
                       + " containing:\n");
      for (j = 0; j < l.contents.length; j++)
      {
        if (l.contents[j][0] == Letter.MESSAGE)
        {
          System.out.print("Message ");
        }
        else if (l.contents[j][0] == Letter.ACK)
        {
          System.out.print("ACK ");
        }
        else
        {
          System.out.print("Unknown ");
        }
        System.out.print(l.contents[j][1] + "\t");
      }
      System.out.print("\n");
      l.daysToSend = days;
      l.isSentYet = true;
      this.mailBag[key] = l;
    }
    else
    {
      System.out.print(
          "Error: Oh no! A post office has no more room for new letters!\n");
    }
  }

  /*
       public void addLetter(int from, int to, int msg_type, int days, int poid) {
    int i, key = -1;
    boolean breakout = false;
    for (i = 0; (i < this.mailBag.length) && (!breakout); i++) {
   if (this.mailBag[i] == null) {
     key = i;
     breakout = true;
   }
    }
    if (breakout) {
   System.out.print("Person "+from+" is sending ");
   if (msg_type == 0) {
     System.out.print("message");
   } else if (msg_type == 1) {
     System.out.print("acknowledgement");
   } else {
     System.out.print("unknown");
   }
   System.out.print(" to person "+to+" at post office # "+poid+"\n");
   this.mailBag[key] = new Letter(from, to, msg_type, days);
    } else {
   System.out.print("Error: Oh no! A post office has no more room for new letters!\n");
    }
       }
   */

  public boolean updateTheMail(Person p[], int poid)
  {
    int i, j;
    Letter l;

    boolean mailSent = false;
    System.out.print(
        "Newmann: (Yawn) Guess I have to send out some letters from post office # "
        + poid + "\n");

    for (i = 0; i < this.mailBag.length; i++)
    {
      if (this.mailBag[i] != null)
      {
        this.mailBag[i].daysToSend--;
        if (this.mailBag[i].daysToSend <= 0)
        {
          mailSent = true;
          l = this.mailBag[i];
          System.out.print("Post office # " + poid + " has just sent person "
                           + l.personTo +
                           " that envelope from person " + l.personFrom
                           + " containing:\n");
          for (j = 0; j < l.contents.length; j++)
          {
            if (l.contents[j][0] == Letter.MESSAGE)
            {
              System.out.print("Message ");
            }
            else if (l.contents[j][0] == Letter.ACK)
            {
              System.out.print("ACK ");
            }
            else
            {
              System.out.print("Unknown ");
            }
            System.out.print(l.contents[j][1] + "\t");
            p[l.personTo].eventsYet[l.contents[j][1]][l.contents[j][0]] = true;
          }
          System.out.print("\n");
          this.mailBag[i] = null;
          /*
            p[l.personTo].eventsYet[l.personFrom][l.letterType] = true;
            System.out.print("Post office # "+poid+" has just sent person "+l.personTo+" that ");
            if (l.letterType == 0) {
              System.out.print("message");
            } else if (l.letterType == 1) {
              System.out.print("acknowledgement");
            } else {
              System.out.print("unknown");
            }
            System.out.print(" from person "+l.personFrom+"\n");
           */
        }
      }
    }
    return mailSent;
  }

  public Color getColor()
  {
    if (this.is_active)
    {
      return this.active_color;
    }
    else
    {
      return this.regular_color;
    }
  }

  public int[] getFontCoordinates(int screenWidth, int screenHeight)
  {
    int i, j;
    double[] cord;
    this.real_font_matrix.copyFromMatrix(this.font_matrix);
    this.real_font_matrix.translate2D(offset);
    this.real_font_matrix.mathToApplet(screenWidth, screenHeight);
    cord = this.real_font_matrix.transform(this.font_coordinates[0],
                                           this.font_coordinates[1]);
    this.real_font_coordinates[0] = (int) Math.round(cord[0]);
    this.real_font_coordinates[1] = (int) Math.round(cord[1]);
    return this.real_font_coordinates;
  }

  public int[][][] getPostOfficeCoordinates(int screenWidth, int screenHeight)
  {
    int i, j;
    double[] cord;
    this.viewing_matrix.identity();
    for (i = NUM_POLYGONS - 1; i >= 0; i--)
    {
      this.viewing_matrix.copyFromMatrix(this.polygon_matrices[i]);
      this.viewing_matrix.translate2D(offset);
      this.viewing_matrix.mathToApplet(screenWidth, screenHeight);
      for (j = 0; j < this.initial_coordinates[i][0].length; j++)
      {
        cord = this.viewing_matrix.transform(this.initial_coordinates[i][0][j],
                                             this.initial_coordinates[i][1][j]);
        this.appearance_coordinates[i][0][j] = (int) Math.round(cord[0]);
        this.appearance_coordinates[i][1][j] = (int) Math.round(cord[1]);
      }
    }
    return this.appearance_coordinates;
  }
}