// Situation
import java.util.*;


public class Situation
{
  public static final double DISTANCE = 160.0;
  public static final double CENTER_X = 200.0;
  public static final double CENTER_Y = 200.0;

  public int numberPeople;
  public int numberPostOffices;
  public int numberVisits;
  public double percentageMsgsNeeded;
  public Person persons[];
  public PostOffice postofices[];
  public Spy burglar;

  public int time;
  public long seed;
  public static final int MAX_DAYS = 5;
  public Random r;

  public Letter[] leters;
  public Letter[][][] sortedLeters;
  /* sl[i][j] is the list of all envelopes ever to be in post office i with person j's info. */
  public int[][] combo;
  public int[] combo_pon;
  public int[] combo_usize;

  public int[][] optimal_combo;
  public int[] optimal_pon;
  public int[] optimal_size;
  public int optimal_count;

  public double peep_poly[][];
  public double mail_poly[][];
  public double scale;

  public Situation(double scale)
  {
    this.scale = scale;
    r = new Random();
  }

  public void init(int on, int om, int ov, double of)
  {
    int i;
    numberPeople = on;
    numberPostOffices = om;
    numberVisits = ov;
    percentageMsgsNeeded = of;

    this.peep_poly = new double[2][numberPeople];
    FunShapes.makePolygon(DISTANCE, this.peep_poly);

    persons = new Person[on + 1];
    for (i = 1; i < persons.length; i++)
    {
      persons[i] = new Person(numberPeople, scale, i, this.peep_poly[0][i - 1] + CENTER_X,
                        this.peep_poly[1][i - 1] + CENTER_Y);
    }

    this.mail_poly = new double[2][numberPostOffices];
    FunShapes.makePolygon(0.5 * DISTANCE, this.mail_poly);

    postofices = new PostOffice[om + 1];
    for (i = 1; i < postofices.length; i++)
    {
      postofices[i] = new PostOffice(2 * numberPeople * numberPeople * numberPeople, 0.3 * scale,
                             this.mail_poly[0][i - 1] + CENTER_X,
                             this.mail_poly[1][i - 1] + CENTER_Y, i + "");
    }
    burglar = new Spy(numberPeople, numberPostOffices, percentageMsgsNeeded, numberVisits, scale, CENTER_X, CENTER_Y);
    combo = new int[numberPostOffices][numberPeople];
    combo_pon = new int[numberPostOffices];
    combo_usize = new int[numberPostOffices];

    optimal_combo = new int[numberPostOffices][numberPeople];
    optimal_pon = new int[numberPostOffices];
    optimal_size = new int[numberPostOffices];
    optimal_count = 0;
  }

  public void setItUp(int index, String s)
  {
    int st, en;
    String sp;

    st = s.indexOf('{');
    en = s.length() - 1;
    sp = s.substring(st + 1, en);
    System.out.print("Setting up person " + index + " with info:\n" + sp
                     + "\n\n");
    this.persons[index].setItUp(sp);
  }

  public void actOut(int option, long pit)
  {
    int noMailSentCount = 0;
    int maxNoMail = 100;
    // Note: msg is zero, ack is one in the access codes!
    int i, j, k;
    boolean good_to_go;
    int k_type, k_from;
    PsuedoRandom prg;

    if (option == 0)
    {
      prg = new PsuedoRandom(false);
    }
    else if (option == 1)
    {
      prg = new PsuedoRandom(true);
    }
    else
    {
      prg = new PsuedoRandom(pit, true);
    }

    this.seed = pit;
    this.resetEverything();
    // this.time = 0;
    if(Parser.verbose)
      System.out.print("Seed = " + this.seed + "\nDay = " + this.time + "\n");

    for (i = 1; i <= numberPeople; i++)
    {
      for (j = 0; j < this.persons[i].actList.length; j++)
      {
        /* If p[i].al[j].cause_list[0] is a start, do reaction type. */
        if ( (persons[i].actList[j].cause_list[0][0] == 0)
            && (persons[i].actList[j].cause_list[0][1] == 0))
        {
          for (k = 0; k < persons[i].actList[j].reaction.length; k++)
          {
            // Sending out each letter
            /* Upon each office getting a specific letter, write out all info, and use this.seed to specify # of days. */
            postofices[persons[i].actList[j].reaction[k].postOfficeIdUsed].addLetter(persons[i].actList[j].
                reaction[k]
                // , prg.nextInt(MAX_DAYS) + 1 /*(rand(seed) % 5) + 1*/
                );
          }
          // mark this event's occurence to true!
          persons[i].actList[j].happenedYet = true;
        }
      }
    }

    // Spy checks and decides if to break...!

    this.burglar.peekAround(postofices);

    // Repeat until every person got every message.
    while ( (this.burglar.has_won == false) && (allDoneYet() == false))
    {
      /* time++; Decrement # of days for each letter to be sent out. For each letter that has count 0, send it to the person.
         That person should update his msg,ack events list.
         Then, for each person, and each action that didn't happen yet, see if all valid conditions have been met. If so,
         do reactions. Set those event's markers to true!
       */

      this.time++;
      System.out.print("\nDay = " + this.time + "\n");

      boolean mailSent = false;
      for (i = 1; i <= numberPostOffices; i++)
      {

        mailSent |= postofices[i].updateTheMail(this.persons, i);

      }
      if(!mailSent)
      {
        noMailSentCount++;
        if(noMailSentCount >= maxNoMail)
        {
          System.out.println("NO MAIL HAS BEEN SENT FOR " + maxNoMail + " days!");
          System.out.print("\nHumanity is lost! Not Everyone got the message! GAME OVER!\n");

          return;
        }
      }
      else
      {
        noMailSentCount = 0;
      }



      for (i = 1; i <= numberPeople; i++)
      {
        if(Parser.verbose)
          System.out.print("Person " + i + ":\n");
        for (j = 1; j <= numberPeople; j++)
        {
          if(Parser.verbose)
            System.out.print("Msg from " + j + " = " + persons[i].eventsYet[j][0] +
                             ", ack from " + j + " = " + persons[i].eventsYet[j][1]
                             + "\n");
        }


        for (j = 0; j < this.persons[i].actList.length; j++)
        {

          if (persons[i].actList[j].happenedYet == false)
          {

            good_to_go = true;
            for (k = 0; k < persons[i].actList[j].cause_list.length; k++)
            {
              k_type = persons[i].actList[j].cause_list[k][0];
              k_from = persons[i].actList[j].cause_list[k][1];
              if (persons[i].eventsYet[k_from][k_type] == false)
              {
                good_to_go = false;
              }
            }
            if (good_to_go)
            {
              for (k = 0; k < persons[i].actList[j].reaction.length; k++)
              {
                postofices[persons[i].actList[j].reaction[k].postOfficeIdUsed].addLetter(persons[i].actList[j].
                    reaction[k]
                    // , prg.nextInt(MAX_DAYS) + 1 /*(rand(seed) % 5) + 1*/
                    );
              }
              persons[i].actList[j].happenedYet = true;
            }
          }

        }
      }

      // Spy checks and decides if to break...!
      this.burglar.peekAround(postofices);
    }

    if (this.burglar.has_won == false)
    {
      if(Parser.verbose)
      {
        System.out.print("\nEveryone successfully got their messages without leaking too much to the spy!\n");
        System.out.print("Total number of days: " + this.time
                         + "\nThe world is safe! THE END!\n");
      }

    }
    else
    {
      if(Parser.verbose)
        System.out.print("\nHumanity is lost! The Spy won! GAME OVER!\n");
    }
  }

  public void resetEverything()
  {
    int i, j, k;
    this.time = 0;
    for (i = 1; i <= numberPeople; i++)
    {
      for (j = 1; j <= numberPeople; j++)
      {
        if (i != j)
        {
          this.persons[i].eventsYet[j][0] = false;
          this.persons[i].eventsYet[j][1] = false;
        }
        else
        {
          this.persons[i].eventsYet[j][0] = true;
          this.persons[i].eventsYet[j][1] = false;
        }
      }

      for (j = 0; j < this.persons[i].actList.length; j++)
      {
        this.persons[i].actList[j].happenedYet = false;
        for (k = 0; k < this.persons[i].actList[j].reaction.length; k++)
        {
          this.persons[i].actList[j].reaction[k].isSentYet = false;
        }
      }
    }

    for (i = 1; i <= numberPostOffices; i++)
    {
      for (j = 0; j < this.postofices[i].mailBag.length; j++)
      {
        postofices[i].mailBag[j] = null;
      }
    }

    this.burglar.has_won = false;
  }

  public boolean allDoneYet()
  {
    int i, j;
    boolean aok = true;
    for (i = 1; i <= numberPeople; i++)
    {
      for (j = 1; j <= numberPeople; j++)
      {
        if (persons[i].eventsYet[j][0] == false)
        {
          aok = false;
        }
      }
    }
    return aok;
  }

  public void sortLetters(Letter[] larn)
  {
    int i, j, k, l;
    int tempco, spot;
    // boolean cond;
    this.leters = larn;
    this.sortedLeters = new Letter[numberPostOffices + 1][numberPeople + 1][];
    for (i = 1; i <= numberPostOffices; i++)
    {
      for (j = 1; j <= numberPeople; j++)
      {
        tempco = 0;
        // cond = false;
        for (k = 0; k < leters.length; k++)
        {
          if (leters[k].postOfficeIdUsed == i)
          {
            for (l = 0; l < leters[k].contents.length; l++)
            {
              if ( (leters[k].contents[l][0] == Letter.MESSAGE) &&
                  (leters[k].contents[l][1] == j))
              {
                tempco++;
              }
            }
          }
        }
        if (tempco > 0)
        {
          sortedLeters[i][j] = new Letter[tempco];
          spot = 0;
          for (k = 0; k < leters.length; k++)
          {
            if (leters[k].postOfficeIdUsed == i)
            {
              for (l = 0; l < leters[k].contents.length; l++)
              {
                if ( (leters[k].contents[l][0] == Letter.MESSAGE) &&
                    (leters[k].contents[l][1] == j))
                {
                  sortedLeters[i][j][spot] = leters[k];
                  spot++;
                }
              }
            }
          }
        }
        else
        {
          sortedLeters[i][j] = null;
        }
      }
    }
  }

  public void rigTheMail()
  {
    int u, i;
    int max;
    for (u = 0; u < optimal_combo.length; u++)
    {
      max = Letter.REALLY_LOW;
      for (i = 0; i < optimal_size[u]; i++)
      {
        if (leters[optimal_combo[u][i]].day > max)
        {
          max = leters[optimal_combo[u][i]].day;
        }
      }
      for (i = 0; i < optimal_size[u]; i++)
      {
        leters[optimal_combo[u][i]].daysToSend = 1
                                             + (max - leters[optimal_combo[u][i]].day);
        leters[optimal_combo[u][i]].consistKiddieDays();
      }
    }
  }

  public void assignBreakins()
  {
    int i, j, k;
    int por[] = new int[numberPostOffices];
    random_permutation_modification(por, por.length);
    for (i = 0; i < por.length; i++)
    {
      por[i]++;
    }
    for (i = 0; i < numberPostOffices; i++)
    {
      assignRandomLettersFromOffice(i, por[i]);
    }
  }

  public void assignRandomLettersFromOffice(int u, int i)
  {
    int j, k, l, io, uu, ui;
    boolean can_add = true;
    int count = 0;
    int pl_list[];
    int node_list[];

    combo_pon[u] = i;
    for (j = 1; j <= numberPeople; j++)
    {
      if (sortedLeters[i][j] != null)
      {
        count++;
      }
    }
    if (count > 0)
    {
      pl_list = new int[count];
      node_list = new int[count];
      random_permutation_modification(pl_list, pl_list.length);
      k = 0;
      for (j = 1; j <= numberPeople; j++)
      {
        if (sortedLeters[i][j] != null)
        {
          node_list[pl_list[k]] = sortedLeters[i][j][mod(r.nextInt(), sortedLeters[i][j].length)].
                                  lid;
          k++;
        }
      }

      /*
            combo[u][0] = node_list[0];
            combo_usize[u] = 1;
       */
      combo_usize[u] = 0;

      for (l = 0; l < node_list.length; l++)
      {
        can_add = true;
        for (io = 0; io < l; io++)
        {
          if ( (leters[node_list[io]].isAncestorOf(leters[node_list[l]])) ||
              (leters[node_list[l]].isAncestorOf(leters[node_list[io]])))
          {
            can_add = false;
          }
        }

        for (uu = 0; uu < u; uu++)
        {
          for (ui = 0; ui < combo_usize[uu]; ui++)
          {
            // System.out.println(combo[uu][ui]+" "+);
            if (leters[node_list[l]].isAncestorOf(leters[combo[uu][ui]]))
            {
              can_add = false;
            }
          }
        }

        if (can_add)
        {
          combo[u][combo_usize[u]] = node_list[l];
          combo_usize[u]++;
        }
      }
    }
    else
    {
      combo_usize[u] = 0;
    }
  }

  public int mod(int x, int y)
  {
    return ( (x % y) + y) % y;
  }

  public void random_permutation_modification(int[] dst, int l)
  {
    int i, j, temp;

    for (i = 0; i < l; i++)
    {
      dst[i] = i;
    }

    for (i = l - 1; i >= 0; i--)
    {
      j = mod(r.nextInt(), i + 1);
      temp = dst[i];
      dst[i] = dst[j];
      dst[j] = temp;
    }
  }

  public String showLetterInfo()
  {
    StringBuffer buffy = new StringBuffer("");
    int i, j, k;
    buffy.append("------THE MAIL SORTED BY PERSON INFO AND OFFICES------\n");
    for (i = 1; i <= numberPostOffices; i++)
    {
      for (j = 1; j <= numberPeople; j++)
      {
        buffy.append("Letters of Post Office " + i + " with Person " + j
                     + "'s info: ");
        if (sortedLeters[i][j] != null)
        {
          for (k = 0; k < sortedLeters[i][j].length; k++)
          {
            buffy.append(sortedLeters[i][j][k].lid + " ");
          }
        }
        else
        {
          buffy.append("None!");
        }
        buffy.append("\n");
      }
    }
    buffy.append("\n");
    return buffy.toString();
  }

  public String toString()
  {
    int i, j, k, l;
    StringBuffer buffy = new StringBuffer("");
    buffy.append("HERE'S THE SITUATION:\n");
    buffy.append("n = " + numberPeople + ", m = " + numberPostOffices + ", v = " + numberVisits + ", f = " + percentageMsgsNeeded
                 + "\n\n");
    for (i = 1; i < persons.length; i++)
    {
      buffy.append("Person " + i + ":\n");
      if (persons[i].hasOrders)
      {
        for (j = 0; j < persons[i].actList.length; j++)
        {
          buffy.append("\tUpon the events:\n");
          for (k = 0; k < persons[i].actList[j].cause_list.length; k++)
          {
            buffy.append("\t\t");
            if ( (persons[i].actList[j].cause_list[k][0] == 0)
                && (persons[i].actList[j].cause_list[k][1] == 0))
            {
              buffy.append("Start\n");
            }
            else
            {
              if (persons[i].actList[j].cause_list[k][0] == Letter.MESSAGE)
              {
                buffy.append("Getting a message with the info of person ");
              }
              else if (persons[i].actList[j].cause_list[k][0] == Letter.ACK)
              {
                buffy.append("Getting an acknowledgement of label ");
              }
              else
              {
                buffy.append("Getting unknown ");
              }
              buffy.append(persons[i].actList[j].cause_list[k][1] + "\n");
            }
          }

          buffy.append("\tWill perform the following actions:\n");
          for (k = 0; k < persons[i].actList[j].reaction.length; k++)
          {
            buffy.append("\t\tSend an envelope ");
            buffy.append("to person " + persons[i].actList[j].reaction[k].personTo +
                         " at post office "
                         + persons[i].actList[j].reaction[k].postOfficeIdUsed
                         + " containing:\n");
            for (l = 0; l < persons[i].actList[j].reaction[k].contents.length; l++)
            {
              buffy.append("\t\t\t");
              if (persons[i].actList[j].reaction[k].contents[l][0] == Letter.MESSAGE)
              {
                buffy.append("A message with info from person ");
              }
              else if (persons[i].actList[j].reaction[k].contents[l][0] == Letter.ACK)
              {
                buffy.append("An acknowledgement of label ");
              }
              else
              {
                buffy.append("An unknown with label ");
              }
              buffy.append(persons[i].actList[j].reaction[k].contents[l][1] + "\n");
            }
            /*
                if (p[i].al[j].reaction_type[k][0] == 0) {
                buffy.append("a message ");
                } else if (p[i].al[j].reaction_type[k][0] == 1) {
                buffy.append("an acknowledgement ");
                } else {
                buffy.append("an unknown ");
                }
                buffy.append("to person "+p[i].al[j].reaction_type[k][1]+
                  " at post office "+p[i].al[j].reaction_type[k][2]+"\n");
             */
          }
          buffy.append("\n");
        }
        buffy.append("\n");
      }
      else
      {
        buffy.append("\tHas no orders\n\n");
      }
    }
    return buffy.toString();
  }
}