/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class Server
extends Thread {
    private static final int DEFAULT_SERVER_READ_TIMEOUT = 1000;
    private static final int DEFAULT_CLIENT_READ_TIMEOUT = 1000;
    private static final int DEFAULT_NUM_RETRIES = 5;
    private final int port;
    private final ClientHandler handler;
    private final int serverTimeout;
    private final int clientTimeout;
    private final int numRetries;
    private ServerSocket ss;
    private boolean running;
    private int idxNextClient = 0;

    public Server(int port, ClientHandler handler) {
        this(port, handler, 1000, 1000, 5);
    }

    public Server(int port, ClientHandler handler, int serverTimeout, int clientTimeout, int numRetries) {
        this.port = port;
        this.handler = handler;
        this.serverTimeout = serverTimeout;
        this.clientTimeout = clientTimeout;
        this.numRetries = numRetries;
        this.setName("server");
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean b) {
        this.running = b;
    }

    @Override
    public void run() {
        Server.out("Server.run(): starting");
        this.setRunning(true);
        int numRetries = this.numRetries;
        while (this.isRunning()) {
            Server.out("Server.run(): opening server socket");
            try {
                try {
                    this.ss = new ServerSocket(this.port);
                    this.ss.setSoTimeout(this.serverTimeout);
                    numRetries = this.numRetries;
                    while (this.isRunning()) {
                        try {
                            Socket s = this.ss.accept();
                            try {
                                Client c = new Client(s);
                                c.start();
                                this.handler.newClient(c);
                            }
                            catch (Exception e) {
                                Server.out("Server.run(): exception: " + e);
                            }
                        }
                        catch (SocketTimeoutException s) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception e) {
                    Server.out("Server.run(): exception: " + e);
                    if (numRetries-- > 0) {
                        Server.out("Server.run(): will retry");
                    } else {
                        Server.out("Server.run(): giving up");
                        this.setRunning(false);
                    }
                    try {
                        if (this.ss == null) continue;
                        this.ss.close();
                        this.ss = null;
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.ss != null) {
                        this.ss.close();
                        this.ss = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (this.ss == null) continue;
                this.ss.close();
                this.ss = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Server.out("Server.run(): stopping");
    }

    private static void out(String s) {
        System.out.println(s);
    }

    public class Client
    extends Thread {
        private final Socket s;
        private final BufferedReader br;
        private final BufferedWriter bw;
        private final StringBuffer input;
        private boolean running;

        private Client(Socket s) throws IOException {
            this.s = s;
            s.setSoTimeout(Server.this.clientTimeout);
            this.br = new BufferedReader(new InputStreamReader(s.getInputStream()));
            this.bw = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
            this.input = new StringBuffer();
            StringBuilder stringBuilder = new StringBuilder("client");
            Server server2 = Server.this;
            int n = server2.idxNextClient;
            server2.idxNextClient = n + 1;
            this.setName(stringBuilder.append(n).toString());
        }

        public synchronized boolean isRunning() {
            return this.running;
        }

        public synchronized void setRunning(boolean b) {
            this.running = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getInput() {
            StringBuffer stringBuffer = this.input;
            synchronized (stringBuffer) {
                block4: {
                    if (this.input.length() != 0) break block4;
                    return null;
                }
                String s = this.input.toString();
                this.input.setLength(0);
                return s;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addInput(String s) {
            StringBuffer stringBuffer = this.input;
            synchronized (stringBuffer) {
                this.input.append(s);
                this.input.append("\n");
                Server.this.handler.newInputFromClient(this);
            }
        }

        public void write(String s) {
            try {
                this.bw.write(s);
                this.bw.flush();
            }
            catch (IOException e) {
                Server.out("Client.write(): exception: " + e);
                Server.this.handler.lostClient(this);
                Server.out("Client.write(): forcing stop");
                this.setRunning(false);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block22: {
                Server.out("Client.run(): starting");
                this.setRunning(true);
                try {
                    try {
                        while (this.isRunning()) {
                            try {
                                String line = this.br.readLine();
                                this.addInput(line);
                            }
                            catch (SocketTimeoutException line) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IOException e) {
                        Server.out("Client.run(): exception: " + e);
                        Server.this.handler.lostClient(this);
                        Server.out("Client.run(): forcing stop");
                        this.setRunning(false);
                        try {
                            if (this.br != null) {
                                this.br.close();
                            }
                            if (this.bw != null) {
                                this.bw.close();
                            }
                            if (this.s != null) {
                                this.s.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException) {}
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (this.br != null) {
                            this.br.close();
                        }
                        if (this.bw != null) {
                            this.bw.close();
                        }
                        if (this.s == null) throw throwable;
                        this.s.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (this.br != null) {
                        this.br.close();
                    }
                    if (this.bw != null) {
                        this.bw.close();
                    }
                    if (this.s != null) {
                        this.s.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Server.out("Client.run(): stopping");
        }
    }

    public static interface ClientHandler {
        public void newClient(Client var1);

        public void newInputFromClient(Client var1);

        public void lostClient(Client var1);
    }
}

