/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class DataAnalyzer {
    static final boolean DEBUG = false;
    static final int HI = 0;
    static final int MD = 1;
    static final int LO = 2;
    static final String[] LVLS = new String[]{"HI", "MD", "LO"};
    static final Random RND = new Random();
    static final DecimalFormat DF_INT = new DecimalFormat("000");
    static final DecimalFormat DF_RET = new DecimalFormat("00.00");
    static final DecimalFormat DF_PROB = new DecimalFormat("0.00");
    int nGambles;
    Gamble[] gambles;
    int attrFav1;
    int attrFav2;
    ArrayList gf1;
    ArrayList gf2;

    DataAnalyzer(String s) {
        this.readData(s);
        this.attrFav1 = 15;
        this.attrFav2 = 13;
        this.findFavGambles();
        DataAnalyzer.out("\n\n\ngambles w attr " + this.attrFav1 + ":\n");
        this.analyzeLinks(this.gf1);
        DataAnalyzer.out("\n\n\ngambles w attr " + this.attrFav2 + ":\n");
        this.analyzeLinks(this.gf2);
    }

    void analyzeLinks(ArrayList al) {
        DataAnalyzer.out("# gambles = " + al.size() + "\n");
        HashSet<Gamble[]> hs = new HashSet<Gamble[]>();
        int i = 0;
        while (i < al.size()) {
            Gamble g = (Gamble)al.get(i);
            hs.add(g.links);
            ++i;
        }
        DataAnalyzer.out("# linked groups = " + hs.size() + "\n");
        for (Gamble[] gg : hs) {
            DataAnalyzer.out("  group w/ " + gg.length + " link(s)  ");
            List<Gamble> list = Arrays.asList(gg);
            HashSet<Gamble> hs2 = new HashSet<Gamble>(list);
            DataAnalyzer.out("  # links in group = " + hs2.size() + "\n");
            for (Gamble g2 : hs2) {
                DataAnalyzer.out("    " + g2 + " ");
                int count = 0;
                int j = 0;
                while (j < gg.length) {
                    if (gg[j] == g2) {
                        ++count;
                    }
                    ++j;
                }
                DataAnalyzer.out(" occurs " + count + " time(s) ");
                if (g2.attr == this.attrFav1 || g2.attr == this.attrFav2) {
                    double[] ps = new double[]{g2.probs[0], g2.probs[1], g2.probs[2]};
                    ps[2] = ps[2] / 2.0;
                    ps[0] = ps[0] + ps[2];
                    double expRet = ps[0] * g2.rets[0] + ps[1] * g2.rets[1] + ps[2] * g2.rets[2];
                    DataAnalyzer.out(" expRet = " + DF_RET.format(expRet) + "\n");
                    continue;
                }
                DataAnalyzer.out("\n");
            }
        }
    }

    void findFavGambles() {
        this.gf1 = new ArrayList();
        this.gf2 = new ArrayList();
        int i = 0;
        while (i < this.nGambles) {
            if (this.gambles[i].attr == this.attrFav1) {
                this.gf1.add(this.gambles[i]);
            }
            if (this.gambles[i].attr == this.attrFav2) {
                this.gf2.add(this.gambles[i]);
            }
            ++i;
        }
    }

    void readData(String s) {
        DataAnalyzer.out("readData( " + s + " )\n");
        try {
            double[] dd;
            BufferedReader br = new BufferedReader(new FileReader(s));
            ArrayList[] als = new ArrayList[3];
            int i = 0;
            while (i < 3) {
                als[i] = new ArrayList();
                ++i;
            }
            int section = -1;
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.charAt(0) == '#') {
                    if (line.indexOf("gamble(") != -1) {
                        section = 0;
                        continue;
                    }
                    if (line.indexOf("gambleatts(") != -1) {
                        section = 1;
                        continue;
                    }
                    if (line.indexOf("link(") != -1) {
                        section = 2;
                        continue;
                    }
                    throw new RuntimeException("unexpected line in data file: " + line);
                }
                String[] ss = line.split("[, ]+");
                dd = new double[ss.length];
                int i2 = 0;
                while (i2 < ss.length) {
                    dd[i2] = Double.parseDouble(ss[i2]);
                    ++i2;
                }
                als[section].add(dd);
            }
            DataAnalyzer.debug("read " + als[0].size() + " gambles, " + als[1].size() + " attrs, " + als[2].size() + " links\n");
            if (als[0].size() != als[1].size()) {
                throw new RuntimeException("# gambles != # attrs");
            }
            this.nGambles = als[0].size();
            this.gambles = new Gamble[this.nGambles];
            int i3 = 0;
            while (i3 < this.nGambles) {
                double[] ddg = (double[])als[0].get(i3);
                double[] dda = (double[])als[1].get(i3);
                if (ddg[0] != (double)i3 || dda[0] != (double)i3) {
                    throw new RuntimeException("gambles or attrs not in order");
                }
                if (ddg.length != 7 || dda.length != 5) {
                    throw new RuntimeException("wrong # of tokens in gamble or attr " + i3);
                }
                double[] rets = new double[]{ddg[1], ddg[3], ddg[5]};
                double[] probs = new double[]{ddg[2], ddg[4], ddg[6]};
                DataAnalyzer.normalize(probs);
                int attr = 0;
                int j = 1;
                while (j < 5) {
                    if (dda[j] != 0.0) {
                        if (dda[j] == 1.0) {
                            attr += 1 << 4 - j;
                        } else {
                            throw new RuntimeException("non-binary attr for " + i3);
                        }
                    }
                    ++j;
                }
                this.gambles[i3] = new Gamble(i3, probs, rets, attr);
                ++i3;
            }
            i3 = 0;
            while (i3 < als[2].size()) {
                dd = (double[])als[2].get(i3);
                Object[] links1 = this.gambles[(int)dd[0]].links;
                Object[] links2 = this.gambles[(int)dd[1]].links;
                if (links1 != links2) {
                    Gamble[] links3 = (Gamble[])DataAnalyzer.merge(links1, links2);
                    int j = 0;
                    while (j < links1.length) {
                        ((Gamble)links1[j]).links = links3;
                        ++j;
                    }
                    j = 0;
                    while (j < links2.length) {
                        ((Gamble)links2[j]).links = links3;
                        ++j;
                    }
                }
                ++i3;
            }
        }
        catch (Exception e) {
            DataAnalyzer.out("exception reading returns and links: " + e + "\n");
            e.printStackTrace();
            DataAnalyzer.out("exiting\n");
            System.exit(1);
        }
    }

    static Object merge(Object[] in1, Object[] in2) {
        Class<?> c = in1[0].getClass();
        int len = in1.length + in2.length;
        Object[] out = (Object[])Array.newInstance(c, len);
        int count = 0;
        int i = 0;
        while (i < in1.length) {
            out[count++] = in1[i];
            ++i;
        }
        i = 0;
        while (i < in2.length) {
            out[count++] = in2[i];
            ++i;
        }
        return out;
    }

    static void normalize(double[] d) {
        double total = 0.0;
        int i = 0;
        while (i < d.length) {
            total += d[i];
            ++i;
        }
        i = 0;
        while (i < d.length) {
            int n = i++;
            d[n] = d[n] / total;
        }
    }

    static String arrayStr(double[] dd, DecimalFormat df) {
        StringBuffer sb = new StringBuffer(dd.length * (df.toPattern().length() + 1));
        int i = 0;
        while (i < dd.length) {
            sb.append(df.format(dd[i])).append(' ');
            ++i;
        }
        return sb.toString();
    }

    static void debug(String s) {
    }

    static void out(String s) {
        System.out.print(s);
        System.out.flush();
    }

    public static void main(String[] args) {
        new DataAnalyzer(args[0]);
    }

    class Gamble {
        final int id;
        final double[] probs;
        final double[] rets;
        final int attr;
        final String s;
        Gamble[] links = new Gamble[]{this};
        Outcome[] outcomes = new Outcome[0];

        Gamble(int id, double[] probs, double[] rets, int attr) {
            this.id = id;
            this.probs = probs;
            this.rets = rets;
            this.attr = attr;
            this.s = "id=" + DF_INT.format(id) + " p={ " + DataAnalyzer.arrayStr(probs, DF_PROB) + "}" + " r={ " + DataAnalyzer.arrayStr(rets, DF_RET) + "}" + " a=" + (attr < 10 ? " " : "") + attr;
        }

        public String toString() {
            return this.s;
        }
    }

    class Outcome {
        final int idx;
        final int attrSway;
        final int[] lnkLvls;
        final double[] probs;
        final double rnd;
        final int lvl;
        final double pyf;
        final String s;

        Outcome(int idx, int attrSway, int[] lnkLvls, double[] probs, double rnd, int lvl, double pyf) {
            this.idx = idx;
            this.attrSway = attrSway;
            this.lnkLvls = lnkLvls;
            this.probs = probs;
            this.rnd = rnd;
            this.lvl = lvl;
            this.pyf = pyf;
            this.s = "@=" + DF_INT.format(idx) + " a=" + attrSway + " l=" + lnkLvls[0] + lnkLvls[1] + lnkLvls[2] + " p={ " + DataAnalyzer.arrayStr(probs, DF_PROB) + "}" + " r=" + DF_PROB.format(rnd) + " l=" + LVLS[lvl] + " p=" + DF_RET.format(pyf);
        }

        public String toString() {
            return this.s;
        }
    }
}

