/*
 * Decompiled with CFR 0.152.
 */
package optimalMove;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import optimalMove.Ply;
import optimalMove.Torques;
import optimalMove.WeightBounds;
import optimalMove.WeightSet;
import optimalMove.boardState;
import optimalMove.weightPlacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class rPhaseState
extends boardState {
    protected Vector<Integer> empty_positions = new Vector();
    protected Vector<Integer> available_weights = new Vector();
    protected Torques torques = new Torques(0, 0);
    protected Ply next_ply = new Ply(Ply.Ownership.Mine);
    protected WeightBounds weight_bounds;

    public rPhaseState() {
        this.next_ply = new Ply(Ply.Ownership.Mine);
        this.weight_positions = new TreeMap();
        this.available_weights = new Vector();
        this.empty_positions = new Vector();
        this.weight_bounds = new WeightBounds();
        this.torques = new Torques(0, 0);
        int weight = 1;
        while (weight <= WeightSet.MAXWEIGHT) {
            this.available_weights.add(weight);
            this.available_weights.add(weight);
            ++weight;
        }
        this.available_weights.add(3);
        int position = -15;
        while (position <= 15) {
            this.empty_positions.add(position);
            ++position;
        }
        weightPlacement board_weight = new weightPlacement(3, 0);
        this.torques.update_torque(board_weight);
    }

    public rPhaseState(Map<Integer, Integer> wp) {
        this();
        for (Map.Entry<Integer, Integer> entry : wp.entrySet()) {
            weightPlacement new_weight = new weightPlacement(entry.getValue(), entry.getKey());
            this.add_weight(new_weight);
        }
    }

    Vector<Integer> get_empty_positions() {
        Vector<Integer> ep = new Vector();
        ep = this.empty_positions;
        return ep;
    }

    public rPhaseState(Vector<Integer> e_p, Vector<Integer> a_w, Torques tq, Ply n_p, WeightBounds w_b, Map<Integer, Integer> w_p) {
        this.empty_positions = (Vector)e_p.clone();
        this.available_weights = a_w;
        this.torques = tq;
        this.next_ply = n_p;
        this.weight_bounds = w_b;
        this.weight_positions = w_p;
    }

    public rPhaseState(rPhaseState other) {
        super(other);
        this.empty_positions.addAll(other.empty_positions);
        this.weight_bounds = new WeightBounds(other.weight_bounds);
        this.available_weights.addAll(other.available_weights);
        this.torques = new Torques(other.torques);
        this.next_ply = new Ply(other.next_ply);
        this.weight_positions.putAll(other.weight_positions);
    }

    public void add_weight(weightPlacement new_weight) {
        this.weight_positions.put(new_weight.location, new_weight.weight);
        this.empty_positions.removeElement(new_weight.location);
        this.available_weights.removeElement(new_weight.weight);
        this.torques.update_torque(new_weight);
        this.next_ply.reverse();
        this.weight_bounds = this.torques.addition_wb_lookup();
    }

    public void remove_weight(int location) {
        int weight = (Integer)this.weight_positions.get(location);
        this.weight_positions.remove(location);
        this.empty_positions.add(location);
        this.available_weights.add(weight);
        weightPlacement pw = new weightPlacement(-weight, location);
        this.torques.update_torque(pw);
        this.next_ply.reverse();
        this.weight_bounds = this.torques.wb_lookup();
    }

    public ArrayList<rPhaseState> non_tipping_children() {
        ArrayList<rPhaseState> children = new ArrayList<rPhaseState>();
        for (Map.Entry entry : this.weight_positions.entrySet()) {
            if ((Integer)entry.getValue() > this.weight_bounds.get((Integer)entry.getKey())) continue;
            rPhaseState child = new rPhaseState(this);
            child.remove_weight((Integer)entry.getKey());
            children.add(child);
        }
        return children;
    }

    public ArrayList<weightPlacement> non_tipping_moves() {
        ArrayList<weightPlacement> moves = new ArrayList<weightPlacement>();
        for (Map.Entry entry : this.weight_positions.entrySet()) {
            if ((Integer)entry.getValue() > this.weight_bounds.get((Integer)entry.getKey())) continue;
            weightPlacement wp = new weightPlacement((Integer)entry.getValue(), (Integer)entry.getKey());
            moves.add(wp);
        }
        return moves;
    }

    public weightPlacement a_legal_move() {
        TreeMap nav_weight_positions = new TreeMap(this.weight_positions);
        weightPlacement move = new weightPlacement((Integer)nav_weight_positions.firstEntry().getValue(), (Integer)nav_weight_positions.firstKey());
        return move;
    }

    public int num_nontipping_children() {
        int num_children = 0;
        for (Map.Entry entry : this.weight_positions.entrySet()) {
            if ((Integer)entry.getValue() > this.weight_bounds.get((Integer)entry.getKey())) continue;
            ++num_children;
        }
        return num_children;
    }

    public void set_ply(Ply.Ownership p) {
        this.next_ply = new Ply(p);
    }

    public String toString() {
        String s = new String();
        int location = -15;
        while (location < 16) {
            s = this.weight_positions.containsKey(location) ? s.concat(Integer.toHexString((Integer)this.weight_positions.get(location))) : s.concat(Integer.toHexString(0));
            ++location;
        }
        return s;
    }

    public int removal_needed(rPhaseState child) {
        Vector<Integer> emptier_positions = new Vector<Integer>(child.empty_positions);
        emptier_positions.removeAll(this.empty_positions);
        return emptier_positions.get(0);
    }
}

