/*
 * Decompiled with CFR 0.152.
 */
package optimalMove;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import optimalMove.Ply;
import optimalMove.WeightSet;
import optimalMove.rPhaseState;
import optimalMove.weightPlacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPhaseState
extends rPhaseState {
    protected Vector<Integer> my_avail_weights = new Vector();
    protected Vector<Integer> opp_avail_weights = new Vector();

    public AddPhaseState(Ply.Ownership first_ply) {
        int weight = 1;
        while (weight <= WeightSet.MAXWEIGHT) {
            this.my_avail_weights.add(weight);
            this.opp_avail_weights.add(weight);
            ++weight;
        }
        if (first_ply.equals((Object)Ply.Ownership.Mine)) {
            this.next_ply = new Ply(Ply.Ownership.Opponents);
            this.opp_avail_weights.add(3);
        } else if (first_ply.equals((Object)Ply.Ownership.Opponents)) {
            this.next_ply = new Ply(Ply.Ownership.Mine);
            this.my_avail_weights.add(3);
        }
        weightPlacement board_balance = new weightPlacement(3, -4);
        this.add_weight(board_balance);
    }

    public AddPhaseState(AddPhaseState other) {
        super(other);
        this.my_avail_weights.addAll(other.my_avail_weights);
        this.opp_avail_weights.addAll(other.opp_avail_weights);
    }

    @Override
    public void add_weight(weightPlacement new_weight) {
        super.add_weight(new_weight);
        if (this.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
            this.my_avail_weights.removeElement(new_weight.weight);
        } else if (this.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
            this.opp_avail_weights.removeElement(new_weight.weight);
        }
    }

    public void add_weight_verbose(weightPlacement new_weight) {
        super.add_weight(new_weight);
        if (this.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
            this.my_avail_weights.removeElement(new_weight.weight);
        } else if (this.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
            this.opp_avail_weights.removeElement(new_weight.weight);
        }
        System.out.print("After addition, I have ");
        System.out.print(this.my_avail_weights.size());
        System.out.print(" weights avail and Opp has");
        System.out.println(this.opp_avail_weights.size());
    }

    public ArrayList<AddPhaseState> non_tipping_addition_children() {
        ArrayList<AddPhaseState> children = new ArrayList<AddPhaseState>();
        Vector<Object> curr_avail_weights = new Vector();
        if (this.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
            curr_avail_weights = this.my_avail_weights;
        } else if (this.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
            curr_avail_weights = this.opp_avail_weights;
        }
        Collections.sort(curr_avail_weights);
        Iterator empty_pos_it = this.empty_positions.iterator();
        block0: while (empty_pos_it.hasNext()) {
            int curr_position = (Integer)empty_pos_it.next();
            int curr_bound = this.weight_bounds.get(curr_position);
            Iterator<Object> avail_weights_it = curr_avail_weights.iterator();
            while (avail_weights_it.hasNext()) {
                int curr_weight = (Integer)avail_weights_it.next();
                if (curr_weight > curr_bound) continue block0;
                AddPhaseState child = new AddPhaseState(this);
                weightPlacement wp = new weightPlacement(curr_weight, curr_position);
                child.add_weight(wp);
                children.add(child);
            }
        }
        return children;
    }

    public int num_nontipping_addition_children() {
        int num_children = 0;
        Vector<Object> curr_avail_weights = new Vector();
        if (this.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
            curr_avail_weights = this.my_avail_weights;
        } else if (this.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
            curr_avail_weights = this.opp_avail_weights;
        }
        Collections.sort(curr_avail_weights);
        Iterator empty_pos_it = this.empty_positions.iterator();
        block0: while (empty_pos_it.hasNext()) {
            int curr_position = (Integer)empty_pos_it.next();
            int curr_bound = this.weight_bounds.get(curr_position);
            Iterator<Object> avail_weights_it = curr_avail_weights.iterator();
            while (avail_weights_it.hasNext()) {
                int curr_weight = (Integer)avail_weights_it.next();
                if (curr_weight > curr_bound) continue block0;
                AddPhaseState child = new AddPhaseState(this);
                weightPlacement wp = new weightPlacement(curr_weight, curr_position);
                child.add_weight(wp);
                ++num_children;
            }
        }
        return num_children;
    }

    public ArrayList<weightPlacement> non_tipping_addition_moves() {
        ArrayList<weightPlacement> moves = new ArrayList<weightPlacement>();
        Vector<Object> curr_avail_weights = new Vector();
        if (this.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
            curr_avail_weights = this.my_avail_weights;
        } else if (this.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
            curr_avail_weights = this.opp_avail_weights;
        }
        Collections.sort(curr_avail_weights);
        Iterator empty_pos_it = this.empty_positions.iterator();
        block0: while (empty_pos_it.hasNext()) {
            int curr_position = (Integer)empty_pos_it.next();
            int curr_bound = this.weight_bounds.get(curr_position);
            Iterator<Object> avail_weights_it = curr_avail_weights.iterator();
            while (avail_weights_it.hasNext()) {
                int curr_weight = (Integer)avail_weights_it.next();
                if (curr_weight > curr_bound) continue block0;
                weightPlacement wp = new weightPlacement(curr_weight, curr_position);
                moves.add(wp);
            }
        }
        return moves;
    }

    @Override
    public weightPlacement a_legal_move() {
        Vector<Object> curr_avail_weights = new Vector();
        if (this.next_ply.Whose.equals((Object)Ply.Ownership.Mine)) {
            curr_avail_weights = this.my_avail_weights;
        } else if (this.next_ply.Whose.equals((Object)Ply.Ownership.Opponents)) {
            curr_avail_weights = this.opp_avail_weights;
        }
        Collections.sort(curr_avail_weights);
        int an_empty_position = (Integer)this.empty_positions.firstElement();
        int an_avail_weight = (Integer)curr_avail_weights.firstElement();
        weightPlacement move = new weightPlacement(an_avail_weight, an_empty_position);
        return move;
    }

    public weightPlacement addition_needed(AddPhaseState child) {
        Vector more_empty_positions = new Vector(this.empty_positions);
        more_empty_positions.removeAll(child.empty_positions);
        weightPlacement wp = new weightPlacement((Integer)child.weight_positions.get(more_empty_positions.get(0)), (Integer)more_empty_positions.get(0));
        return wp;
    }
}

