//all_path_visitor.h
#pragma once

#include <vector>

#include <boost/property_map.hpp>
#include <boost/graph/adjacency_list.hpp>
#include <boost/graph/depth_first_search.hpp>

#include "GraphGrepSXLibrary.h"
#include "OCP_Tree.h"

namespace GraphGrepSXLibrary {

// visitor types
typedef std::pair<vertex_t, out_edge_it> stack_item_t;
typedef std::map<vertex_t, out_edge_it> map_edge_it_t;

// class my_stack 
// used for optimize push pop operation over std:vector
class my_stack
{
public:
	my_stack();
public:
	//void init();
	void push_back(stack_item_t *item);
	void pop_back();
	stack_item_t* back();
	void clear();
	bool empty();
private:
	int m_index;
	std::vector<stack_item_t*> m_stack;
};

my_stack::my_stack()
{
	m_index=-1;
	m_stack.resize(max_depth);
}

void my_stack::push_back(stack_item_t *item)
{	
	assert(m_index!=max_depth);
	m_index++;
	m_stack.at(m_index)=item;
}

void my_stack::pop_back()
{
	assert(m_index!=-1);
	m_index--;
}

stack_item_t* my_stack::back()
{
	return m_stack[m_index];
}

void my_stack::clear()
{
	m_index = -1;
}

bool my_stack::empty()
{
	return m_index < 0 ? true : false;
}

// visitor: it finds all path starting from every node of the graphs
// adding corrispondent feature to features' map, i.e. if added ADDB during
// graph traversing ALSO feature like ADD or AD, or A will be added later.
class all_path_visitor
{
public:
	all_path_visitor(const graph_index_t &i, OCP_Tree* _index_tree)
	{		
			index_tree=_index_tree;
			graph_index = i;
	}
public:
	template <class Vertex, class Graph> void
	start_vertex(Vertex v, const Graph &g)
	{
		char label = get(vertex_color, g, v);
		current_node=index_tree->root->add_child(label, graph_index);
		current_node->occurrences[graph_index]++;
	}
	template <class Vertex, class Graph> void
	discover_vertex(Vertex v, const Graph &g)
	{
		char label = get(vertex_color, g, v);
		current_node=current_node->add_child(label, graph_index);
		current_node->occurrences[graph_index]++;
	}
	template <class Vertex, class Graph> void
	finish_vertex(Vertex v, const Graph &g)
	{
		current_node=current_node->parent;
	}
private:
	OCP_Tree* index_tree;
	OCP_Tree_Node* current_node;
	graph_index_t graph_index;
};

// visitor: it finds unique path starting from every node of the graphs
// adding corrispondent feature to features' map, i.e. if added ADDB during
// graph traversing NO feature like ADD or AD, or A will be added later.
class one_path_visitor
{
public:
	one_path_visitor(const graph_index_t &i, OCP_Tree* _index_tree)
	{		
			index_tree=_index_tree;
			graph_index = i;
	}
public:
	template <class Vertex, class Graph> void
	start_vertex(Vertex v, const Graph &g)
	{
		v_set.clear();
		
		char label = get(vertex_color, g, v);
		current_node=index_tree->root->add_child(label, graph_index);

	}
	template <class Vertex, class Graph> void
	discover_vertex(Vertex v, const Graph &g)
	{
		v_set.insert(current_node);
		char label = get(vertex_color, g, v);
		current_node=current_node->add_child(label, graph_index);
	}
	template <class Vertex, class Graph> void
	finish_vertex(Vertex v, const Graph &g)
	{
		v_set_it=v_set.find(current_node);
		if(v_set_it==v_set.end()){
			current_node->is_special=true;
			current_node->occurrences[graph_index]++;
		}
		else
			v_set.erase(v_set_it);
		current_node=current_node->parent;
	}
private:
	OCP_Tree* index_tree;
	OCP_Tree_Node* current_node;
	graph_index_t graph_index;
	std::set<OCP_Tree_Node*> v_set;
	std::set<OCP_Tree_Node*>::iterator v_set_it;

};
}// end name_space
