// GraphGrepSXLibrary.h
#pragma once

#include <boost/graph/adjacency_list.hpp>

using namespace std;
using namespace boost;

namespace GraphGrepSXLibrary {

// Path types
typedef char node_label_t;
typedef std::vector<node_label_t> path_t;

// Vertex properties
typedef property < vertex_color_t, node_label_t> vertex_p;

// Edge properties
typedef property < edge_weight_t, double > edge_p;

// Graph properties
typedef property < graph_name_t, std::string > graph_p;
// Graph types
typedef int graph_index_t;   //graph index (da verificare)
typedef std::vector<graph_index_t> vect_index_t; 

typedef set<graph_index_t> graph_set_t;

// adjacency_list-based type
typedef adjacency_list < vecS, vecS, undirectedS, vertex_p, edge_p, graph_p> graph_t;
typedef graph_traits<graph_t>::vertex_descriptor vertex_t;
typedef graph_traits<graph_t>::edge_descriptor edge_t;
typedef graph_traits<graph_t>::vertex_iterator vertex_it;
typedef graph_traits<graph_t>::edge_iterator edge_it;
typedef graph_traits<graph_t>::out_edge_iterator out_edge_it;

typedef  graph_traits<graph_t>::vertex_iterator vertex_i;
typedef  graph_traits<graph_t>::adjacency_iterator adjacency_i;

const int max_depth = 4; //max traversal depth-max_feature length

}// end name_space

