#ifndef _STRUCTANTIPOLE
#define _STRUCTANTIPOLE

#include "constants.h"

/* 
   Object in vector space model;
   index = real index;
   mark  = it is TRUE if during the search is alread visited
   *X    = Features vector;   
   *Dv   = Distance Vector from the antipole 
   Dc    = Distance from the Centroid Cluster;
*/

typedef struct OBJECT{
  int *index;
  float *X; 
  int *idx_CLU;
  float *Dv;
  float Dc;
  int   dvS;
  float Do;
}Object;



/* Cluster of objects
   
   Centroid = Representant of the cluster
   Elements = Cluster members
   radius   = Cluster radius
   size     = Cluster size;
   struct Cluster Next = Pointer to the next cluster in the clustered space
                         Must be used during the search only over the clusters
*/


typedef struct C_POINTER{
  struct CLUSTER *N;
  struct C_POINTER *next;

}C_Pointer;

typedef struct CLUSTER{
  Object *Elements;
  Object *Centroid;
  float radius;
  int   size;
  int   idx_CLU;
  struct C_POINTER *neighbor;
  struct CLUSTER   *next;
  struct Worst_Tree *tree_node;
  int saturated;
  float *Dv;
}Cluster;



/* Worst Tree node:
  
   A B = Pointers to the furthest pair of the set;
   Dab = Distance between A and B;
   start = Starting point in the set of object   
   end   = End point of the set of object covered in the sub tree 
   SizeA = Size of the left child of the node
   SizeB = Size of the right child of the node
   Size  = Size of the tree rooted at this node
   Left Right = pointers to the left and right childrens
   clust = Pointer to the cluster of the node. It is != NULL if the node is a leaf
   lead  = Boolend filed it is TRUE only if the node is a leaf
*/



typedef struct Worst_Tree{
  Object *A;
  Object *B;
  float Dab;
  float RadA;  
  float RadB;  
  
  int start;  
  int end;    
  int SizeA;  
  int SizeB;  
  int Size;   

  struct Worst_Tree *pred;
  struct Worst_Tree *left;
  struct Worst_Tree *right;
  Cluster *clust;         
  Object *Centroid;       
  float *Rc;              
  unsigned int leaf;      
  unsigned int LEAFNUM;
}W_Tree;


int n;                 // number of data graphs
int SpaceDim;          // number of substructures
Cluster *C_List;       // used for Antipole Tree
W_Tree *Tree;          // Antipole Tree

int TOTAL;             // number of clusters generated by the Antipole Tree data structure
Object *S;             // Elements of the Antipole Tree
float d;               // radius for Antipole
char choice;           // 'I' for inner product and 'E' for Euclidean distance

int **MAPPA;           // It cointans the n Spacedim vectors
char **words;          // substructures generated with AllPairShortestPath
int **len_words;       // length of label substructures
int cont_words;        // number of substructures
int *loc_con;          // progressive number of substructures for each data graph
char directed;         // 'd' for directed graphs, 'u' for undirected graphs


#endif
