#include "printKmeans.h"



/*
  It takes the Kmeans structure, the number of generated clusters, the names of the input graphs
  and a descriptor file *fp and
  writes the output in *fp
*/

void Write_Output(Cluster *G,int num_clusters,char **name,FILE *fp) {
  int i,j;
  for(i=0;i<num_clusters;i++) {
    fprintf(fp,"CLUSTER %d [size:%d radius:%f]\n",i+1,G[i].size,G[i].radius);
    fprintf(fp,"     Centroid : '%s'\n",name[*S[G[i].Centroid].index]);
    for(j=0;j<G[i].size;j++) {
      if(*S[G[i].Elements[j]].index != *S[G[i].Centroid].index)
	fprintf(fp,"     Element  : '%s' [Dc:%f]\n",name[*S[G[i].Elements[j]].index],G[i].Dc[j]);
    }
    fprintf(fp,"\n");
  }
}
